/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.ApiSupport;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.CommandOperation;

public abstract class BaseHandlerApiSupport
implements ApiSupport {
    protected final Map<SolrRequest.METHOD, Map<V2EndPoint, List<ApiCommand>>> commandsMapping = new HashMap<SolrRequest.METHOD, Map<V2EndPoint, List<ApiCommand>>>();

    protected BaseHandlerApiSupport() {
        for (ApiCommand cmd : this.getCommands()) {
            List<ApiCommand> list;
            Map<V2EndPoint, List<ApiCommand>> m = this.commandsMapping.get(cmd.getHttpMethod());
            if (m == null) {
                m = new HashMap<V2EndPoint, List<ApiCommand>>();
                this.commandsMapping.put(cmd.getHttpMethod(), m);
            }
            if ((list = m.get(cmd.getEndPoint())) == null) {
                list = new ArrayList<ApiCommand>();
                m.put(cmd.getEndPoint(), list);
            }
            list.add(cmd);
        }
    }

    @Override
    public synchronized Collection<Api> getApis() {
        ImmutableList.Builder l = ImmutableList.builder();
        for (V2EndPoint op : this.getEndPoints()) {
            l.add((Object)this.getApi(op));
        }
        return l.build();
    }

    private Api getApi(final V2EndPoint op) {
        final BaseHandlerApiSupport apiHandler = this;
        return new Api(ApiBag.getSpec(op.getSpecName())){

            @Override
            public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
                SolrParams params = req.getParams();
                SolrRequest.METHOD method = SolrRequest.METHOD.valueOf((String)req.getHttpMethod());
                List<ApiCommand> commands = BaseHandlerApiSupport.this.commandsMapping.get(method).get(op);
                try {
                    if (method == SolrRequest.METHOD.POST) {
                        List<CommandOperation> cmds = req.getCommands(true);
                        if (cmds.size() > 1) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only one command is allowed");
                        }
                        CommandOperation c = cmds.size() == 0 ? null : cmds.get(0);
                        ApiCommand command = null;
                        String commandName = c == null ? null : c.name;
                        for (ApiCommand cmd : commands) {
                            if (!Objects.equals(cmd.getName(), commandName)) continue;
                            command = cmd;
                            break;
                        }
                        if (command == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, " no such command " + c);
                        }
                        BaseHandlerApiSupport.wrapParams(req, c, command, false);
                        command.invoke(req, rsp, apiHandler);
                    } else {
                        if (commands == null || commands.isEmpty()) {
                            rsp.add("error", "No support for : " + method + " at :" + req.getPath());
                            return;
                        }
                        if (commands.size() > 1) {
                            for (ApiCommand command : commands) {
                                if (!command.getName().equals(req.getPath())) continue;
                                commands = Collections.singletonList(command);
                                break;
                            }
                        }
                        BaseHandlerApiSupport.wrapParams(req, new CommandOperation("", Collections.EMPTY_MAP), commands.get(0), true);
                        commands.get(0).invoke(req, rsp, apiHandler);
                    }
                }
                catch (SolrException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
                finally {
                    req.setParams(params);
                }
            }
        };
    }

    private static void wrapParams(SolrQueryRequest req, final CommandOperation co, final ApiCommand cmd, final boolean useRequestParams) {
        final Map<String, String> pathValues = req.getPathTemplateValues();
        final Map<String, Object> map = co == null || !(co.getCommandData() instanceof Map) ? Collections.singletonMap("", co.getCommandData()) : co.getDataMap();
        final SolrParams origParams = req.getParams();
        req.setParams(new SolrParams(){

            public String get(String param) {
                Object vals = this.getParams0(param);
                if (vals == null) {
                    return null;
                }
                if (vals instanceof String) {
                    return (String)vals;
                }
                if (vals instanceof Boolean || vals instanceof Number) {
                    return String.valueOf(vals);
                }
                if (vals instanceof String[] && ((String[])vals).length > 0) {
                    return ((String[])vals)[0];
                }
                return null;
            }

            private Object getParams0(String param) {
                Object o;
                Object object = o = (param = cmd.getParamSubstitute(param)).indexOf(46) > 0 ? Utils.getObjectByPath((Map)map, (boolean)true, (List)StrUtils.splitSmart((String)param, (char)'.')) : map.get(param);
                if (o == null) {
                    o = pathValues.get(param);
                }
                if (o == null && useRequestParams) {
                    o = origParams.getParams(param);
                }
                if (o instanceof List) {
                    List l = (List)o;
                    return l.toArray(new String[l.size()]);
                }
                return o;
            }

            public String[] getParams(String param) {
                String[] stringArray;
                Object vals = this.getParams0(param);
                if (vals == null || vals instanceof String[]) {
                    stringArray = (String[])vals;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = vals.toString();
                }
                return stringArray;
            }

            public Iterator<String> getParameterNamesIterator() {
                return cmd.getParamNames(co).iterator();
            }
        });
    }

    public static Collection<String> getParamNames(CommandOperation op, ApiCommand command) {
        ArrayList<String> result = new ArrayList<String>();
        Object o = op.getCommandData();
        if (o instanceof Map) {
            Map map = (Map)o;
            BaseHandlerApiSupport.collectKeyNames(map, result, "");
        }
        return result;
    }

    public static void collectKeyNames(Map<String, Object> map, List<String> result, String prefix) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() instanceof Map) {
                BaseHandlerApiSupport.collectKeyNames((Map)e.getValue(), result, prefix + e.getKey() + ".");
                continue;
            }
            result.add(prefix + e.getKey());
        }
    }

    protected abstract List<ApiCommand> getCommands();

    protected abstract List<V2EndPoint> getEndPoints();

    public static interface V2EndPoint {
        public String getSpecName();
    }

    public static interface ApiCommand {
        public String getName();

        public SolrRequest.METHOD getHttpMethod();

        public V2EndPoint getEndPoint();

        default public Collection<String> getParamNames(CommandOperation op) {
            return BaseHandlerApiSupport.getParamNames(op, this);
        }

        default public String getParamSubstitute(String name) {
            return name;
        }

        public void invoke(SolrQueryRequest var1, SolrQueryResponse var2, BaseHandlerApiSupport var3) throws Exception;
    }
}

