/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.tukaani.xz.BCJDecoder;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.CountingInputStream;
import org.tukaani.xz.DeltaDecoder;
import org.tukaani.xz.FilterCoder;
import org.tukaani.xz.FilterDecoder;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.LZMA2Decoder;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.RawCoder;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;

class BlockInputStream
extends InputStream {
    private final DataInputStream inData;
    private final CountingInputStream inCounted;
    private InputStream filterChain;
    private final Check check;
    private final boolean verifyCheck;
    private long uncompressedSizeInHeader = -1L;
    private long compressedSizeInHeader = -1L;
    private long compressedSizeLimit;
    private final int headerSize;
    private long uncompressedSize = 0L;
    private boolean endReached = false;
    private final byte[] tempBuf = new byte[1];

    public BlockInputStream(InputStream inputStream, Check check, boolean bl, int n, long l, long l2) throws IOException, IndexIndicatorException {
        int n2;
        long l3;
        int n3;
        this.check = check;
        this.verifyCheck = bl;
        this.inData = new DataInputStream(inputStream);
        byte[] byArray = new byte[1024];
        this.inData.readFully(byArray, 0, 1);
        if (byArray[0] == 0) {
            throw new IndexIndicatorException();
        }
        this.headerSize = 4 * ((byArray[0] & 0xFF) + 1);
        this.inData.readFully(byArray, 1, this.headerSize - 1);
        if (!DecoderUtil.isCRC32Valid(byArray, 0, this.headerSize - 4, this.headerSize - 4)) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        if ((byArray[1] & 0x3C) != 0) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        int n4 = (byArray[1] & 3) + 1;
        long[] lArray = new long[n4];
        byte[][] byArrayArray = new byte[n4][];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 2, this.headerSize - 6);
        try {
            this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check.getSize();
            if ((byArray[1] & 0x40) != 0) {
                this.compressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (this.compressedSizeInHeader == 0L || this.compressedSizeInHeader > this.compressedSizeLimit) {
                    throw new CorruptedInputException();
                }
                this.compressedSizeLimit = this.compressedSizeInHeader;
            }
            if ((byArray[1] & 0x80) != 0) {
                this.uncompressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                lArray[n3] = DecoderUtil.decodeVLI(byteArrayInputStream);
                l3 = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (l3 > (long)byteArrayInputStream.available()) {
                    throw new CorruptedInputException();
                }
                byArrayArray[n3] = new byte[(int)l3];
                byteArrayInputStream.read(byArrayArray[n3]);
            }
        }
        catch (IOException iOException) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        for (n3 = byteArrayInputStream.available(); n3 > 0; --n3) {
            if (byteArrayInputStream.read() == 0) continue;
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        if (l != -1L) {
            n3 = this.headerSize + check.getSize();
            if ((long)n3 >= l) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            l3 = l - (long)n3;
            if (l3 > this.compressedSizeLimit || this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != l3) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            if (this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != l2) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            this.compressedSizeLimit = l3;
            this.compressedSizeInHeader = l3;
            this.uncompressedSizeInHeader = l2;
        }
        FilterCoder[] filterCoderArray = new FilterDecoder[lArray.length];
        for (n2 = 0; n2 < filterCoderArray.length; ++n2) {
            if (lArray[n2] == 33L) {
                filterCoderArray[n2] = new LZMA2Decoder(byArrayArray[n2]);
                continue;
            }
            if (lArray[n2] == 3L) {
                filterCoderArray[n2] = new DeltaDecoder(byArrayArray[n2]);
                continue;
            }
            if (BCJDecoder.isBCJFilterID(lArray[n2])) {
                filterCoderArray[n2] = new BCJDecoder(lArray[n2], byArrayArray[n2]);
                continue;
            }
            throw new UnsupportedOptionsException("Unknown Filter ID " + lArray[n2]);
        }
        RawCoder.validate(filterCoderArray);
        if (n >= 0) {
            n2 = 0;
            for (int i = 0; i < filterCoderArray.length; ++i) {
                n2 += filterCoderArray[i].getMemoryUsage();
            }
            if (n2 > n) {
                throw new MemoryLimitException(n2, n);
            }
        }
        this.inCounted = new CountingInputStream(inputStream);
        this.filterChain = this.inCounted;
        for (n2 = filterCoderArray.length - 1; n2 >= 0; --n2) {
            this.filterChain = filterCoderArray[n2].getInputStream(this.filterChain);
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.endReached) {
            return -1;
        }
        int n3 = this.filterChain.read(byArray, n, n2);
        if (n3 > 0) {
            if (this.verifyCheck) {
                this.check.update(byArray, n, n3);
            }
            this.uncompressedSize += (long)n3;
            long l = this.inCounted.getSize();
            if (l < 0L || l > this.compressedSizeLimit || this.uncompressedSize < 0L || this.uncompressedSizeInHeader != -1L && this.uncompressedSize > this.uncompressedSizeInHeader) {
                throw new CorruptedInputException();
            }
            if (n3 < n2 || this.uncompressedSize == this.uncompressedSizeInHeader) {
                if (this.filterChain.read() != -1) {
                    throw new CorruptedInputException();
                }
                this.validate();
                this.endReached = true;
            }
        } else if (n3 == -1) {
            this.validate();
            this.endReached = true;
        }
        return n3;
    }

    private void validate() throws IOException {
        long l = this.inCounted.getSize();
        if (this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != l || this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != this.uncompressedSize) {
            throw new CorruptedInputException();
        }
        while ((l++ & 3L) != 0L) {
            if (this.inData.readUnsignedByte() == 0) continue;
            throw new CorruptedInputException();
        }
        byte[] byArray = new byte[this.check.getSize()];
        this.inData.readFully(byArray);
        if (this.verifyCheck && !Arrays.equals(this.check.finish(), byArray)) {
            throw new CorruptedInputException("Integrity check (" + this.check.getName() + ") does not match");
        }
    }

    @Override
    public int available() throws IOException {
        return this.filterChain.available();
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.inCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

