/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Logger logger = Logger.getLogger(UnsafeUtil.class.getName());
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final MemoryAccessor MEMORY_ACCESSOR = UnsafeUtil.getMemoryAccessor();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    private static final boolean HAS_UNSAFE_COPY_MEMORY = UnsafeUtil.supportsUnsafeCopyMemory();
    private static final long ARRAY_BASE_OFFSET = UnsafeUtil.byteArrayBaseOffset();
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.bufferAddressField());

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeCopyMemory() {
        return HAS_UNSAFE_COPY_MEMORY;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static long objectFieldOffset(Field field) {
        return MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    static long getArrayBaseOffset() {
        return ARRAY_BASE_OFFSET;
    }

    static byte getByte(Object object, long l) {
        return MEMORY_ACCESSOR.getByte(object, l);
    }

    static void putByte(Object object, long l, byte by) {
        MEMORY_ACCESSOR.putByte(object, l, by);
    }

    static int getInt(Object object, long l) {
        return MEMORY_ACCESSOR.getInt(object, l);
    }

    static void putInt(Object object, long l, int n) {
        MEMORY_ACCESSOR.putInt(object, l, n);
    }

    static long getLong(Object object, long l) {
        return MEMORY_ACCESSOR.getLong(object, l);
    }

    static void putLong(Object object, long l, long l2) {
        MEMORY_ACCESSOR.putLong(object, l, l2);
    }

    static boolean getBoolean(Object object, long l) {
        return MEMORY_ACCESSOR.getBoolean(object, l);
    }

    static void putBoolean(Object object, long l, boolean bl) {
        MEMORY_ACCESSOR.putBoolean(object, l, bl);
    }

    static float getFloat(Object object, long l) {
        return MEMORY_ACCESSOR.getFloat(object, l);
    }

    static void putFloat(Object object, long l, float f) {
        MEMORY_ACCESSOR.putFloat(object, l, f);
    }

    static double getDouble(Object object, long l) {
        return MEMORY_ACCESSOR.getDouble(object, l);
    }

    static void putDouble(Object object, long l, double d) {
        MEMORY_ACCESSOR.putDouble(object, l, d);
    }

    static Object getObject(Object object, long l) {
        return MEMORY_ACCESSOR.getObject(object, l);
    }

    static void putObject(Object object, long l, Object object2) {
        MEMORY_ACCESSOR.putObject(object, l, object2);
    }

    static void copyMemory(Object object, long l, Object object2, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(object, l, object2, l2, l3);
    }

    static byte getByte(long l) {
        return MEMORY_ACCESSOR.getByte(l);
    }

    static void putByte(long l, byte by) {
        MEMORY_ACCESSOR.putByte(l, by);
    }

    static int getInt(long l) {
        return MEMORY_ACCESSOR.getInt(l);
    }

    static void putInt(long l, int n) {
        MEMORY_ACCESSOR.putInt(l, n);
    }

    static long getLong(long l) {
        return MEMORY_ACCESSOR.getLong(l);
    }

    static void putLong(long l, long l2) {
        MEMORY_ACCESSOR.putLong(l, l2);
    }

    static void copyMemory(long l, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(l, l2, l3);
    }

    static long addressOffset(ByteBuffer byteBuffer) {
        return MEMORY_ACCESSOR.getLong(byteBuffer, BUFFER_ADDRESS_OFFSET);
    }

    static Object getStaticObject(Field field) {
        return MEMORY_ACCESSOR.getStaticObject(field);
    }

    private static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> clazz = Unsafe.class;
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        Object object = field.get(null);
                        if (!clazz.isInstance(object)) continue;
                        return (Unsafe)clazz.cast(object);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    private static MemoryAccessor getMemoryAccessor() {
        if (UNSAFE == null) {
            return null;
        }
        return new JvmMemoryAccessor(UNSAFE);
    }

    private static boolean supportsUnsafeArrayOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("arrayBaseOffset", Class.class);
            clazz.getMethod("getInt", Object.class, Long.TYPE);
            clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            clazz.getMethod("getObject", Object.class, Long.TYPE);
            clazz.getMethod("putObject", Object.class, Long.TYPE, Object.class);
            clazz.getMethod("getByte", Object.class, Long.TYPE);
            clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
            clazz.getMethod("getBoolean", Object.class, Long.TYPE);
            clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            clazz.getMethod("getFloat", Object.class, Long.TYPE);
            clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
            clazz.getMethod("getDouble", Object.class, Long.TYPE);
            clazz.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static boolean supportsUnsafeCopyMemory() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "copyMemory is missing from platform - proto runtime falling back to safer methods.");
            return false;
        }
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            clazz.getMethod("getByte", Long.TYPE);
            clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
            clazz.getMethod("getInt", Long.TYPE);
            clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Long.TYPE);
            clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + throwable);
            return false;
        }
    }

    private static <T> Class<T> getClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Field bufferAddressField() {
        return UnsafeUtil.field(Buffer.class, "address");
    }

    private static int byteArrayBaseOffset() {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayBaseOffset(byte[].class) : -1;
    }

    private static long fieldOffset(Field field) {
        return field == null || MEMORY_ACCESSOR == null ? -1L : MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static Field field(Class<?> clazz, String string) {
        Field field;
        try {
            field = clazz.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (Throwable throwable) {
            field = null;
        }
        return field;
    }

    private static final class JvmMemoryAccessor
    extends MemoryAccessor {
        JvmMemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long l) {
            return this.unsafe.getByte(l);
        }

        @Override
        public void putByte(long l, byte by) {
            this.unsafe.putByte(l, by);
        }

        @Override
        public int getInt(long l) {
            return this.unsafe.getInt(l);
        }

        @Override
        public void putInt(long l, int n) {
            this.unsafe.putInt(l, n);
        }

        @Override
        public long getLong(long l) {
            return this.unsafe.getLong(l);
        }

        @Override
        public void putLong(long l, long l2) {
            this.unsafe.putLong(l, l2);
        }

        @Override
        public byte getByte(Object object, long l) {
            return this.unsafe.getByte(object, l);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            this.unsafe.putByte(object, l, by);
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            return this.unsafe.getBoolean(object, l);
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            this.unsafe.putBoolean(object, l, bl);
        }

        @Override
        public float getFloat(Object object, long l) {
            return this.unsafe.getFloat(object, l);
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.unsafe.putFloat(object, l, f);
        }

        @Override
        public double getDouble(Object object, long l) {
            return this.unsafe.getDouble(object, l);
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.unsafe.putDouble(object, l, d);
        }

        @Override
        public void copyMemory(Object object, long l, Object object2, long l2, long l3) {
            this.unsafe.copyMemory(object, l, object2, l2, l3);
        }

        @Override
        public void copyMemory(long l, long l2, long l3) {
            this.unsafe.copyMemory(l, l2, l3);
        }

        @Override
        public Object getStaticObject(Field field) {
            return this.getObject(this.unsafe.staticFieldBase(field), this.unsafe.staticFieldOffset(field));
        }
    }

    private static abstract class MemoryAccessor {
        Unsafe unsafe;

        MemoryAccessor(Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        public final long objectFieldOffset(Field field) {
            return this.unsafe.objectFieldOffset(field);
        }

        public abstract byte getByte(Object var1, long var2);

        public abstract void putByte(Object var1, long var2, byte var4);

        public final int getInt(Object object, long l) {
            return this.unsafe.getInt(object, l);
        }

        public final void putInt(Object object, long l, int n) {
            this.unsafe.putInt(object, l, n);
        }

        public final long getLong(Object object, long l) {
            return this.unsafe.getLong(object, l);
        }

        public final void putLong(Object object, long l, long l2) {
            this.unsafe.putLong(object, l, l2);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract float getFloat(Object var1, long var2);

        public abstract void putFloat(Object var1, long var2, float var4);

        public abstract double getDouble(Object var1, long var2);

        public abstract void putDouble(Object var1, long var2, double var4);

        public final Object getObject(Object object, long l) {
            return this.unsafe.getObject(object, l);
        }

        public final void putObject(Object object, long l, Object object2) {
            this.unsafe.putObject(object, l, object2);
        }

        public final int arrayBaseOffset(Class<?> clazz) {
            return this.unsafe.arrayBaseOffset(clazz);
        }

        public abstract byte getByte(long var1);

        public abstract void putByte(long var1, byte var3);

        public abstract int getInt(long var1);

        public abstract void putInt(long var1, int var3);

        public abstract long getLong(long var1);

        public abstract void putLong(long var1, long var3);

        public abstract void copyMemory(long var1, long var3, long var5);

        public abstract void copyMemory(Object var1, long var2, Object var4, long var5, long var7);

        public abstract Object getStaticObject(Field var1);
    }
}

