#include "embedded.h"
#include <the_Foundation/file.h>
#include <the_Foundation/fileinfo.h>

iDeclareType(EmbedChunk)

struct Impl_EmbedChunk {
    size_t pos;
    size_t size;
};

static const iEmbedChunk chunks_Embed_[] = {
    { 0, 749 },
    { 749, 46159 },
    { 46908, 728 },
    { 47636, 9780 },
    { 57416, 46748 },
    { 104164, 1037 },
    { 105201, 454360 },
    { 559561, 435536 },
    { 995097, 431016 },
    { 1426113, 1503504 },
    { 2929617, 438028 },
    { 3367645, 411640 },
    { 3779285, 397116 },
    { 4176401, 403924 },
    { 4580325, 437824 },
    { 5018149, 240196 },
    { 5258345, 241016 },
    { 5499361, 240008 },
    { 5739369, 232220 },
    { 5971589, 4091796 },
    { 10063385, 418804 },
    { 10482189, 138624 },
    { 10620813, 5636040 },
    { 16256853, 10237648 },
    { 26494501, 168520 },
    { 26663021, 583072 },
    { 27246093, 154140 },
    { 27400233, 156188 },
    { 27556421, 151356 },
    { 27707777, 157416 },
    { 27865193, 154312 },
    { 28019505, 58312 },
    { 28077817, 298256 },
    { 28376073, 293932 },
    { 28670005, 214992 },
    { 28884997, 299252 },
    { 29184249, 298888 },
    { 29483137, 23761 },
    { 29506898, 22362 },
    { 29529260, 24888 },
    { 29554148, 24893 },
    { 29579041, 25862 },
    { 29604903, 24489 },
    { 29629392, 24247 },
    { 29653639, 25422 },
    { 29679061, 37144 },
    { 29716205, 36801 },
    { 29753006, 22683 },
    { 29775689, 21441 },
    { 29797130, 21626 },
    { 29818756, 14917 },
    { 29833673, 21150 },
};

iBlock blobAbout_Embedded;
iBlock blobHelp_Embedded;
iBlock blobLagrange_Embedded;
iBlock blobLicense_Embedded;
iBlock blobVersion_Embedded;
iBlock blobArghelp_Embedded;
iBlock fontTinosRegular_Embedded;
iBlock fontTinosItalic_Embedded;
iBlock fontTinosBold_Embedded;
iBlock fontIosevkaTermExtended_Embedded;
iBlock fontFiraSansBold_Embedded;
iBlock fontFiraSansItalic_Embedded;
iBlock fontFiraSansLight_Embedded;
iBlock fontFiraSansRegular_Embedded;
iBlock fontFiraSansSemiBold_Embedded;
iBlock fontLiterataRegularopsz14_Embedded;
iBlock fontLiterataBoldopsz36_Embedded;
iBlock fontLiterataExtraLightopsz18_Embedded;
iBlock fontLiterataLightItalicopsz10_Embedded;
iBlock fontNanumGothicRegular_Embedded;
iBlock fontNotoEmojiRegular_Embedded;
iBlock fontNotoSansArabicUIRegular_Embedded;
iBlock fontNotoSansJPRegular_Embedded;
iBlock fontNotoSansSCRegular_Embedded;
iBlock fontNotoSansSymbolsRegular_Embedded;
iBlock fontNotoSansSymbols2Regular_Embedded;
iBlock fontNunitoBold_Embedded;
iBlock fontNunitoExtraBold_Embedded;
iBlock fontNunitoExtraLight_Embedded;
iBlock fontNunitoLightItalic_Embedded;
iBlock fontNunitoRegular_Embedded;
iBlock fontSmolEmojiRegular_Embedded;
iBlock fontSourceSans3Bold_Embedded;
iBlock fontSourceSans3ExtraLight_Embedded;
iBlock fontSourceSans3It_Embedded;
iBlock fontSourceSans3Regular_Embedded;
iBlock fontSourceSans3Semibold_Embedded;
iBlock blobDe_Embedded;
iBlock blobEn_Embedded;
iBlock blobEs_Embedded;
iBlock blobFi_Embedded;
iBlock blobFr_Embedded;
iBlock blobIa_Embedded;
iBlock blobIe_Embedded;
iBlock blobPl_Embedded;
iBlock blobRu_Embedded;
iBlock blobSr_Embedded;
iBlock blobTok_Embedded;
iBlock blobZh_Hans_Embedded;
iBlock blobZh_Hant_Embedded;
iBlock imageShadow_Embedded;
iBlock imageLagrange64_Embedded;

static iBlock *blocks_Embed_[] = {
   &blobAbout_Embedded,
   &blobHelp_Embedded,
   &blobLagrange_Embedded,
   &blobLicense_Embedded,
   &blobVersion_Embedded,
   &blobArghelp_Embedded,
   &fontTinosRegular_Embedded,
   &fontTinosItalic_Embedded,
   &fontTinosBold_Embedded,
   &fontIosevkaTermExtended_Embedded,
   &fontFiraSansBold_Embedded,
   &fontFiraSansItalic_Embedded,
   &fontFiraSansLight_Embedded,
   &fontFiraSansRegular_Embedded,
   &fontFiraSansSemiBold_Embedded,
   &fontLiterataRegularopsz14_Embedded,
   &fontLiterataBoldopsz36_Embedded,
   &fontLiterataExtraLightopsz18_Embedded,
   &fontLiterataLightItalicopsz10_Embedded,
   &fontNanumGothicRegular_Embedded,
   &fontNotoEmojiRegular_Embedded,
   &fontNotoSansArabicUIRegular_Embedded,
   &fontNotoSansJPRegular_Embedded,
   &fontNotoSansSCRegular_Embedded,
   &fontNotoSansSymbolsRegular_Embedded,
   &fontNotoSansSymbols2Regular_Embedded,
   &fontNunitoBold_Embedded,
   &fontNunitoExtraBold_Embedded,
   &fontNunitoExtraLight_Embedded,
   &fontNunitoLightItalic_Embedded,
   &fontNunitoRegular_Embedded,
   &fontSmolEmojiRegular_Embedded,
   &fontSourceSans3Bold_Embedded,
   &fontSourceSans3ExtraLight_Embedded,
   &fontSourceSans3It_Embedded,
   &fontSourceSans3Regular_Embedded,
   &fontSourceSans3Semibold_Embedded,
   &blobDe_Embedded,
   &blobEn_Embedded,
   &blobEs_Embedded,
   &blobFi_Embedded,
   &blobFr_Embedded,
   &blobIa_Embedded,
   &blobIe_Embedded,
   &blobPl_Embedded,
   &blobRu_Embedded,
   &blobSr_Embedded,
   &blobTok_Embedded,
   &blobZh_Hans_Embedded,
   &blobZh_Hant_Embedded,
   &imageShadow_Embedded,
   &imageLagrange64_Embedded,
};

iBool load_Embed(const char *path) {
    const size_t fileSize = (size_t) fileSizeCStr_FileInfo(path);
    iFile *f = iClob(newCStr_File(path));
    if (open_File(f, readOnly_FileMode)) {
        iForIndices(i, blocks_Embed_) {
            const iEmbedChunk *chunk = &chunks_Embed_[i];
            iBlock *data = blocks_Embed_[i];
            if (chunk->pos + chunk->size > fileSize) {
                return iFalse;
            }
            init_Block(data, chunk->size);
            fill_Block(data, 0);
            seek_File(f, chunk->pos);
            readData_File(f, chunk->size, data_Block(data));
        }
        return iTrue;
    }
    return iFalse;
}
