/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import java.util.Hashtable;
import java.util.Iterator;
import org.jmock.core.Verifiable;
import org.jmock.expectation.AssertMo;
import org.jmock.expectation.Null;
import org.jmock.expectation.ReturnObjectList;

public class ReturnObjectBag
implements Verifiable {
    private final Hashtable returnObjectLists = new Hashtable();
    private final String name;

    public ReturnObjectBag(String string) {
        this.name = string;
    }

    public void putObjectToReturn(Object object, Object object2) {
        ReturnObjectList returnObjectList;
        if (object == null) {
            object = Null.NULL;
        }
        if ((returnObjectList = (ReturnObjectList)this.returnObjectLists.get(object)) == null) {
            returnObjectList = new ReturnObjectList(this.name + "." + object.toString());
            this.returnObjectLists.put(object, returnObjectList);
        }
        returnObjectList.addObjectToReturn(object2);
    }

    public void putObjectToReturn(int n, Object object) {
        this.putObjectToReturn((Object)new Integer(n), object);
    }

    public void putObjectToReturn(Object object, int n) {
        this.putObjectToReturn(object, (Object)new Integer(n));
    }

    public void putObjectToReturn(Object object, boolean bl) {
        this.putObjectToReturn(object, (Object)new Boolean(bl));
    }

    @Override
    public void verify() {
        Iterator iterator = this.returnObjectLists.values().iterator();
        while (iterator.hasNext()) {
            ((ReturnObjectList)iterator.next()).verify();
        }
    }

    public Object getNextReturnObject(Object object) {
        if (object == null) {
            object = Null.NULL;
        }
        ReturnObjectList returnObjectList = (ReturnObjectList)this.returnObjectLists.get(object);
        AssertMo.assertNotNull((String)(this.name + " does not contain " + object.toString()), (Object)returnObjectList);
        return returnObjectList.nextReturnObject();
    }

    public Object getNextReturnObject(int n) {
        return this.getNextReturnObject(new Integer(n));
    }

    public Hashtable getHashTable() {
        return this.returnObjectLists;
    }

    public int getNextReturnInt(Object object) {
        return (Integer)this.getNextReturnObject(object);
    }

    public boolean getNextReturnBoolean(Object object) {
        return (Boolean)this.getNextReturnObject(object);
    }
}

