/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationDispatcher;
import org.jmock.core.Invokable;
import org.jmock.core.Stub;
import org.jmock.core.Verifiable;
import org.jmock.core.stub.TestFailureStub;

public abstract class AbstractInvocationDispatcher
implements InvocationDispatcher {
    public static final String NO_EXPECTATIONS_MESSAGE = "No expectations set";
    protected List invokables = new ArrayList();
    protected Stub defaultStub = new TestFailureStub("unexpected invocation");

    @Override
    public void setDefaultStub(Stub stub) {
        this.defaultStub = stub;
    }

    @Override
    public void add(Invokable invokable) {
        this.invokables.add(invokable);
    }

    @Override
    public void verify() {
        Iterator iterator = this.invokables.iterator();
        while (iterator.hasNext()) {
            ((Verifiable)iterator.next()).verify();
        }
    }

    @Override
    public void clear() {
        this.invokables.clear();
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        if (this.anyInvokableHasDescription()) {
            this.writeInvokablesTo(stringBuffer);
        } else {
            stringBuffer.append(NO_EXPECTATIONS_MESSAGE);
        }
        return stringBuffer;
    }

    private void writeInvokablesTo(StringBuffer stringBuffer) {
        for (Invokable invokable : this.invokables) {
            if (!invokable.hasDescription()) continue;
            invokable.describeTo(stringBuffer).append("\n");
        }
    }

    private boolean anyInvokableHasDescription() {
        Iterator iterator = this.invokables.iterator();
        while (iterator.hasNext()) {
            if (!((Invokable)iterator.next()).hasDescription()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object dispatch(Invocation invocation) throws Throwable {
        Iterator iterator = this.dispatchOrder(this.invokables);
        while (iterator.hasNext()) {
            Invokable invokable = (Invokable)iterator.next();
            if (!invokable.matches(invocation)) continue;
            return invokable.invoke(invocation);
        }
        return this.defaultStub.invoke(invocation);
    }

    protected abstract Iterator dispatchOrder(List var1);
}

