/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.net.InetAddress;

public interface NameRegister {
    public void register(InetAddress var1, String var2, NameType var3);

    public boolean checkName(InetAddress var1, String var2, NameType var3);

    public String incrementHostName(InetAddress var1, String var2, NameType var3);

    public static class Factory {
        private static volatile NameRegister _register;

        public static void setRegistry(NameRegister nameRegister) throws IllegalStateException {
            if (_register != null) {
                throw new IllegalStateException("The register can only be set once.");
            }
            if (nameRegister != null) {
                _register = nameRegister;
            }
        }

        public static NameRegister getRegistry() {
            if (_register == null) {
                _register = new UniqueNamePerInterface();
            }
            return _register;
        }
    }

    public static class UniqueNameAcrossInterface
    implements NameRegister {
        @Override
        public void register(InetAddress inetAddress, String string, NameType nameType) {
        }

        @Override
        public boolean checkName(InetAddress inetAddress, String string, NameType nameType) {
            return false;
        }

        @Override
        public String incrementHostName(InetAddress inetAddress, String string, NameType nameType) {
            return null;
        }
    }

    public static class UniqueNamePerInterface
    implements NameRegister {
        @Override
        public void register(InetAddress inetAddress, String string, NameType nameType) {
        }

        @Override
        public boolean checkName(InetAddress inetAddress, String string, NameType nameType) {
            return false;
        }

        @Override
        public String incrementHostName(InetAddress inetAddress, String string, NameType nameType) {
            return null;
        }
    }

    public static enum NameType {
        HOST,
        SERVICE;

    }
}

