/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.DNSTaskStarter;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.ListenerStatus;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.SocketListener;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;

public class JmDNSImpl
extends JmDNS
implements DNSStatefulObject,
DNSTaskStarter {
    private static Logger logger = Logger.getLogger(JmDNSImpl.class.getName());
    private volatile InetAddress _group;
    private volatile MulticastSocket _socket;
    private final List<DNSListener> _listeners;
    private final ConcurrentMap<String, List<ListenerStatus.ServiceListenerStatus>> _serviceListeners;
    private final Set<ListenerStatus.ServiceTypeListenerStatus> _typeListeners;
    private final DNSCache _cache;
    private final ConcurrentMap<String, ServiceInfo> _services;
    private final ConcurrentMap<String, ServiceTypeEntry> _serviceTypes;
    private volatile JmDNS.Delegate _delegate;
    protected Thread _shutdown;
    private HostInfo _localHost;
    private Thread _incomingListener;
    private int _throttle;
    private long _lastThrottleIncrement;
    private final ExecutorService _executor = Executors.newSingleThreadExecutor();
    private static final Random _random = new Random();
    private final ReentrantLock _ioLock = new ReentrantLock();
    private DNSIncoming _plannedAnswer;
    private final ConcurrentMap<String, ServiceCollector> _serviceCollectors;
    private final String _name;
    private final Object _recoverLock = new Object();

    public static void main(String[] stringArray) {
        String string = null;
        try {
            Properties properties = new Properties();
            properties.load(JmDNSImpl.class.getResourceAsStream("/META-INF/maven/javax.jmdns/jmdns/pom.properties"));
            string = properties.getProperty("version");
        }
        catch (Exception exception) {
            string = "RUNNING.IN.IDE.FULL";
        }
        System.out.println("JmDNS version \"" + string + "\"");
        System.out.println(" ");
        System.out.println("Running on java version \"" + System.getProperty("java.version") + "\"" + " (build " + System.getProperty("java.runtime.version") + ")" + " from " + System.getProperty("java.vendor"));
        System.out.println("Operating environment \"" + System.getProperty("os.name") + "\"" + " version " + System.getProperty("os.version") + " on " + System.getProperty("os.arch"));
        System.out.println("For more information on JmDNS please visit https://sourceforge.net/projects/jmdns/");
    }

    public JmDNSImpl(InetAddress inetAddress, String string) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("JmDNS instance created");
        }
        this._cache = new DNSCache(100);
        this._listeners = Collections.synchronizedList(new ArrayList());
        this._serviceListeners = new ConcurrentHashMap<String, List<ListenerStatus.ServiceListenerStatus>>();
        this._typeListeners = Collections.synchronizedSet(new HashSet());
        this._serviceCollectors = new ConcurrentHashMap<String, ServiceCollector>();
        this._services = new ConcurrentHashMap<String, ServiceInfo>(20);
        this._serviceTypes = new ConcurrentHashMap<String, ServiceTypeEntry>(20);
        this._localHost = HostInfo.newHostInfo(inetAddress, this, string);
        this._name = string != null ? string : this._localHost.getName();
        this.openMulticastSocket(this.getLocalHost());
        this.start(this.getServices().values());
        this.startReaper();
    }

    private void start(Collection<? extends ServiceInfo> collection) {
        if (this._incomingListener == null) {
            this._incomingListener = new SocketListener(this);
            this._incomingListener.start();
        }
        this.startProber();
        for (ServiceInfo serviceInfo : collection) {
            try {
                this.registerService(new ServiceInfoImpl(serviceInfo));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "start() Registration exception ", exception);
            }
        }
    }

    private void openMulticastSocket(HostInfo hostInfo) throws IOException {
        block5: {
            if (this._group == null) {
                this._group = hostInfo.getInetAddress() instanceof Inet6Address ? InetAddress.getByName("FF02::FB") : InetAddress.getByName("224.0.0.251");
            }
            if (this._socket != null) {
                this.closeMulticastSocket();
            }
            this._socket = new MulticastSocket(DNSConstants.MDNS_PORT);
            if (hostInfo != null && hostInfo.getInterface() != null) {
                try {
                    this._socket.setNetworkInterface(hostInfo.getInterface());
                }
                catch (SocketException socketException) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.fine("openMulticastSocket() Set network interface exception: " + socketException.getMessage());
                }
            }
        }
        this._socket.setTimeToLive(255);
        this._socket.joinGroup(this._group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMulticastSocket() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("closeMulticastSocket()");
        }
        if (this._socket != null) {
            try {
                try {
                    this._socket.leaveGroup(this._group);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                this._socket.close();
                while (this._incomingListener != null && this._incomingListener.isAlive()) {
                    JmDNSImpl jmDNSImpl = this;
                    synchronized (jmDNSImpl) {
                        try {
                            if (this._incomingListener != null && this._incomingListener.isAlive()) {
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.finer("closeMulticastSocket(): waiting for jmDNS monitor");
                                }
                                this.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this._incomingListener = null;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "closeMulticastSocket() Close socket exception ", exception);
            }
            this._socket = null;
        }
    }

    @Override
    public boolean advanceState(DNSTask dNSTask) {
        return this._localHost.advanceState(dNSTask);
    }

    @Override
    public boolean revertState() {
        return this._localHost.revertState();
    }

    @Override
    public boolean cancelState() {
        return this._localHost.cancelState();
    }

    @Override
    public boolean closeState() {
        return this._localHost.closeState();
    }

    @Override
    public boolean recoverState() {
        return this._localHost.recoverState();
    }

    @Override
    public JmDNSImpl getDns() {
        return this;
    }

    @Override
    public void associateWithTask(DNSTask dNSTask, DNSState dNSState) {
        this._localHost.associateWithTask(dNSTask, dNSState);
    }

    @Override
    public void removeAssociationWithTask(DNSTask dNSTask) {
        this._localHost.removeAssociationWithTask(dNSTask);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask dNSTask, DNSState dNSState) {
        return this._localHost.isAssociatedWithTask(dNSTask, dNSState);
    }

    @Override
    public boolean isProbing() {
        return this._localHost.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._localHost.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._localHost.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._localHost.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._localHost.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this._localHost.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this._localHost.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long l) {
        return this._localHost.waitForAnnounced(l);
    }

    @Override
    public boolean waitForCanceled(long l) {
        return this._localHost.waitForCanceled(l);
    }

    public DNSCache getCache() {
        return this._cache;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getHostName() {
        return this._localHost.getName();
    }

    public HostInfo getLocalHost() {
        return this._localHost;
    }

    @Override
    public InetAddress getInterface() throws IOException {
        return this._socket.getInterface();
    }

    @Override
    public ServiceInfo getServiceInfo(String string, String string2) {
        return this.getServiceInfo(string, string2, false, 6000L);
    }

    @Override
    public ServiceInfo getServiceInfo(String string, String string2, long l) {
        return this.getServiceInfo(string, string2, false, l);
    }

    @Override
    public ServiceInfo getServiceInfo(String string, String string2, boolean bl) {
        return this.getServiceInfo(string, string2, bl, 6000L);
    }

    @Override
    public ServiceInfo getServiceInfo(String string, String string2, boolean bl, long l) {
        ServiceInfoImpl serviceInfoImpl = this.resolveServiceInfo(string, string2, "", bl);
        this.waitForInfoData(serviceInfoImpl, l);
        return serviceInfoImpl.hasData() ? serviceInfoImpl : null;
    }

    ServiceInfoImpl resolveServiceInfo(String string, String string2, String string3, boolean bl) {
        this.cleanCache();
        String string4 = string.toLowerCase();
        this.registerServiceType(string);
        if (this._serviceCollectors.putIfAbsent(string4, new ServiceCollector(string)) == null) {
            this.addServiceListener(string4, (ServiceListener)this._serviceCollectors.get(string4), true);
        }
        ServiceInfoImpl serviceInfoImpl = this.getServiceInfoFromCache(string, string2, string3, bl);
        this.startServiceInfoResolver(serviceInfoImpl);
        return serviceInfoImpl;
    }

    ServiceInfoImpl getServiceInfoFromCache(String string, String string2, String string3, boolean bl) {
        ServiceInfoImpl serviceInfoImpl;
        ServiceInfoImpl serviceInfoImpl2 = new ServiceInfoImpl(string, string2, string3, 0, 0, 0, bl, (byte[])null);
        DNSEntry dNSEntry = this.getCache().getDNSEntry(new DNSRecord.Pointer(string, DNSRecordClass.CLASS_ANY, false, 0, serviceInfoImpl2.getQualifiedName()));
        if (dNSEntry instanceof DNSRecord && (serviceInfoImpl = (ServiceInfoImpl)((DNSRecord)dNSEntry).getServiceInfo(bl)) != null) {
            InetAddress inetAddress;
            int n;
            int n2;
            Object object;
            Object object2;
            Object object3;
            Map<ServiceInfo.Fields, String> map = serviceInfoImpl.getQualifiedNameMap();
            byte[] byArray = null;
            String string4 = "";
            DNSEntry dNSEntry2 = this.getCache().getDNSEntry(serviceInfoImpl2.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_ANY);
            if (dNSEntry2 instanceof DNSRecord && (object3 = ((DNSRecord)dNSEntry2).getServiceInfo(bl)) != null) {
                serviceInfoImpl = new ServiceInfoImpl(map, ((ServiceInfo)object3).getPort(), ((ServiceInfo)object3).getWeight(), ((ServiceInfo)object3).getPriority(), bl, (byte[])null);
                byArray = ((ServiceInfo)object3).getTextBytes();
                string4 = ((ServiceInfo)object3).getServer();
            }
            if ((object3 = this.getCache().getDNSEntry(string4, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_ANY)) instanceof DNSRecord && (object2 = ((DNSRecord)object3).getServiceInfo(bl)) != null) {
                object = ((ServiceInfo)object2).getInet4Addresses();
                n2 = ((Inet4Address[])object).length;
                for (n = 0; n < n2; ++n) {
                    inetAddress = object[n];
                    serviceInfoImpl.addAddress((Inet4Address)inetAddress);
                }
                serviceInfoImpl._setText(((ServiceInfo)object2).getTextBytes());
            }
            if ((object3 = this.getCache().getDNSEntry(string4, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_ANY)) instanceof DNSRecord && (object2 = ((DNSRecord)object3).getServiceInfo(bl)) != null) {
                object = ((ServiceInfo)object2).getInet6Addresses();
                n2 = ((InetAddress[])object).length;
                for (n = 0; n < n2; ++n) {
                    inetAddress = object[n];
                    serviceInfoImpl.addAddress((Inet6Address)inetAddress);
                }
                serviceInfoImpl._setText(((ServiceInfo)object2).getTextBytes());
            }
            if ((object2 = this.getCache().getDNSEntry(serviceInfoImpl.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_ANY)) instanceof DNSRecord && (object = ((DNSRecord)object2).getServiceInfo(bl)) != null) {
                serviceInfoImpl._setText(((ServiceInfo)object).getTextBytes());
            }
            if (serviceInfoImpl.getTextBytes().length == 0) {
                serviceInfoImpl._setText(byArray);
            }
            if (serviceInfoImpl.hasData()) {
                serviceInfoImpl2 = serviceInfoImpl;
            }
        }
        return serviceInfoImpl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInfoData(ServiceInfo serviceInfo, long l) {
        ServiceInfo serviceInfo2 = serviceInfo;
        synchronized (serviceInfo2) {
            long l2 = l / 200L;
            if (l2 < 1L) {
                l2 = 1L;
            }
            int n = 0;
            while ((long)n < l2 && !serviceInfo.hasData()) {
                try {
                    serviceInfo.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    @Override
    public void requestServiceInfo(String string, String string2) {
        this.requestServiceInfo(string, string2, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String string, String string2, boolean bl) {
        this.requestServiceInfo(string, string2, bl, 6000L);
    }

    @Override
    public void requestServiceInfo(String string, String string2, long l) {
        this.requestServiceInfo(string, string2, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String string, String string2, boolean bl, long l) {
        ServiceInfoImpl serviceInfoImpl = this.resolveServiceInfo(string, string2, "", bl);
        this.waitForInfoData(serviceInfoImpl, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceResolved(ServiceEvent serviceEvent) {
        List list = (List)this._serviceListeners.get(serviceEvent.getType().toLowerCase());
        if (list != null && !list.isEmpty() && serviceEvent.getInfo() != null && serviceEvent.getInfo().hasData()) {
            ArrayList arrayList;
            final ServiceEvent serviceEvent2 = serviceEvent;
            List list2 = list;
            synchronized (list2) {
                arrayList = new ArrayList(list);
            }
            for (final ListenerStatus.ServiceListenerStatus serviceListenerStatus : arrayList) {
                this._executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        serviceListenerStatus.serviceResolved(serviceEvent2);
                    }
                });
            }
        }
    }

    @Override
    public void addServiceTypeListener(ServiceTypeListener serviceTypeListener) throws IOException {
        ListenerStatus.ServiceTypeListenerStatus serviceTypeListenerStatus = new ListenerStatus.ServiceTypeListenerStatus(serviceTypeListener, false);
        this._typeListeners.add(serviceTypeListenerStatus);
        for (String string : this._serviceTypes.keySet()) {
            serviceTypeListenerStatus.serviceTypeAdded(new ServiceEventImpl(this, string, "", null));
        }
        this.startTypeResolver();
    }

    @Override
    public void removeServiceTypeListener(ServiceTypeListener serviceTypeListener) {
        ListenerStatus.ServiceTypeListenerStatus serviceTypeListenerStatus = new ListenerStatus.ServiceTypeListenerStatus(serviceTypeListener, false);
        this._typeListeners.remove(serviceTypeListenerStatus);
    }

    @Override
    public void addServiceListener(String string, ServiceListener serviceListener) {
        this.addServiceListener(string, serviceListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceListener(String string, ServiceListener serviceListener, boolean bl) {
        ArrayList<ListenerStatus.ServiceListenerStatus> arrayList;
        ListenerStatus.ServiceListenerStatus serviceListenerStatus = new ListenerStatus.ServiceListenerStatus(serviceListener, bl);
        String string2 = string.toLowerCase();
        List<ListenerStatus.ServiceListenerStatus> list = (ArrayList<ListenerStatus.ServiceListenerStatus>)this._serviceListeners.get(string2);
        if (list == null) {
            if (this._serviceListeners.putIfAbsent(string2, new LinkedList()) == null && this._serviceCollectors.putIfAbsent(string2, new ServiceCollector(string)) == null) {
                this.addServiceListener(string2, (ServiceListener)this._serviceCollectors.get(string2), true);
            }
            list = (List)this._serviceListeners.get(string2);
        }
        if (list != null) {
            arrayList = list;
            synchronized (arrayList) {
                if (!list.contains(serviceListener)) {
                    list.add(serviceListenerStatus);
                }
            }
        }
        arrayList = new ArrayList<ListenerStatus.ServiceListenerStatus>();
        Collection<DNSEntry> collection = this.getCache().allValues();
        for (DNSEntry object : collection) {
            DNSRecord dNSRecord = (DNSRecord)object;
            if (dNSRecord.getRecordType() != DNSRecordType.TYPE_SRV || !dNSRecord.getKey().endsWith(string2)) continue;
            arrayList.add((ListenerStatus.ServiceListenerStatus)((Object)new ServiceEventImpl(this, dNSRecord.getType(), JmDNSImpl.toUnqualifiedName(dNSRecord.getType(), dNSRecord.getName()), dNSRecord.getServiceInfo())));
        }
        for (ServiceEvent serviceEvent : arrayList) {
            serviceListenerStatus.serviceAdded(serviceEvent);
        }
        this.startServiceResolver(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(String string, ServiceListener serviceListener) {
        String string2 = string.toLowerCase();
        List list = (List)this._serviceListeners.get(string2);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                ListenerStatus.ServiceListenerStatus serviceListenerStatus = new ListenerStatus.ServiceListenerStatus(serviceListener, false);
                list.remove(serviceListenerStatus);
                if (list.isEmpty()) {
                    this._serviceListeners.remove(string2, list);
                }
            }
        }
    }

    @Override
    public void registerService(ServiceInfo serviceInfo) throws IOException {
        if (this.isClosing() || this.isClosed()) {
            throw new IllegalStateException("This DNS is closed.");
        }
        ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)serviceInfo;
        if (serviceInfoImpl.getDns() != null) {
            if (serviceInfoImpl.getDns() != this) {
                throw new IllegalStateException("A service information can only be registered with a single instamce of JmDNS.");
            }
            if (this._services.get(serviceInfoImpl.getKey()) != null) {
                throw new IllegalStateException("A service information can only be registered once.");
            }
        }
        serviceInfoImpl.setDns(this);
        this.registerServiceType(serviceInfoImpl.getTypeWithSubtype());
        serviceInfoImpl.recoverState();
        serviceInfoImpl.setServer(this._localHost.getName());
        serviceInfoImpl.addAddress(this._localHost.getInet4Address());
        serviceInfoImpl.addAddress(this._localHost.getInet6Address());
        this.waitForAnnounced(6000L);
        this.makeServiceNameUnique(serviceInfoImpl);
        while (this._services.putIfAbsent(serviceInfoImpl.getKey(), serviceInfoImpl) != null) {
            this.makeServiceNameUnique(serviceInfoImpl);
        }
        this.startProber();
        serviceInfoImpl.waitForAnnounced(6000L);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("registerService() JmDNS registered service as " + serviceInfoImpl);
        }
    }

    @Override
    public void unregisterService(ServiceInfo serviceInfo) {
        ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)this._services.get(serviceInfo.getKey());
        if (serviceInfoImpl != null) {
            serviceInfoImpl.cancelState();
            this.startCanceler();
            serviceInfoImpl.waitForCanceled(5000L);
            this._services.remove(serviceInfoImpl.getKey(), serviceInfoImpl);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("unregisterService() JmDNS unregistered service as " + serviceInfoImpl);
            }
        } else {
            logger.warning("Removing unregistered service info: " + serviceInfo.getKey());
        }
    }

    @Override
    public void unregisterAllServices() {
        ServiceInfoImpl serviceInfoImpl;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("unregisterAllServices()");
        }
        for (String string : this._services.keySet()) {
            serviceInfoImpl = (ServiceInfoImpl)this._services.get(string);
            if (serviceInfoImpl == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Cancelling service info: " + serviceInfoImpl);
            }
            serviceInfoImpl.cancelState();
        }
        this.startCanceler();
        for (String string : this._services.keySet()) {
            serviceInfoImpl = (ServiceInfoImpl)this._services.get(string);
            if (serviceInfoImpl == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Wait for service info cancel: " + serviceInfoImpl);
            }
            serviceInfoImpl.waitForCanceled(5000L);
            this._services.remove(string, serviceInfoImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean registerServiceType(String string) {
        Object object;
        ListenerStatus.ServiceTypeListenerStatus[] serviceTypeListenerStatusArray;
        boolean bl = false;
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        String string2 = map.get((Object)ServiceInfo.Fields.Domain);
        String string3 = map.get((Object)ServiceInfo.Fields.Protocol);
        String string4 = map.get((Object)ServiceInfo.Fields.Application);
        String string5 = map.get((Object)ServiceInfo.Fields.Subtype);
        String string6 = (string4.length() > 0 ? "_" + string4 + "." : "") + (string3.length() > 0 ? "_" + string3 + "." : "") + string2 + ".";
        String string7 = string6.toLowerCase();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ".registering service type: " + string + " as: " + string6 + (string5.length() > 0 ? " subtype: " + string5 : ""));
        }
        if (!(this._serviceTypes.containsKey(string7) || string4.toLowerCase().equals("dns-sd") || string2.toLowerCase().endsWith("in-addr.arpa") || string2.toLowerCase().endsWith("ip6.arpa"))) {
            boolean bl2 = bl = this._serviceTypes.putIfAbsent(string7, new ServiceTypeEntry(string6)) == null;
            if (bl) {
                serviceTypeListenerStatusArray = this._typeListeners.toArray(new ListenerStatus.ServiceTypeListenerStatus[this._typeListeners.size()]);
                object = new ServiceEventImpl(this, string6, "", null);
                for (final ListenerStatus.ServiceTypeListenerStatus serviceTypeListenerStatus : serviceTypeListenerStatusArray) {
                    this._executor.submit(new Runnable((ServiceEvent)object){
                        final /* synthetic */ ServiceEvent val$event;
                        {
                            this.val$event = serviceEvent;
                        }

                        @Override
                        public void run() {
                            serviceTypeListenerStatus.serviceTypeAdded(this.val$event);
                        }
                    });
                }
            }
        }
        if (string5.length() <= 0 || (serviceTypeListenerStatusArray = (ListenerStatus.ServiceTypeListenerStatus[])this._serviceTypes.get(string7)) == null || serviceTypeListenerStatusArray.contains(string5)) return bl;
        object = serviceTypeListenerStatusArray;
        synchronized (serviceTypeListenerStatusArray) {
            if (serviceTypeListenerStatusArray.contains(string5)) return bl;
            bl = true;
            serviceTypeListenerStatusArray.add(string5);
            ListenerStatus.ServiceTypeListenerStatus[] serviceTypeListenerStatusArray2 = this._typeListeners.toArray(new ListenerStatus.ServiceTypeListenerStatus[this._typeListeners.size()]);
            final ServiceEventImpl serviceEventImpl = new ServiceEventImpl(this, "_" + string5 + "._sub." + string6, "", null);
            for (final ListenerStatus.ServiceTypeListenerStatus serviceTypeListenerStatus : serviceTypeListenerStatusArray2) {
                this._executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        serviceTypeListenerStatus.subTypeForServiceTypeAdded(serviceEventImpl);
                    }
                });
            }
            // ** MonitorExit[var11_11 /* !! */ ] (shouldn't be in output)
            return bl;
        }
    }

    private boolean makeServiceNameUnique(ServiceInfoImpl serviceInfoImpl) {
        boolean bl;
        String string = serviceInfoImpl.getKey();
        long l = System.currentTimeMillis();
        do {
            bl = false;
            Object object = this.getCache().getDNSEntryList(serviceInfoImpl.getKey()).iterator();
            while (object.hasNext()) {
                DNSRecord.Service service;
                DNSEntry dNSEntry = object.next();
                if (!DNSRecordType.TYPE_SRV.equals((Object)dNSEntry.getRecordType()) || dNSEntry.isExpired(l) || (service = (DNSRecord.Service)dNSEntry).getPort() == serviceInfoImpl.getPort() && service.getServer().equals(this._localHost.getName())) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("makeServiceNameUnique() JmDNS.makeServiceNameUnique srv collision:" + dNSEntry + " s.server=" + service.getServer() + " " + this._localHost.getName() + " equals:" + service.getServer().equals(this._localHost.getName()));
                }
                serviceInfoImpl.setName(this.incrementName(serviceInfoImpl.getName()));
                bl = true;
                break;
            }
            if ((object = (ServiceInfo)this._services.get(serviceInfoImpl.getKey())) == null || object == serviceInfoImpl) continue;
            serviceInfoImpl.setName(this.incrementName(serviceInfoImpl.getName()));
            bl = true;
        } while (bl);
        return !string.equals(serviceInfoImpl.getKey());
    }

    String incrementName(String string) {
        String string2 = string;
        try {
            int n = string2.lastIndexOf(40);
            int n2 = string2.lastIndexOf(41);
            string2 = n >= 0 && n < n2 ? string2.substring(0, n) + "(" + (Integer.parseInt(string2.substring(n + 1, n2)) + 1) + ")" : string2 + " (2)";
        }
        catch (NumberFormatException numberFormatException) {
            string2 = string2 + " (2)";
        }
        return string2;
    }

    public void addListener(DNSListener dNSListener, DNSQuestion dNSQuestion) {
        long l = System.currentTimeMillis();
        this._listeners.add(dNSListener);
        if (dNSQuestion != null) {
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(dNSQuestion.getName().toLowerCase())) {
                if (!dNSQuestion.answeredBy(dNSEntry) || dNSEntry.isExpired(l)) continue;
                dNSListener.updateRecord(this.getCache(), l, dNSEntry);
            }
        }
    }

    public void removeListener(DNSListener dNSListener) {
        this._listeners.remove(dNSListener);
    }

    public void renewServiceCollector(DNSRecord dNSRecord) {
        ServiceInfo serviceInfo = dNSRecord.getServiceInfo();
        if (this._serviceCollectors.containsKey(serviceInfo.getType().toLowerCase())) {
            this.startServiceResolver(serviceInfo.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long l, DNSRecord dNSRecord, Operation operation) {
        ArrayList arrayList;
        Cloneable cloneable = null;
        Object object = this._listeners;
        synchronized (object) {
            cloneable = new ArrayList<DNSListener>(this._listeners);
        }
        object = cloneable.iterator();
        while (object.hasNext()) {
            arrayList = (DNSListener)object.next();
            arrayList.updateRecord(this.getCache(), l, dNSRecord);
        }
        if (DNSRecordType.TYPE_PTR.equals((Object)dNSRecord.getRecordType())) {
            Object object2;
            cloneable = dNSRecord.getServiceEvent(this);
            if ((((ServiceEvent)cloneable).getInfo() == null || !((ServiceEvent)cloneable).getInfo().hasData()) && ((ServiceInfo)(object = this.getServiceInfoFromCache(((ServiceEvent)cloneable).getType(), ((ServiceEvent)cloneable).getName(), "", false))).hasData()) {
                cloneable = new ServiceEventImpl(this, ((ServiceEvent)cloneable).getType(), ((ServiceEvent)cloneable).getName(), (ServiceInfo)object);
            }
            if ((object = (List)this._serviceListeners.get(((ServiceEvent)cloneable).getType().toLowerCase())) != null) {
                object2 = object;
                synchronized (object2) {
                    arrayList = new ArrayList(object);
                }
            } else {
                arrayList = Collections.emptyList();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.getName() + ".updating record for event: " + cloneable + " list " + arrayList + " operation: " + (Object)((Object)operation));
            }
            if (!arrayList.isEmpty()) {
                object2 = cloneable;
                switch (operation) {
                    case Add: {
                        for (final ListenerStatus.ServiceListenerStatus serviceListenerStatus : arrayList) {
                            if (serviceListenerStatus.isSynchronous()) {
                                serviceListenerStatus.serviceAdded((ServiceEvent)object2);
                                continue;
                            }
                            this._executor.submit(new Runnable((ServiceEvent)object2){
                                final /* synthetic */ ServiceEvent val$localEvent;
                                {
                                    this.val$localEvent = serviceEvent;
                                }

                                @Override
                                public void run() {
                                    serviceListenerStatus.serviceAdded(this.val$localEvent);
                                }
                            });
                        }
                        break;
                    }
                    case Remove: {
                        for (final ListenerStatus.ServiceListenerStatus serviceListenerStatus : arrayList) {
                            if (serviceListenerStatus.isSynchronous()) {
                                serviceListenerStatus.serviceRemoved((ServiceEvent)object2);
                                continue;
                            }
                            this._executor.submit(new Runnable((ServiceEvent)object2){
                                final /* synthetic */ ServiceEvent val$localEvent;
                                {
                                    this.val$localEvent = serviceEvent;
                                }

                                @Override
                                public void run() {
                                    serviceListenerStatus.serviceRemoved(this.val$localEvent);
                                }
                            });
                        }
                        break;
                    }
                }
            }
        }
    }

    void handleRecord(DNSRecord dNSRecord, long l) {
        boolean bl;
        DNSRecord dNSRecord2 = dNSRecord;
        Operation operation = Operation.Noop;
        boolean bl2 = dNSRecord2.isExpired(l);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + " handle response: " + dNSRecord2);
        }
        if (!dNSRecord2.isServicesDiscoveryMetaQuery() && !dNSRecord2.isDomainDiscoveryQuery()) {
            bl = dNSRecord2.isUnique();
            DNSRecord dNSRecord3 = (DNSRecord)this.getCache().getDNSEntry(dNSRecord2);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.getName() + " handle response cached record: " + dNSRecord3);
            }
            if (bl) {
                for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(dNSRecord2.getKey())) {
                    if (!dNSRecord2.getRecordType().equals((Object)dNSEntry.getRecordType()) || !dNSRecord2.getRecordClass().equals((Object)dNSEntry.getRecordClass()) || dNSEntry == dNSRecord3) continue;
                    ((DNSRecord)dNSEntry).setWillExpireSoon(l);
                }
            }
            if (dNSRecord3 != null) {
                if (bl2) {
                    if (dNSRecord2.getTTL() == 0) {
                        operation = Operation.Noop;
                        dNSRecord3.setWillExpireSoon(l);
                    } else {
                        operation = Operation.Remove;
                        this.getCache().removeDNSEntry(dNSRecord3);
                    }
                } else if (!dNSRecord2.sameValue(dNSRecord3) || !dNSRecord2.sameSubtype(dNSRecord3) && dNSRecord2.getSubtype().length() > 0) {
                    if (dNSRecord2.isSingleValued()) {
                        operation = Operation.Update;
                        this.getCache().replaceDNSEntry(dNSRecord2, dNSRecord3);
                    } else {
                        operation = Operation.Add;
                        this.getCache().addDNSEntry(dNSRecord2);
                    }
                } else {
                    dNSRecord3.resetTTL(dNSRecord2);
                    dNSRecord2 = dNSRecord3;
                }
            } else if (!bl2) {
                operation = Operation.Add;
                this.getCache().addDNSEntry(dNSRecord2);
            }
        }
        if (dNSRecord2.getRecordType() == DNSRecordType.TYPE_PTR) {
            bl = false;
            if (dNSRecord2.isServicesDiscoveryMetaQuery()) {
                if (!bl2) {
                    bl = this.registerServiceType(((DNSRecord.Pointer)dNSRecord2).getAlias());
                }
                return;
            }
            if ((bl |= this.registerServiceType(dNSRecord2.getName())) && operation == Operation.Noop) {
                operation = Operation.RegisterServiceType;
            }
        }
        if (operation != Operation.Noop) {
            this.updateRecord(l, dNSRecord2, operation);
        }
    }

    void handleResponse(DNSIncoming dNSIncoming) throws IOException {
        long l = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        for (DNSRecord dNSRecord : dNSIncoming.getAllAnswers()) {
            this.handleRecord(dNSRecord, l);
            if (DNSRecordType.TYPE_A.equals((Object)dNSRecord.getRecordType()) || DNSRecordType.TYPE_AAAA.equals((Object)dNSRecord.getRecordType())) {
                bl |= dNSRecord.handleResponse(this);
                continue;
            }
            bl2 |= dNSRecord.handleResponse(this);
        }
        if (bl || bl2) {
            this.startProber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleQuery(DNSIncoming dNSIncoming, InetAddress inetAddress, int n) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ".handle query: " + dNSIncoming);
        }
        boolean bl = false;
        long l = System.currentTimeMillis() + 120L;
        for (DNSRecord dNSRecord : dNSIncoming.getAllAnswers()) {
            bl |= dNSRecord.handleQuery(this, l);
        }
        this.ioLock();
        try {
            if (this._plannedAnswer != null) {
                this._plannedAnswer.append(dNSIncoming);
            } else {
                DNSIncoming dNSIncoming2 = dNSIncoming.clone();
                if (dNSIncoming.isTruncated()) {
                    this._plannedAnswer = dNSIncoming2;
                }
                this.startResponder(dNSIncoming2, n);
            }
        }
        finally {
            this.ioUnlock();
        }
        long l2 = System.currentTimeMillis();
        for (DNSRecord dNSRecord : dNSIncoming.getAnswers()) {
            this.handleRecord(dNSRecord, l2);
        }
        if (bl) {
            this.startProber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respondToQuery(DNSIncoming dNSIncoming) {
        this.ioLock();
        try {
            if (this._plannedAnswer == dNSIncoming) {
                this._plannedAnswer = null;
            }
        }
        finally {
            this.ioUnlock();
        }
    }

    public DNSOutgoing addAnswer(DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing, DNSRecord dNSRecord) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        if (dNSOutgoing2 == null) {
            dNSOutgoing2 = new DNSOutgoing(33792, false, dNSIncoming.getSenderUDPPayload());
        }
        try {
            dNSOutgoing2.addAnswer(dNSIncoming, dNSRecord);
        }
        catch (IOException iOException) {
            dNSOutgoing2.setFlags(dNSOutgoing2.getFlags() | 0x200);
            dNSOutgoing2.setId(dNSIncoming.getId());
            this.send(dNSOutgoing2);
            dNSOutgoing2 = new DNSOutgoing(33792, false, dNSIncoming.getSenderUDPPayload());
            dNSOutgoing2.addAnswer(dNSIncoming, dNSRecord);
        }
        return dNSOutgoing2;
    }

    public void send(DNSOutgoing dNSOutgoing) throws IOException {
        if (!dNSOutgoing.isEmpty()) {
            Object object;
            byte[] byArray = dNSOutgoing.data();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this._group, DNSConstants.MDNS_PORT);
            if (logger.isLoggable(Level.FINEST)) {
                try {
                    object = new DNSIncoming(datagramPacket);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("send(" + this.getName() + ") JmDNS out:" + ((DNSIncoming)object).print(true));
                    }
                }
                catch (IOException iOException) {
                    logger.throwing(this.getClass().toString(), "send(" + this.getName() + ") - JmDNS can not parse what it sends!!!", iOException);
                }
            }
            if ((object = this._socket) != null && !((DatagramSocket)object).isClosed()) {
                ((DatagramSocket)object).send(datagramPacket);
            }
        }
    }

    @Override
    public void purgeTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).purgeTimer();
    }

    @Override
    public void purgeStateTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).purgeStateTimer();
    }

    @Override
    public void cancelTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).cancelTimer();
    }

    @Override
    public void cancelStateTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).cancelStateTimer();
    }

    @Override
    public void startProber() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startProber();
    }

    @Override
    public void startAnnouncer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startAnnouncer();
    }

    @Override
    public void startRenewer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startRenewer();
    }

    @Override
    public void startCanceler() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startCanceler();
    }

    @Override
    public void startReaper() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startReaper();
    }

    @Override
    public void startServiceInfoResolver(ServiceInfoImpl serviceInfoImpl) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startServiceInfoResolver(serviceInfoImpl);
    }

    @Override
    public void startTypeResolver() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startTypeResolver();
    }

    @Override
    public void startServiceResolver(String string) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startServiceResolver(string);
    }

    @Override
    public void startResponder(DNSIncoming dNSIncoming, int n) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startResponder(dNSIncoming, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        logger.finer(this.getName() + "recover()");
        if (this.isClosing() || this.isClosed() || this.isCanceling() || this.isCanceled()) {
            return;
        }
        Object object = this._recoverLock;
        synchronized (object) {
            if (this.cancelState()) {
                logger.finer(this.getName() + "recover() thread " + Thread.currentThread().getName());
                Thread thread = new Thread(this.getName() + ".recover()"){

                    @Override
                    public void run() {
                        JmDNSImpl.this.__recover();
                    }
                };
                thread.start();
            }
        }
    }

    void __recover() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + "recover() Cleanning up");
        }
        logger.warning("RECOVERING");
        this.purgeTimer();
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>(this.getServices().values());
        this.unregisterAllServices();
        this.disposeServiceCollectors();
        this.waitForCanceled(5000L);
        this.purgeStateTimer();
        this.closeMulticastSocket();
        this.getCache().clear();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + "recover() All is clean");
        }
        if (this.isCanceled()) {
            for (ServiceInfo serviceInfo : arrayList) {
                ((ServiceInfoImpl)serviceInfo).recoverState();
            }
            this.recoverState();
            try {
                this.openMulticastSocket(this.getLocalHost());
                this.start(arrayList);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, this.getName() + "recover() Start services exception ", exception);
            }
            logger.log(Level.WARNING, this.getName() + "recover() We are back!");
        } else {
            logger.log(Level.WARNING, this.getName() + "recover() Could not recover we are Down!");
            if (this.getDelegate() != null) {
                this.getDelegate().cannotRecoverFromIOError(this.getDns(), arrayList);
            }
        }
    }

    public void cleanCache() {
        long l = System.currentTimeMillis();
        for (DNSEntry dNSEntry : this.getCache().allValues()) {
            try {
                DNSRecord dNSRecord = (DNSRecord)dNSEntry;
                if (dNSRecord.isExpired(l)) {
                    this.updateRecord(l, dNSRecord, Operation.Remove);
                    this.getCache().removeDNSEntry(dNSRecord);
                    continue;
                }
                if (!dNSRecord.isStale(l)) continue;
                this.renewServiceCollector(dNSRecord);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, this.getName() + ".Error while reaping records: " + dNSEntry, exception);
                logger.severe(this.toString());
            }
        }
    }

    @Override
    public void close() {
        if (this.isClosing()) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cancelling JmDNS: " + this);
        }
        if (this.closeState()) {
            logger.finer("Canceling the timer");
            this.cancelTimer();
            this.unregisterAllServices();
            this.disposeServiceCollectors();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Wait for JmDNS cancel: " + this);
            }
            this.waitForCanceled(5000L);
            logger.finer("Canceling the state timer");
            this.cancelStateTimer();
            this._executor.shutdown();
            this.closeMulticastSocket();
            if (this._shutdown != null) {
                Runtime.getRuntime().removeShutdownHook(this._shutdown);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("JmDNS closed.");
            }
        }
        this.advanceState(null);
    }

    @Override
    @Deprecated
    public void printServices() {
        System.err.println(this.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("\t---- Local Host -----");
        stringBuilder.append("\n\t");
        stringBuilder.append(this._localHost);
        stringBuilder.append("\n\t---- Services -----");
        for (String string : this._services.keySet()) {
            stringBuilder.append("\n\t\tService: ");
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this._services.get(string));
        }
        stringBuilder.append("\n");
        stringBuilder.append("\t---- Types ----");
        for (String string : this._serviceTypes.keySet()) {
            ServiceTypeEntry serviceTypeEntry = (ServiceTypeEntry)this._serviceTypes.get(string);
            stringBuilder.append("\n\t\tType: ");
            stringBuilder.append(serviceTypeEntry.getType());
            stringBuilder.append(": ");
            stringBuilder.append(serviceTypeEntry.isEmpty() ? "no subtypes" : serviceTypeEntry);
        }
        stringBuilder.append("\n");
        stringBuilder.append(this._cache.toString());
        stringBuilder.append("\n");
        stringBuilder.append("\t---- Service Collectors ----");
        for (String string : this._serviceCollectors.keySet()) {
            stringBuilder.append("\n\t\tService Collector: ");
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this._serviceCollectors.get(string));
        }
        stringBuilder.append("\n");
        stringBuilder.append("\t---- Service Listeners ----");
        for (String string : this._serviceListeners.keySet()) {
            stringBuilder.append("\n\t\tService Listener: ");
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this._serviceListeners.get(string));
        }
        return stringBuilder.toString();
    }

    @Override
    public ServiceInfo[] list(String string) {
        return this.list(string, 6000L);
    }

    @Override
    public ServiceInfo[] list(String string, long l) {
        this.cleanCache();
        String string2 = string.toLowerCase();
        boolean bl = false;
        if (this.isCanceling() || this.isCanceled()) {
            return new ServiceInfo[0];
        }
        ServiceCollector serviceCollector = (ServiceCollector)this._serviceCollectors.get(string2);
        if (serviceCollector == null) {
            bl = this._serviceCollectors.putIfAbsent(string2, new ServiceCollector(string)) == null;
            serviceCollector = (ServiceCollector)this._serviceCollectors.get(string2);
            if (bl) {
                this.addServiceListener(string, serviceCollector, true);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ".collector: " + serviceCollector);
        }
        return serviceCollector != null ? serviceCollector.list(l) : new ServiceInfo[]{};
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String string) {
        return this.listBySubtype(string, 6000L);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String string, long l) {
        HashMap hashMap = new HashMap(5);
        for (ServiceInfo object : this.list(string, l)) {
            String string2 = object.getSubtype().toLowerCase();
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, new ArrayList(10));
            }
            ((List)hashMap.get(string2)).add(object);
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (String string3 : hashMap.keySet()) {
            List list = (List)hashMap.get(string3);
            hashMap2.put(string3, list.toArray(new ServiceInfo[list.size()]));
        }
        return hashMap2;
    }

    private void disposeServiceCollectors() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("disposeServiceCollectors()");
        }
        for (String string : this._serviceCollectors.keySet()) {
            ServiceCollector serviceCollector = (ServiceCollector)this._serviceCollectors.get(string);
            if (serviceCollector == null) continue;
            this.removeServiceListener(string, serviceCollector);
            this._serviceCollectors.remove(string, serviceCollector);
        }
    }

    static String toUnqualifiedName(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        if (string4.endsWith(string3) && !string4.equals(string3)) {
            return string2.substring(0, string2.length() - string.length() - 1);
        }
        return string2;
    }

    public Map<String, ServiceInfo> getServices() {
        return this._services;
    }

    public void setLastThrottleIncrement(long l) {
        this._lastThrottleIncrement = l;
    }

    public long getLastThrottleIncrement() {
        return this._lastThrottleIncrement;
    }

    public void setThrottle(int n) {
        this._throttle = n;
    }

    public int getThrottle() {
        return this._throttle;
    }

    public static Random getRandom() {
        return _random;
    }

    public void ioLock() {
        this._ioLock.lock();
    }

    public void ioUnlock() {
        this._ioLock.unlock();
    }

    public void setPlannedAnswer(DNSIncoming dNSIncoming) {
        this._plannedAnswer = dNSIncoming;
    }

    public DNSIncoming getPlannedAnswer() {
        return this._plannedAnswer;
    }

    void setLocalHost(HostInfo hostInfo) {
        this._localHost = hostInfo;
    }

    public Map<String, ServiceTypeEntry> getServiceTypes() {
        return this._serviceTypes;
    }

    public MulticastSocket getSocket() {
        return this._socket;
    }

    public InetAddress getGroup() {
        return this._group;
    }

    @Override
    public JmDNS.Delegate getDelegate() {
        return this._delegate;
    }

    @Override
    public JmDNS.Delegate setDelegate(JmDNS.Delegate delegate) {
        JmDNS.Delegate delegate2 = this._delegate;
        this._delegate = delegate;
        return delegate2;
    }

    private static class ServiceCollector
    implements ServiceListener {
        private final ConcurrentMap<String, ServiceInfo> _infos = new ConcurrentHashMap<String, ServiceInfo>();
        private final ConcurrentMap<String, ServiceEvent> _events = new ConcurrentHashMap<String, ServiceEvent>();
        private final String _type;
        private volatile boolean _needToWaitForInfos;

        public ServiceCollector(String string) {
            this._type = string;
            this._needToWaitForInfos = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceAdded(ServiceEvent serviceEvent) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                ServiceInfo serviceInfo = serviceEvent.getInfo();
                if (serviceInfo != null && serviceInfo.hasData()) {
                    this._infos.put(serviceEvent.getName(), serviceInfo);
                } else {
                    String string = serviceInfo != null ? serviceInfo.getSubtype() : "";
                    serviceInfo = ((JmDNSImpl)serviceEvent.getDNS()).resolveServiceInfo(serviceEvent.getType(), serviceEvent.getName(), string, true);
                    if (serviceInfo != null) {
                        this._infos.put(serviceEvent.getName(), serviceInfo);
                    } else {
                        this._events.put(serviceEvent.getName(), serviceEvent);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceRemoved(ServiceEvent serviceEvent) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this._infos.remove(serviceEvent.getName());
                this._events.remove(serviceEvent.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceResolved(ServiceEvent serviceEvent) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this._infos.put(serviceEvent.getName(), serviceEvent.getInfo());
                this._events.remove(serviceEvent.getName());
            }
        }

        public ServiceInfo[] list(long l) {
            if (this._infos.isEmpty() || !this._events.isEmpty() || this._needToWaitForInfos) {
                long l2 = l / 200L;
                if (l2 < 1L) {
                    l2 = 1L;
                }
                int n = 0;
                while ((long)n < l2) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._events.isEmpty() && !this._infos.isEmpty() && !this._needToWaitForInfos) break;
                    ++n;
                }
            }
            this._needToWaitForInfos = false;
            return this._infos.values().toArray(new ServiceInfo[this._infos.size()]);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n\tType: ");
            stringBuffer.append(this._type);
            if (this._infos.isEmpty()) {
                stringBuffer.append("\n\tNo services collected.");
            } else {
                stringBuffer.append("\n\tServices");
                for (String string : this._infos.keySet()) {
                    stringBuffer.append("\n\t\tService: ");
                    stringBuffer.append(string);
                    stringBuffer.append(": ");
                    stringBuffer.append(this._infos.get(string));
                }
            }
            if (this._events.isEmpty()) {
                stringBuffer.append("\n\tNo event queued.");
            } else {
                stringBuffer.append("\n\tEvents");
                for (String string : this._events.keySet()) {
                    stringBuffer.append("\n\t\tEvent: ");
                    stringBuffer.append(string);
                    stringBuffer.append(": ");
                    stringBuffer.append(this._events.get(string));
                }
            }
            return stringBuffer.toString();
        }
    }

    protected class Shutdown
    implements Runnable {
        protected Shutdown() {
        }

        @Override
        public void run() {
            try {
                JmDNSImpl.this._shutdown = null;
                JmDNSImpl.this.close();
            }
            catch (Throwable throwable) {
                System.err.println("Error while shuting down. " + throwable);
            }
        }
    }

    public static class ServiceTypeEntry
    extends AbstractMap<String, String>
    implements Cloneable {
        private final Set<Map.Entry<String, String>> _entrySet;
        private final String _type;

        public ServiceTypeEntry(String string) {
            this._type = string;
            this._entrySet = new HashSet<Map.Entry<String, String>>();
        }

        public String getType() {
            return this._type;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this._entrySet;
        }

        public boolean contains(String string) {
            return string != null && this.containsKey(string.toLowerCase());
        }

        public boolean add(String string) {
            if (string == null || this.contains(string)) {
                return false;
            }
            this._entrySet.add(new SubTypeEntry(string));
            return true;
        }

        public Iterator<String> iterator() {
            return this.keySet().iterator();
        }

        @Override
        public ServiceTypeEntry clone() {
            ServiceTypeEntry serviceTypeEntry = new ServiceTypeEntry(this.getType());
            for (Map.Entry<String, String> entry : this.entrySet()) {
                serviceTypeEntry.add(entry.getValue());
            }
            return serviceTypeEntry;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            if (this.isEmpty()) {
                stringBuilder.append("empty");
            } else {
                for (String string : this.values()) {
                    stringBuilder.append(string);
                    stringBuilder.append(", ");
                }
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            return stringBuilder.toString();
        }

        private static class SubTypeEntry
        implements Map.Entry<String, String>,
        Serializable,
        Cloneable {
            private static final long serialVersionUID = 9188503522395855322L;
            private final String _key;
            private final String _value;

            public SubTypeEntry(String string) {
                this._value = string != null ? string : "";
                this._key = this._value.toLowerCase();
            }

            @Override
            public String getKey() {
                return this._key;
            }

            @Override
            public String getValue() {
                return this._value;
            }

            @Override
            public String setValue(String string) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return this.getKey().equals(((Map.Entry)object).getKey()) && this.getValue().equals(((Map.Entry)object).getValue());
            }

            @Override
            public int hashCode() {
                return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
            }

            public SubTypeEntry clone() {
                return this;
            }

            public String toString() {
                return this._key + "=" + this._value;
            }
        }
    }

    public static enum Operation {
        Remove,
        Update,
        Add,
        RegisterServiceType,
        Noop;

    }
}

