/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.mrbean.BeanUtil;
import com.fasterxml.jackson.module.mrbean.POJOProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class BeanBuilder {
    protected Map<String, POJOProperty> _beanProperties = new LinkedHashMap<String, POJOProperty>();
    protected LinkedHashMap<String, Method> _unsupportedMethods = new LinkedHashMap();
    protected final Class<?> _implementedType;
    protected final TypeFactory _typeFactory;

    public BeanBuilder(Class<?> clazz, TypeFactory typeFactory) {
        this._implementedType = clazz;
        this._typeFactory = typeFactory;
    }

    public BeanBuilder implement(boolean bl) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(this._implementedType);
        BeanUtil.findSuperTypes(this._implementedType, Object.class, arrayList);
        boolean bl2 = !this._implementedType.isInterface();
        for (Class<?> clazz : arrayList) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                String string = method.getName();
                int n = method.getParameterTypes().length;
                if (n == 0) {
                    if (string.startsWith("get") || string.startsWith("is") && BeanBuilder.returnsBoolean(method)) {
                        this.addGetter(method);
                        continue;
                    }
                } else if (n == 1 && string.startsWith("set")) {
                    this.addSetter(method);
                    continue;
                }
                if (BeanUtil.isConcrete(method) || this._unsupportedMethods.containsKey(string) || bl2 && this.hasConcreteOverride(method, this._implementedType)) continue;
                if (bl) {
                    throw new IllegalArgumentException("Unrecognized abstract method '" + string + "' (not a getter or setter) -- to avoid exception, disable AbstractTypeMaterializer.Feature.FAIL_ON_UNMATERIALIZED_METHOD");
                }
                this._unsupportedMethods.put(string, method);
            }
        }
        return this;
    }

    public byte[] build(String string) {
        String string2;
        ClassWriter classWriter = new ClassWriter(1);
        String string3 = this.getInternalClassName(string);
        String string4 = this.getInternalClassName(this._implementedType.getName());
        if (this._implementedType.isInterface()) {
            string2 = "java/lang/Object";
            classWriter.visit(49, 33, string3, null, string2, new String[]{string4});
        } else {
            string2 = string4;
            classWriter.visit(49, 33, string3, null, string4, null);
        }
        classWriter.visitSource(string + ".java", null);
        BeanBuilder.generateDefaultConstructor(classWriter, string2);
        for (POJOProperty object : this._beanProperties.values()) {
            TypeDescription typeDescription = object.selectType(this._typeFactory);
            this.createField(classWriter, object, typeDescription);
            if (!object.hasConcreteGetter()) {
                this.createGetter(classWriter, string3, object, typeDescription);
            }
            if (object.hasConcreteSetter()) continue;
            this.createSetter(classWriter, string3, object, typeDescription);
        }
        for (Method method : this._unsupportedMethods.values()) {
            this.createUnimplementedMethod(classWriter, string3, method);
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    protected boolean hasConcreteOverride(Method method, Class<?> clazz) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        for (Class<?> clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            try {
                Method method2 = clazz2.getDeclaredMethod(string, classArray);
                if (method2 == null || !BeanUtil.isConcrete(method2)) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    protected String getPropertyName(String string) {
        int n = string.startsWith("is") ? 2 : 3;
        return this.decap(string.substring(n));
    }

    protected String buildGetterName(String string) {
        return this.cap("get", string);
    }

    protected String buildSetterName(String string) {
        return this.cap("set", string);
    }

    protected String getInternalClassName(String string) {
        return string.replace(".", "/");
    }

    protected void addGetter(Method method) {
        POJOProperty pOJOProperty = this.findProperty(this.getPropertyName(method.getName()));
        if (pOJOProperty.getGetter() == null) {
            pOJOProperty.setGetter(method);
        }
    }

    protected void addSetter(Method method) {
        POJOProperty pOJOProperty = this.findProperty(this.getPropertyName(method.getName()));
        if (pOJOProperty.getSetter() == null) {
            pOJOProperty.setSetter(method);
        }
    }

    protected POJOProperty findProperty(String string) {
        POJOProperty pOJOProperty = this._beanProperties.get(string);
        if (pOJOProperty == null) {
            pOJOProperty = new POJOProperty(string, this._implementedType);
            this._beanProperties.put(string, pOJOProperty);
        }
        return pOJOProperty;
    }

    protected static final boolean returnsBoolean(Method method) {
        Class<?> clazz = method.getReturnType();
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    protected static void generateDefaultConstructor(ClassWriter classWriter, String string) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected void createField(ClassWriter classWriter, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string = typeDescription.hasGenerics() ? typeDescription.genericSignature() : null;
        String string2 = typeDescription.erasedSignature();
        FieldVisitor fieldVisitor = classWriter.visitField(4, pOJOProperty.getFieldName(), string2, string, null);
        fieldVisitor.visitEnd();
    }

    protected void createSetter(ClassWriter classWriter, String string, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string2;
        String string3;
        Method method = pOJOProperty.getSetter();
        if (method != null) {
            string3 = Type.getMethodDescriptor((Method)method);
            string2 = method.getName();
        } else {
            string3 = "(" + typeDescription.erasedSignature() + ")V";
            string2 = this.buildSetterName(pOJOProperty.getName());
        }
        String string4 = typeDescription.hasGenerics() ? "(" + typeDescription.genericSignature() + ")V" : null;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, string3, string4, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(typeDescription.getLoadOpcode(), 1);
        methodVisitor.visitFieldInsn(181, string, pOJOProperty.getFieldName(), typeDescription.erasedSignature());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected void createGetter(ClassWriter classWriter, String string, POJOProperty pOJOProperty, TypeDescription typeDescription) {
        String string2;
        String string3;
        Method method = pOJOProperty.getGetter();
        if (method != null) {
            string3 = Type.getMethodDescriptor((Method)method);
            string2 = method.getName();
        } else {
            string3 = "()" + typeDescription.erasedSignature();
            string2 = this.buildGetterName(pOJOProperty.getName());
        }
        String string4 = typeDescription.hasGenerics() ? "()" + typeDescription.genericSignature() : null;
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string2, string3, string4, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, string, pOJOProperty.getFieldName(), typeDescription.erasedSignature());
        methodVisitor.visitInsn(typeDescription.getReturnOpcode());
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected void createUnimplementedMethod(ClassWriter classWriter, String string, Method method) {
        String string2 = this.getInternalClassName(UnsupportedOperationException.class.getName());
        String string3 = Type.getMethodDescriptor((Method)method);
        String string4 = method.getName();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, string4, string3, null, null);
        methodVisitor.visitTypeInsn(187, string2);
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)("Unimplemented method '" + string4 + "' (not a setter/getter, could not materialize)"));
        methodVisitor.visitMethodInsn(183, string2, "<init>", "(Ljava/lang/String;)V", false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected String decap(String string) {
        char c = string.charAt(0);
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(c)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(c);
        return new String(cArray);
    }

    protected String cap(String string, String string2) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + string2.length());
        stringBuilder.append(string);
        stringBuilder.append(string2);
        stringBuilder.setCharAt(n, Character.toUpperCase(string2.charAt(0)));
        return stringBuilder.toString();
    }

    static class TypeDescription {
        private final Type _asmType;
        private JavaType _jacksonType;

        public TypeDescription(JavaType javaType) {
            this._jacksonType = javaType;
            this._asmType = Type.getType((Class)javaType.getRawClass());
        }

        public Class<?> getRawClass() {
            return this._jacksonType.getRawClass();
        }

        public String erasedSignature() {
            return this._jacksonType.getErasedSignature();
        }

        public String genericSignature() {
            return this._jacksonType.getGenericSignature();
        }

        public boolean hasGenerics() {
            return this._jacksonType.hasGenericTypes();
        }

        public int getLoadOpcode() {
            return this._asmType.getOpcode(21);
        }

        public int getReturnOpcode() {
            return this._asmType.getOpcode(172);
        }

        public String toString() {
            return this._jacksonType.toString();
        }

        public static TypeDescription moreSpecificType(TypeDescription typeDescription, TypeDescription typeDescription2) {
            Class<?> clazz;
            Class<?> clazz2 = typeDescription.getRawClass();
            if (clazz2.isAssignableFrom(clazz = typeDescription2.getRawClass())) {
                return typeDescription2;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return typeDescription;
            }
            return null;
        }
    }
}

