/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.FilteredBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.std.AtomicReferenceSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class BeanSerializerFactory
extends BasicSerializerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);

    protected BeanSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        super(serializerFactoryConfig);
    }

    @Override
    public SerializerFactory withConfig(SerializerFactoryConfig serializerFactoryConfig) {
        if (this._factoryConfig == serializerFactoryConfig) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': can not instantiate subtype with " + "additional serializer definitions");
        }
        return new BeanSerializerFactory(serializerFactoryConfig);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializerProvider serializerProvider, JavaType javaType) throws JsonMappingException {
        boolean bl;
        JavaType javaType2;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        Object t = serializationConfig.introspect(javaType);
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, ((BeanDescription)t).getClassInfo());
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            javaType2 = javaType;
        } else {
            try {
                javaType2 = annotationIntrospector.refineSerializationType(serializationConfig, ((BeanDescription)t).getClassInfo(), javaType);
            }
            catch (JsonMappingException jsonMappingException) {
                return (JsonSerializer)serializerProvider.reportBadTypeDefinition((BeanDescription)t, jsonMappingException.getMessage(), new Object[0]);
            }
        }
        if (javaType2 == javaType) {
            bl = false;
        } else {
            bl = true;
            if (!javaType2.hasRawClass(javaType.getRawClass())) {
                t = serializationConfig.introspect(javaType2);
            }
        }
        Converter<Object, Object> converter = ((BeanDescription)t).findSerializationConverter();
        if (converter == null) {
            return this._createSerializer2(serializerProvider, javaType2, (BeanDescription)t, bl);
        }
        JavaType javaType3 = converter.getOutputType(serializerProvider.getTypeFactory());
        if (!javaType3.hasRawClass(javaType2.getRawClass())) {
            t = serializationConfig.introspect(javaType3);
            jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, ((BeanDescription)t).getClassInfo());
        }
        if (jsonSerializer == null && !javaType3.isJavaLangObject()) {
            jsonSerializer = this._createSerializer2(serializerProvider, javaType3, (BeanDescription)t, true);
        }
        return new StdDelegatingSerializer(converter, javaType3, jsonSerializer);
    }

    protected JsonSerializer<?> _createSerializer2(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = null;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (javaType.isContainerType()) {
            if (!bl) {
                bl = this.usesStaticTyping(serializationConfig, beanDescription, null);
            }
            if ((jsonSerializer = this.buildContainerSerializer(serializerProvider, javaType, beanDescription, bl)) != null) {
                return jsonSerializer;
            }
        } else {
            if (javaType.isReferenceType()) {
                jsonSerializer = this.findReferenceSerializer(serializerProvider, (ReferenceType)javaType, beanDescription, bl);
            } else {
                Serializers object;
                Iterator<Object> iterator = this.customSerializers().iterator();
                while (iterator.hasNext() && (jsonSerializer = (object = iterator.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
                }
            }
            if (jsonSerializer == null) {
                jsonSerializer = this.findSerializerByAnnotations(serializerProvider, javaType, beanDescription);
            }
        }
        if (jsonSerializer == null && (jsonSerializer = this.findSerializerByLookup(javaType, serializationConfig, beanDescription, bl)) == null && (jsonSerializer = this.findSerializerByPrimaryType(serializerProvider, javaType, beanDescription, bl)) == null && (jsonSerializer = this.findBeanSerializer(serializerProvider, javaType, beanDescription)) == null && (jsonSerializer = this.findSerializerByAddonType(serializationConfig, javaType, beanDescription, bl)) == null) {
            jsonSerializer = serializerProvider.getUnknownTypeSerializer(beanDescription.getBeanClass());
        }
        if (jsonSerializer != null && this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer = beanSerializerModifier.modifySerializer(serializationConfig, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    public JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        if (!this.isPotentialBeanType(javaType.getRawClass()) && !javaType.isEnumType()) {
            return null;
        }
        return this.constructBeanSerializer(serializerProvider, beanDescription);
    }

    public JsonSerializer<?> findReferenceSerializer(SerializerProvider serializerProvider, ReferenceType referenceType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType = referenceType.getContentType();
        TypeSerializer typeSerializer = (TypeSerializer)javaType.getTypeHandler();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (typeSerializer == null) {
            typeSerializer = this.createTypeSerializer(serializationConfig, javaType);
        }
        JsonSerializer jsonSerializer = (JsonSerializer)javaType.getValueHandler();
        for (Serializers serializers : this.customSerializers()) {
            JsonSerializer<?> jsonSerializer2 = serializers.findReferenceSerializer(serializationConfig, referenceType, beanDescription, typeSerializer, jsonSerializer);
            if (jsonSerializer2 == null) continue;
            return jsonSerializer2;
        }
        if (referenceType.isTypeOrSubTypeOf(AtomicReference.class)) {
            return new AtomicReferenceSerializer(referenceType, bl, typeSerializer, jsonSerializer);
        }
        return null;
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        TypeSerializer typeSerializer;
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyTypeResolver(serializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeSerializer = this.createTypeSerializer(serializationConfig, javaType);
        } else {
            Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, annotatedMember, javaType);
            typeSerializer = typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, collection);
        }
        return typeSerializer;
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType javaType, SerializationConfig serializationConfig, AnnotatedMember annotatedMember) throws JsonMappingException {
        TypeSerializer typeSerializer;
        JavaType javaType2 = javaType.getContentType();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(serializationConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        } else {
            Collection<NamedType> collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, annotatedMember, javaType2);
            typeSerializer = typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType2, collection);
        }
        return typeSerializer;
    }

    protected JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer;
        if (beanDescription.getBeanClass() == Object.class) {
            return serializerProvider.getUnknownTypeSerializer(Object.class);
        }
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        BeanSerializerBuilder beanSerializerBuilder = this.constructBeanSerializerBuilder(beanDescription);
        beanSerializerBuilder.setConfig(serializationConfig);
        List<BeanPropertyWriter> list = this.findBeanProperties(serializerProvider, beanDescription, beanSerializerBuilder);
        list = list == null ? new ArrayList<BeanPropertyWriter>() : this.removeOverlappingTypeIds(serializerProvider, beanDescription, beanSerializerBuilder, list);
        serializerProvider.getAnnotationIntrospector().findAndAddVirtualProperties(serializationConfig, beanDescription.getClassInfo(), list);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier object2 : this._factoryConfig.serializerModifiers()) {
                list = object2.changeProperties(serializationConfig, beanDescription, list);
            }
        }
        list = this.filterBeanProperties(serializationConfig, beanDescription, list);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                list = beanSerializerModifier.orderProperties(serializationConfig, beanDescription, list);
            }
        }
        beanSerializerBuilder.setObjectIdWriter(this.constructObjectIdHandler(serializerProvider, beanDescription, list));
        beanSerializerBuilder.setProperties(list);
        beanSerializerBuilder.setFilterId(this.findFilterId(serializationConfig, beanDescription));
        AnnotatedMember annotatedMember = beanDescription.findAnyGetter();
        if (annotatedMember != null) {
            JavaType javaType = annotatedMember.getType();
            boolean bl = serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
            JavaType javaType2 = javaType.getContentType();
            TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
            MapSerializer mapSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
            if (mapSerializer == null) {
                mapSerializer = MapSerializer.construct((Set<String>)null, javaType, bl, typeSerializer, null, null, null);
            }
            PropertyName propertyName = PropertyName.construct(annotatedMember.getName());
            BeanProperty.Std std = new BeanProperty.Std(propertyName, javaType2, null, beanDescription.getClassAnnotations(), annotatedMember, PropertyMetadata.STD_OPTIONAL);
            beanSerializerBuilder.setAnyGetter(new AnyGetterWriter(std, annotatedMember, mapSerializer));
        }
        this.processViews(serializationConfig, beanSerializerBuilder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                beanSerializerBuilder = beanSerializerModifier.updateBuilder(serializationConfig, beanDescription, beanSerializerBuilder);
            }
        }
        if ((jsonSerializer = beanSerializerBuilder.build()) == null && beanDescription.hasKnownClassAnnotations()) {
            return beanSerializerBuilder.createDummy();
        }
        return jsonSerializer;
    }

    protected ObjectIdWriter constructObjectIdHandler(SerializerProvider serializerProvider, BeanDescription beanDescription, List<BeanPropertyWriter> list) throws JsonMappingException {
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return null;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            String string = objectIdInfo.getPropertyName().getSimpleName();
            BeanPropertyWriter beanPropertyWriter = null;
            int n = 0;
            int n2 = list.size();
            while (true) {
                if (n == n2) {
                    throw new IllegalArgumentException("Invalid Object Id definition for " + beanDescription.getBeanClass().getName() + ": can not find property with name '" + string + "'");
                }
                BeanPropertyWriter beanPropertyWriter2 = list.get(n);
                if (string.equals(beanPropertyWriter2.getName())) {
                    beanPropertyWriter = beanPropertyWriter2;
                    if (n <= 0) break;
                    list.remove(n);
                    list.add(0, beanPropertyWriter);
                    break;
                }
                ++n;
            }
            JavaType javaType = beanPropertyWriter.getType();
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo, beanPropertyWriter);
            return ObjectIdWriter.construct(javaType, (PropertyName)null, propertyBasedObjectIdGenerator, objectIdInfo.getAlwaysAsId());
        }
        JavaType javaType = serializerProvider.constructType(clazz);
        JavaType javaType2 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
        ObjectIdGenerator<?> objectIdGenerator = serializerProvider.objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        return ObjectIdWriter.construct(javaType2, objectIdInfo.getPropertyName(), objectIdGenerator, objectIdInfo.getAlwaysAsId());
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        return FilteredBeanPropertyWriter.constructViewBased(beanPropertyWriter, classArray);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return new PropertyBuilder(serializationConfig, beanDescription);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BeanDescription beanDescription) {
        return new BeanSerializerBuilder(beanDescription);
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        return ClassUtil.canBeABeanType(clazz) == null && !ClassUtil.isProxyType(clazz);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder beanSerializerBuilder) throws JsonMappingException {
        List<BeanPropertyDefinition> list = beanDescription.findProperties();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        this.removeIgnorableTypes(serializationConfig, beanDescription, list);
        if (serializationConfig.isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
            this.removeSetterlessGetters(serializationConfig, beanDescription, list);
        }
        if (list.isEmpty()) {
            return null;
        }
        boolean bl = this.usesStaticTyping(serializationConfig, beanDescription, null);
        PropertyBuilder propertyBuilder = this.constructPropertyBuilder(serializationConfig, beanDescription);
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(list.size());
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (beanPropertyDefinition.isTypeId()) {
                if (annotatedMember == null) continue;
                beanSerializerBuilder.setTypeId(annotatedMember);
                continue;
            }
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty != null && referenceProperty.isBackReference()) continue;
            if (annotatedMember instanceof AnnotatedMethod) {
                arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, propertyBuilder, bl, (AnnotatedMethod)annotatedMember));
                continue;
            }
            arrayList.add(this._constructWriter(serializerProvider, beanPropertyDefinition, propertyBuilder, bl, (AnnotatedField)annotatedMember));
        }
        return arrayList;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        Set set;
        JsonIgnoreProperties.Value value = serializationConfig.getDefaultPropertyIgnorals(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        if (value != null && !(set = value.findIgnoredForSerialization()).isEmpty()) {
            Iterator<BeanPropertyWriter> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!set.contains(iterator.next().getName())) continue;
                iterator.remove();
            }
        }
        return list;
    }

    protected void processViews(SerializationConfig serializationConfig, BeanSerializerBuilder beanSerializerBuilder) {
        List<BeanPropertyWriter> list = beanSerializerBuilder.getProperties();
        boolean bl = serializationConfig.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        int n = list.size();
        int n2 = 0;
        BeanPropertyWriter[] beanPropertyWriterArray = new BeanPropertyWriter[n];
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = list.get(i);
            Class<?>[] classArray = beanPropertyWriter.getViews();
            if (classArray == null) {
                if (!bl) continue;
                beanPropertyWriterArray[i] = beanPropertyWriter;
                continue;
            }
            ++n2;
            beanPropertyWriterArray[i] = this.constructFilteredBeanWriter(beanPropertyWriter, classArray);
        }
        if (bl && n2 == 0) {
            return;
        }
        beanSerializerBuilder.setFilteredProperties(beanPropertyWriterArray);
    }

    protected void removeIgnorableTypes(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        HashMap hashMap = new HashMap();
        Iterator<BeanPropertyDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (annotatedMember == null) {
                iterator.remove();
                continue;
            }
            Class<?> clazz = annotatedMember.getRawType();
            Boolean bl = (Boolean)hashMap.get(clazz);
            if (bl == null) {
                BeanDescription beanDescription2;
                AnnotatedClass annotatedClass;
                ConfigOverride configOverride = serializationConfig.findConfigOverride(clazz);
                if (configOverride != null) {
                    bl = configOverride.getIsIgnoredType();
                }
                if (bl == null && (bl = annotationIntrospector.isIgnorableType(annotatedClass = (beanDescription2 = serializationConfig.introspectClassAnnotations(clazz)).getClassInfo())) == null) {
                    bl = Boolean.FALSE;
                }
                hashMap.put(clazz, bl);
            }
            if (!bl.booleanValue()) continue;
            iterator.remove();
        }
    }

    protected void removeSetterlessGetters(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        Iterator<BeanPropertyDefinition> iterator = list.iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            if (beanPropertyDefinition.couldDeserialize() || beanPropertyDefinition.isExplicitlyIncluded()) continue;
            iterator.remove();
        }
    }

    protected List<BeanPropertyWriter> removeOverlappingTypeIds(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder beanSerializerBuilder, List<BeanPropertyWriter> list) {
        int n = list.size();
        block0: for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = list.get(i);
            TypeSerializer typeSerializer = beanPropertyWriter.getTypeSerializer();
            if (typeSerializer == null || typeSerializer.getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            String string = typeSerializer.getPropertyName();
            PropertyName propertyName = PropertyName.construct(string);
            for (BeanPropertyWriter beanPropertyWriter2 : list) {
                if (beanPropertyWriter2 == beanPropertyWriter || !beanPropertyWriter2.wouldConflictWithName(propertyName)) continue;
                beanPropertyWriter.assignTypeSerializer(null);
                continue block0;
            }
        }
        return list;
    }

    protected BeanPropertyWriter _constructWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, PropertyBuilder propertyBuilder, boolean bl, AnnotatedMember annotatedMember) throws JsonMappingException {
        PropertyName propertyName = beanPropertyDefinition.getFullName();
        JavaType javaType = annotatedMember.getType();
        BeanProperty.Std std = new BeanProperty.Std(propertyName, javaType, beanPropertyDefinition.getWrapperName(), propertyBuilder.getClassAnnotations(), annotatedMember, beanPropertyDefinition.getMetadata());
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
        }
        jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, std);
        TypeSerializer typeSerializer = null;
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            typeSerializer = this.findPropertyContentTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        }
        TypeSerializer typeSerializer2 = this.findPropertyTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        return propertyBuilder.buildWriter(serializerProvider, beanPropertyDefinition, javaType, jsonSerializer, typeSerializer2, typeSerializer, annotatedMember, bl);
    }
}

