/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;

public class NumberDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return IntegerDeserializer.primitiveInstance;
            }
            if (clazz == Boolean.TYPE) {
                return BooleanDeserializer.primitiveInstance;
            }
            if (clazz == Long.TYPE) {
                return LongDeserializer.primitiveInstance;
            }
            if (clazz == Double.TYPE) {
                return DoubleDeserializer.primitiveInstance;
            }
            if (clazz == Character.TYPE) {
                return CharacterDeserializer.primitiveInstance;
            }
            if (clazz == Byte.TYPE) {
                return ByteDeserializer.primitiveInstance;
            }
            if (clazz == Short.TYPE) {
                return ShortDeserializer.primitiveInstance;
            }
            if (clazz == Float.TYPE) {
                return FloatDeserializer.primitiveInstance;
            }
        } else if (_classNames.contains(string)) {
            if (clazz == Integer.class) {
                return IntegerDeserializer.wrapperInstance;
            }
            if (clazz == Boolean.class) {
                return BooleanDeserializer.wrapperInstance;
            }
            if (clazz == Long.class) {
                return LongDeserializer.wrapperInstance;
            }
            if (clazz == Double.class) {
                return DoubleDeserializer.wrapperInstance;
            }
            if (clazz == Character.class) {
                return CharacterDeserializer.wrapperInstance;
            }
            if (clazz == Byte.class) {
                return ByteDeserializer.wrapperInstance;
            }
            if (clazz == Short.class) {
                return ShortDeserializer.wrapperInstance;
            }
            if (clazz == Float.class) {
                return FloatDeserializer.wrapperInstance;
            }
            if (clazz == Number.class) {
                return NumberDeserializer.instance;
            }
            if (clazz == BigDecimal.class) {
                return BigDecimalDeserializer.instance;
            }
            if (clazz == BigInteger.class) {
                return BigIntegerDeserializer.instance;
            }
        } else {
            return null;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + clazz.getName());
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, Number.class, BigDecimal.class, BigInteger.class}) {
            _classNames.add(clazz.getName());
        }
    }

    @JacksonStdImpl
    public static class BigDecimalDeserializer
    extends StdScalarDeserializer<BigDecimal> {
        public static final BigDecimalDeserializer instance = new BigDecimalDeserializer();

        public BigDecimalDeserializer() {
            super(BigDecimal.class);
        }

        @Override
        public BigDecimal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: 
                case 8: {
                    return jsonParser.getDecimalValue();
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        return new BigDecimal(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return (BigDecimal)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
                    }
                }
                case 3: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                    jsonParser.nextToken();
                    BigDecimal bigDecimal = this.deserialize(jsonParser, deserializationContext);
                    if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                    }
                    return bigDecimal;
                }
            }
            return (BigDecimal)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class BigIntegerDeserializer
    extends StdScalarDeserializer<BigInteger> {
        public static final BigIntegerDeserializer instance = new BigIntegerDeserializer();

        public BigIntegerDeserializer() {
            super(BigInteger.class);
        }

        @Override
        public BigInteger deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    switch (jsonParser.getNumberType()) {
                        case INT: 
                        case LONG: 
                        case BIG_INTEGER: {
                            return jsonParser.getBigIntegerValue();
                        }
                    }
                    break;
                }
                case 8: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                        this._failDoubleToIntCoercion(jsonParser, deserializationContext, "java.math.BigInteger");
                    }
                    return jsonParser.getDecimalValue().toBigInteger();
                }
                case 3: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                    jsonParser.nextToken();
                    BigInteger bigInteger = this.deserialize(jsonParser, deserializationContext);
                    if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                    }
                    return bigInteger;
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        return new BigInteger(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return (BigInteger)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
                    }
                }
            }
            return (BigInteger)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class NumberDeserializer
    extends StdScalarDeserializer<Object> {
        public static final NumberDeserializer instance = new NumberDeserializer();

        public NumberDeserializer() {
            super(Number.class);
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getDoubleValue();
                }
                case 6: {
                    String string = jsonParser.getText().trim();
                    if (string.length() == 0) {
                        return this.getEmptyValue(deserializationContext);
                    }
                    if (this._hasTextualNull(string)) {
                        return this.getNullValue(deserializationContext);
                    }
                    if (this._isPosInf(string)) {
                        return Double.POSITIVE_INFINITY;
                    }
                    if (this._isNegInf(string)) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    if (this._isNaN(string)) {
                        return Double.NaN;
                    }
                    try {
                        if (!this._isIntNumber(string)) {
                            if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                                return new BigDecimal(string);
                            }
                            return new Double(string);
                        }
                        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                            return new BigInteger(string);
                        }
                        long l = Long.parseLong(string);
                        if (!deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                            return (int)l;
                        }
                        return l;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid number", new Object[0]);
                    }
                }
                case 3: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                    jsonParser.nextToken();
                    Object object = this.deserialize(jsonParser, deserializationContext);
                    if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                    }
                    return object;
                }
            }
            return deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 6: 
                case 7: 
                case 8: {
                    return this.deserialize(jsonParser, deserializationContext);
                }
            }
            return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class DoubleDeserializer
    extends PrimitiveOrWrapperDeserializer<Double> {
        private static final long serialVersionUID = 1L;
        static final DoubleDeserializer primitiveInstance = new DoubleDeserializer(Double.TYPE, 0.0);
        static final DoubleDeserializer wrapperInstance = new DoubleDeserializer(Double.class, null);

        public DoubleDeserializer(Class<Double> clazz, Double d) {
            super(clazz, d);
        }

        @Override
        public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseDouble(jsonParser, deserializationContext);
        }

        @Override
        public Double deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            return this._parseDouble(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class FloatDeserializer
    extends PrimitiveOrWrapperDeserializer<Float> {
        private static final long serialVersionUID = 1L;
        static final FloatDeserializer primitiveInstance = new FloatDeserializer(Float.TYPE, Float.valueOf(0.0f));
        static final FloatDeserializer wrapperInstance = new FloatDeserializer(Float.class, null);

        public FloatDeserializer(Class<Float> clazz, Float f) {
            super(clazz, f);
        }

        @Override
        public Float deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseFloat(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static final class LongDeserializer
    extends PrimitiveOrWrapperDeserializer<Long> {
        private static final long serialVersionUID = 1L;
        static final LongDeserializer primitiveInstance = new LongDeserializer(Long.TYPE, 0L);
        static final LongDeserializer wrapperInstance = new LongDeserializer(Long.class, null);

        public LongDeserializer(Class<Long> clazz, Long l) {
            super(clazz, l);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Long deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return jsonParser.getLongValue();
            }
            return this._parseLong(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static final class IntegerDeserializer
    extends PrimitiveOrWrapperDeserializer<Integer> {
        private static final long serialVersionUID = 1L;
        static final IntegerDeserializer primitiveInstance = new IntegerDeserializer(Integer.TYPE, 0);
        static final IntegerDeserializer wrapperInstance = new IntegerDeserializer(Integer.class, null);

        public IntegerDeserializer(Class<Integer> clazz, Integer n) {
            super(clazz, n);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return jsonParser.getIntValue();
            }
            return this._parseInteger(jsonParser, deserializationContext);
        }

        @Override
        public Integer deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                return jsonParser.getIntValue();
            }
            return this._parseInteger(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class CharacterDeserializer
    extends PrimitiveOrWrapperDeserializer<Character> {
        private static final long serialVersionUID = 1L;
        static final CharacterDeserializer primitiveInstance = new CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000'));
        static final CharacterDeserializer wrapperInstance = new CharacterDeserializer(Character.class, null);

        public CharacterDeserializer(Class<Character> clazz, Character c) {
            super(clazz, c);
        }

        @Override
        public Character deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 7: {
                    int n = jsonParser.getIntValue();
                    if (n < 0 || n > 65535) break;
                    return Character.valueOf((char)n);
                }
                case 6: {
                    String string = jsonParser.getText();
                    if (string.length() == 1) {
                        return Character.valueOf(string.charAt(0));
                    }
                    if (string.length() != 0) break;
                    return (Character)this.getEmptyValue(deserializationContext);
                }
                case 3: {
                    if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                    jsonParser.nextToken();
                    Character c = this.deserialize(jsonParser, deserializationContext);
                    if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                    }
                    return c;
                }
            }
            return (Character)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }
    }

    @JacksonStdImpl
    public static class ShortDeserializer
    extends PrimitiveOrWrapperDeserializer<Short> {
        private static final long serialVersionUID = 1L;
        static final ShortDeserializer primitiveInstance = new ShortDeserializer(Short.TYPE, (short)0);
        static final ShortDeserializer wrapperInstance = new ShortDeserializer(Short.class, null);

        public ShortDeserializer(Class<Short> clazz, Short s) {
            super(clazz, s);
        }

        @Override
        public Short deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseShort(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class ByteDeserializer
    extends PrimitiveOrWrapperDeserializer<Byte> {
        private static final long serialVersionUID = 1L;
        static final ByteDeserializer primitiveInstance = new ByteDeserializer(Byte.TYPE, (byte)0);
        static final ByteDeserializer wrapperInstance = new ByteDeserializer(Byte.class, null);

        public ByteDeserializer(Class<Byte> clazz, Byte by) {
            super(clazz, by);
        }

        @Override
        public Byte deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseByte(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static final class BooleanDeserializer
    extends PrimitiveOrWrapperDeserializer<Boolean> {
        private static final long serialVersionUID = 1L;
        static final BooleanDeserializer primitiveInstance = new BooleanDeserializer(Boolean.TYPE, Boolean.FALSE);
        static final BooleanDeserializer wrapperInstance = new BooleanDeserializer(Boolean.class, null);

        public BooleanDeserializer(Class<Boolean> clazz, Boolean bl) {
            super(clazz, bl);
        }

        @Override
        public Boolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseBoolean(jsonParser, deserializationContext);
        }

        @Override
        public Boolean deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            return this._parseBoolean(jsonParser, deserializationContext);
        }
    }

    protected static abstract class PrimitiveOrWrapperDeserializer<T>
    extends StdScalarDeserializer<T> {
        private static final long serialVersionUID = 1L;
        protected final T _nullValue;
        protected final boolean _primitive;

        protected PrimitiveOrWrapperDeserializer(Class<T> clazz, T t) {
            super(clazz);
            this._nullValue = t;
            this._primitive = clazz.isPrimitive();
        }

        @Override
        public final T getNullValue(DeserializationContext deserializationContext) throws JsonMappingException {
            if (this._primitive && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                deserializationContext.reportMappingException("Can not map JSON null into type %s (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)", this.handledType().toString());
            }
            return this._nullValue;
        }

        @Override
        public T getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
            if (this._primitive && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                deserializationContext.reportMappingException("Can not map Empty String as null into type %s (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)", this.handledType().toString());
            }
            return this._nullValue;
        }
    }
}

