/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BeanPropertyMap
implements Iterable<SettableBeanProperty>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final boolean _caseInsensitive;
    private int _hashMask;
    private int _size;
    private int _spillCount;
    private Object[] _hashArea;
    private SettableBeanProperty[] _propsInOrder;

    public BeanPropertyMap(boolean bl, Collection<SettableBeanProperty> collection) {
        this._caseInsensitive = bl;
        this._propsInOrder = collection.toArray(new SettableBeanProperty[collection.size()]);
        this.init(collection);
    }

    protected BeanPropertyMap(BeanPropertyMap beanPropertyMap, boolean bl) {
        this._caseInsensitive = bl;
        this._propsInOrder = Arrays.copyOf(beanPropertyMap._propsInOrder, beanPropertyMap._propsInOrder.length);
        this.init(Arrays.asList(this._propsInOrder));
    }

    public BeanPropertyMap withCaseInsensitivity(boolean bl) {
        if (this._caseInsensitive == bl) {
            return this;
        }
        return new BeanPropertyMap(this, bl);
    }

    protected void init(Collection<SettableBeanProperty> collection) {
        this._size = collection.size();
        int n = BeanPropertyMap.findSize(this._size);
        this._hashMask = n - 1;
        int n2 = (n + (n >> 1)) * 2;
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        for (SettableBeanProperty settableBeanProperty : collection) {
            if (settableBeanProperty == null) continue;
            String string = this.getPropertyName(settableBeanProperty);
            int n4 = this._hashCode(string);
            int n5 = n4 << 1;
            if (objectArray[n5] != null && objectArray[n5 = n + (n4 >> 1) << 1] != null) {
                n5 = (n + (n >> 1) << 1) + n3;
                n3 += 2;
                if (n5 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n5] = string;
            objectArray[n5 + 1] = settableBeanProperty;
        }
        this._hashArea = objectArray;
        this._spillCount = n3;
    }

    private static final int findSize(int n) {
        int n2;
        if (n <= 5) {
            return 8;
        }
        if (n <= 12) {
            return 16;
        }
        int n3 = n + (n >> 2);
        for (n2 = 32; n2 < n3; n2 += n2) {
        }
        return n2;
    }

    public static BeanPropertyMap construct(Collection<SettableBeanProperty> collection, boolean bl) {
        return new BeanPropertyMap(bl, collection);
    }

    public BeanPropertyMap withProperty(SettableBeanProperty settableBeanProperty) {
        int n;
        String string = this.getPropertyName(settableBeanProperty);
        int n2 = this._hashArea.length;
        for (n = 1; n < n2; n += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[n];
            if (settableBeanProperty2 == null || !settableBeanProperty2.getName().equals(string)) continue;
            this._hashArea[n] = settableBeanProperty;
            this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty2)] = settableBeanProperty;
            return this;
        }
        n = this._hashCode(string);
        n2 = this._hashMask + 1;
        int n3 = n << 1;
        if (this._hashArea[n3] != null && this._hashArea[n3 = n2 + (n >> 1) << 1] != null) {
            n3 = (n2 + (n2 >> 1) << 1) + this._spillCount;
            this._spillCount += 2;
            if (n3 >= this._hashArea.length) {
                this._hashArea = Arrays.copyOf(this._hashArea, this._hashArea.length + 4);
            }
        }
        this._hashArea[n3] = string;
        this._hashArea[n3 + 1] = settableBeanProperty;
        int n4 = this._propsInOrder.length;
        this._propsInOrder = Arrays.copyOf(this._propsInOrder, n4 + 1);
        this._propsInOrder[n4] = settableBeanProperty;
        return this;
    }

    public BeanPropertyMap assignIndexes() {
        int n = 0;
        int n2 = this._hashArea.length;
        for (int i = 1; i < n2; i += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty == null) continue;
            settableBeanProperty.assignIndex(n++);
        }
        return this;
    }

    public BeanPropertyMap renameAll(NameTransformer nameTransformer) {
        if (nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return this;
        }
        int n = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n);
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = this._propsInOrder[i];
            if (settableBeanProperty == null) {
                arrayList.add(settableBeanProperty);
                continue;
            }
            arrayList.add(this._rename(settableBeanProperty, nameTransformer));
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList);
    }

    public BeanPropertyMap withoutProperties(Collection<String> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        int n = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n);
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = this._propsInOrder[i];
            if (settableBeanProperty == null || collection.contains(settableBeanProperty.getName())) continue;
            arrayList.add(settableBeanProperty);
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList);
    }

    public void replace(SettableBeanProperty settableBeanProperty) {
        String string = this.getPropertyName(settableBeanProperty);
        int n = this._findIndexInHash(string);
        if (n >= 0) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[n];
            this._hashArea[n] = settableBeanProperty;
            this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty2)] = settableBeanProperty;
            return;
        }
        throw new NoSuchElementException("No entry '" + string + "' found, can't replace");
    }

    private List<SettableBeanProperty> properties() {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(this._size);
        int n = this._hashArea.length;
        for (int i = 1; i < n; i += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty == null) continue;
            arrayList.add(settableBeanProperty);
        }
        return arrayList;
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return this.properties().iterator();
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        return this._propsInOrder;
    }

    protected final String getPropertyName(SettableBeanProperty settableBeanProperty) {
        return this._caseInsensitive ? settableBeanProperty.getName().toLowerCase() : settableBeanProperty.getName();
    }

    public SettableBeanProperty find(int n) {
        int n2 = this._hashArea.length;
        for (int i = 1; i < n2; i += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty == null || n != settableBeanProperty.getPropertyIndex()) continue;
            return settableBeanProperty;
        }
        return null;
    }

    public SettableBeanProperty find(String string) {
        int n;
        int n2;
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("Can not pass null property name");
        }
        if (this._caseInsensitive) {
            string = string.toLowerCase();
        }
        if ((object = this._hashArea[n2 = (n = string.hashCode() & this._hashMask) << 1]) == string || string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n2 + 1];
        }
        return this._find2(string, n, object);
    }

    private final SettableBeanProperty _find2(String string, int n, Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this._hashMask + 1;
        int n3 = n2 + (n >> 1) << 1;
        object = this._hashArea[n3];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n3 + 1];
        }
        if (object != null) {
            int n4;
            int n5 = n4 + this._spillCount;
            for (n4 = n2 + (n2 >> 1) << 1; n4 < n5; n4 += 2) {
                object = this._hashArea[n4];
                if (object != string && !string.equals(object)) continue;
                return (SettableBeanProperty)this._hashArea[n4 + 1];
            }
        }
        return null;
    }

    public int size() {
        return this._size;
    }

    public void remove(SettableBeanProperty settableBeanProperty) {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(this._size);
        String string = this.getPropertyName(settableBeanProperty);
        boolean bl = false;
        int n = this._hashArea.length;
        for (int i = 1; i < n; i += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[i];
            if (settableBeanProperty2 == null) continue;
            if (!bl && (bl = string.equals(settableBeanProperty2.getName()))) {
                this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty2)] = null;
                continue;
            }
            arrayList.add(settableBeanProperty2);
        }
        if (!bl) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't remove");
        }
        this.init(arrayList);
    }

    public boolean findDeserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException {
        SettableBeanProperty settableBeanProperty = this.find(string);
        if (settableBeanProperty == null) {
            return false;
        }
        try {
            settableBeanProperty.deserializeAndSet(jsonParser, deserializationContext, object);
        }
        catch (Exception exception) {
            this.wrapAndThrow(exception, object, string, deserializationContext);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Properties=[");
        int n = 0;
        for (SettableBeanProperty settableBeanProperty : this) {
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(settableBeanProperty.getName());
            stringBuilder.append('(');
            stringBuilder.append(settableBeanProperty.getType());
            stringBuilder.append(')');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected SettableBeanProperty _rename(SettableBeanProperty settableBeanProperty, NameTransformer nameTransformer) {
        JsonDeserializer<Object> jsonDeserializer;
        if (settableBeanProperty == null) {
            return settableBeanProperty;
        }
        String string = nameTransformer.transform(settableBeanProperty.getName());
        JsonDeserializer<Object> jsonDeserializer2 = (settableBeanProperty = settableBeanProperty.withSimpleName(string)).getValueDeserializer();
        if (jsonDeserializer2 != null && (jsonDeserializer = jsonDeserializer2.unwrappingDeserializer(nameTransformer)) != jsonDeserializer2) {
            settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
        }
        return settableBeanProperty;
    }

    protected void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonProcessingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    private final int _findIndexInHash(String string) {
        int n;
        int n2 = this._hashCode(string);
        int n3 = n2 << 1;
        if (string.equals(this._hashArea[n3])) {
            return n3 + 1;
        }
        int n4 = this._hashMask + 1;
        n3 = n4 + (n2 >> 1) << 1;
        if (string.equals(this._hashArea[n3])) {
            return n3 + 1;
        }
        int n5 = n + this._spillCount;
        for (n = n4 + (n4 >> 1) << 1; n < n5; n += 2) {
            if (!string.equals(this._hashArea[n])) continue;
            return n + 1;
        }
        return -1;
    }

    private final int _findFromOrdered(SettableBeanProperty settableBeanProperty) {
        int n = this._propsInOrder.length;
        for (int i = 0; i < n; ++i) {
            if (this._propsInOrder[i] != settableBeanProperty) continue;
            return i;
        }
        throw new IllegalStateException("Illegal state: property '" + settableBeanProperty.getName() + "' missing from _propsInOrder");
    }

    private final int _hashCode(String string) {
        return string.hashCode() & this._hashMask;
    }
}

