/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.DataFormatReaders;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final DataFormatReaders _dataFormatReaders;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig) {
        this(objectMapper, deserializationConfig, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        this._config = deserializationConfig;
        this._context = objectMapper._deserializationContext;
        this._rootDeserializers = objectMapper._rootDeserializers;
        this._parserFactory = objectMapper._jsonFactory;
        this._valueType = javaType;
        this._valueToUpdate = object;
        if (object != null && javaType.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(javaType);
        this._dataFormatReaders = null;
        this._filter = null;
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = javaType;
        this._rootDeserializer = jsonDeserializer;
        this._valueToUpdate = object;
        if (object != null && javaType.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = dataFormatReaders;
        this._filter = objectReader._filter;
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = objectReader._filter;
    }

    protected ObjectReader(ObjectReader objectReader, JsonFactory jsonFactory) {
        this._config = objectReader._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, jsonFactory.requiresPropertyOrdering());
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = jsonFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = objectReader._unwrapRoot;
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = objectReader._filter;
    }

    protected ObjectReader(ObjectReader objectReader, TokenFilter tokenFilter) {
        this._config = objectReader._config;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = objectReader._unwrapRoot;
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = tokenFilter;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectReader _new(ObjectReader objectReader, JsonFactory jsonFactory) {
        return new ObjectReader(objectReader, jsonFactory);
    }

    protected ObjectReader _new(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        return new ObjectReader(objectReader, deserializationConfig);
    }

    protected ObjectReader _new(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        return new ObjectReader(objectReader, deserializationConfig, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    protected <T> MappingIterator<T> _newIterator(JsonParser jsonParser, DeserializationContext deserializationContext, JsonDeserializer<?> jsonDeserializer, boolean bl) {
        return new MappingIterator(this._valueType, jsonParser, deserializationContext, jsonDeserializer, bl, this._valueToUpdate);
    }

    protected JsonToken _initForReading(DeserializationContext deserializationContext, JsonParser jsonParser) throws IOException {
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        this._config.initialize(jsonParser);
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            deserializationContext.reportMissingContent(null, new Object[0]);
        }
        return jsonToken;
    }

    protected void _initForMultiRead(DeserializationContext deserializationContext, JsonParser jsonParser) throws IOException {
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        this._config.initialize(jsonParser);
    }

    public ObjectReader with(DeserializationFeature deserializationFeature) {
        return this._with(this._config.with(deserializationFeature));
    }

    public ObjectReader with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.withFeatures(deserializationFeatureArray));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature) {
        return this._with(this._config.without(deserializationFeature));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.without(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.withoutFeatures(deserializationFeatureArray));
    }

    public ObjectReader with(JsonParser.Feature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader withFeatures(JsonParser.Feature ... featureArray) {
        return this._with(this._config.withFeatures(featureArray));
    }

    public ObjectReader without(JsonParser.Feature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader withoutFeatures(JsonParser.Feature ... featureArray) {
        return this._with(this._config.withoutFeatures(featureArray));
    }

    public ObjectReader with(FormatFeature formatFeature) {
        return this._with(this._config.with(formatFeature));
    }

    public ObjectReader withFeatures(FormatFeature ... formatFeatureArray) {
        return this._with(this._config.withFeatures(formatFeatureArray));
    }

    public ObjectReader without(FormatFeature formatFeature) {
        return this._with(this._config.without(formatFeature));
    }

    public ObjectReader withoutFeatures(FormatFeature ... formatFeatureArray) {
        return this._with(this._config.withoutFeatures(formatFeatureArray));
    }

    public ObjectReader at(String string) {
        return new ObjectReader(this, (TokenFilter)new JsonPointerBasedFilter(string));
    }

    public ObjectReader at(JsonPointer jsonPointer) {
        return new ObjectReader(this, (TokenFilter)new JsonPointerBasedFilter(jsonPointer));
    }

    public ObjectReader with(DeserializationConfig deserializationConfig) {
        return this._with(deserializationConfig);
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues, this._dataFormatReaders);
    }

    public ObjectReader with(JsonNodeFactory jsonNodeFactory) {
        return this._with(this._config.with(jsonNodeFactory));
    }

    public ObjectReader with(JsonFactory jsonFactory) {
        if (jsonFactory == this._parserFactory) {
            return this;
        }
        ObjectReader objectReader = this._new(this, jsonFactory);
        if (jsonFactory.getCodec() == null) {
            jsonFactory.setCodec((ObjectCodec)objectReader);
        }
        return objectReader;
    }

    public ObjectReader withRootName(String string) {
        return this._with((DeserializationConfig)this._config.withRootName(string));
    }

    public ObjectReader withRootName(PropertyName propertyName) {
        return this._with(this._config.withRootName(propertyName));
    }

    public ObjectReader withoutRootName() {
        return this._with(this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectReader with(FormatSchema formatSchema) {
        if (this._schema == formatSchema) {
            return this;
        }
        this._verifySchemaType(formatSchema);
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, formatSchema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader forType(JavaType javaType) {
        if (javaType != null && javaType.equals(this._valueType)) {
            return this;
        }
        JsonDeserializer<Object> jsonDeserializer = this._prefetchRootDeserializer(javaType);
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            dataFormatReaders = dataFormatReaders.withType(javaType);
        }
        return this._new(this, this._config, javaType, jsonDeserializer, this._valueToUpdate, this._schema, this._injectableValues, dataFormatReaders);
    }

    public ObjectReader forType(Class<?> clazz) {
        return this.forType(this._config.constructType(clazz));
    }

    public ObjectReader forType(TypeReference<?> typeReference) {
        return this.forType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectReader withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectReader withType(Class<?> clazz) {
        return this.forType(this._config.constructType(clazz));
    }

    @Deprecated
    public ObjectReader withType(Type type) {
        return this.forType(this._config.getTypeFactory().constructType(type));
    }

    @Deprecated
    public ObjectReader withType(TypeReference<?> typeReference) {
        return this.forType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectReader withValueToUpdate(Object object) {
        if (object == this._valueToUpdate) {
            return this;
        }
        if (object == null) {
            return this._new(this, this._config, this._valueType, this._rootDeserializer, null, this._schema, this._injectableValues, this._dataFormatReaders);
        }
        JavaType javaType = this._valueType == null ? this._config.constructType(object.getClass()) : this._valueType;
        return this._new(this, this._config, javaType, this._rootDeserializer, object, this._schema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader withView(Class<?> clazz) {
        return this._with((DeserializationConfig)this._config.withView((Class)clazz));
    }

    public ObjectReader with(Locale locale) {
        return this._with(this._config.with(locale));
    }

    public ObjectReader with(TimeZone timeZone) {
        return this._with(this._config.with(timeZone));
    }

    public ObjectReader withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        return this._with(this._config.withHandler(deserializationProblemHandler));
    }

    public ObjectReader with(Base64Variant base64Variant) {
        return this._with(this._config.with(base64Variant));
    }

    public ObjectReader withFormatDetection(ObjectReader ... objectReaderArray) {
        return this.withFormatDetection(new DataFormatReaders(objectReaderArray));
    }

    public ObjectReader withFormatDetection(DataFormatReaders dataFormatReaders) {
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, this._injectableValues, dataFormatReaders);
    }

    public ObjectReader with(ContextAttributes contextAttributes) {
        return this._with(this._config.with(contextAttributes));
    }

    public ObjectReader withAttributes(Map<?, ?> map) {
        return this._with((DeserializationConfig)this._config.withAttributes(map));
    }

    public ObjectReader withAttribute(Object object, Object object2) {
        return this._with((DeserializationConfig)this._config.withAttribute(object, object2));
    }

    public ObjectReader withoutAttribute(Object object) {
        return this._with((DeserializationConfig)this._config.withoutAttribute(object));
    }

    protected ObjectReader _with(DeserializationConfig deserializationConfig) {
        if (deserializationConfig == this._config) {
            return this;
        }
        ObjectReader objectReader = this._new(this, deserializationConfig);
        if (this._dataFormatReaders != null) {
            objectReader = objectReader.withFormatDetection(this._dataFormatReaders.with(deserializationConfig));
        }
        return objectReader;
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._config.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._parserFactory.isEnabled(feature);
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    public JsonFactory getFactory() {
        return this._parserFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public <T> T readValue(JsonParser jsonParser) throws IOException {
        return (T)this._bind(jsonParser, this._valueToUpdate);
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException {
        return this.forType(typeReference).readValue(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonProcessingException {
        return this.forType((JavaType)resolvedType).readValue(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException {
        return this.forType(javaType).readValue(jsonParser);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValues(jsonParser);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException {
        return this.forType(typeReference).readValues(jsonParser);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) throws IOException {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, JavaType javaType) throws IOException {
        return this.forType(javaType).readValues(jsonParser);
    }

    public JsonNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    public JsonNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    public JsonParser treeAsTokens(TreeNode treeNode) {
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException {
        return (T)this._bindAsTree(jsonParser);
    }

    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) {
        throw new UnsupportedOperationException();
    }

    public <T> T readValue(InputStream inputStream) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(inputStream), false);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(inputStream), false));
    }

    public <T> T readValue(Reader reader) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(reader), false));
    }

    public <T> T readValue(String string) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(string), false));
    }

    public <T> T readValue(byte[] byArray) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, 0, byArray.length);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(byArray), false));
    }

    public <T> T readValue(byte[] byArray, int n, int n2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, n, n2);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(byArray, n, n2), false));
    }

    public <T> T readValue(File file) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(file)), true);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(file), false));
    }

    public <T> T readValue(URL uRL) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(uRL), false));
    }

    public <T> T readValue(JsonNode jsonNode) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(jsonNode);
        }
        return (T)this._bindAndClose(this._considerFilter(this.treeAsTokens(jsonNode), false));
    }

    public <T> T readValue(DataInput dataInput) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(dataInput), false));
    }

    public JsonNode readTree(InputStream inputStream) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndCloseAsTree(inputStream);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(inputStream), false));
    }

    public JsonNode readTree(Reader reader) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(reader), false));
    }

    public JsonNode readTree(String string) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(string), false));
    }

    public JsonNode readTree(DataInput dataInput) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(dataInput), false));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser) throws IOException, JsonProcessingException {
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), false);
    }

    public <T> MappingIterator<T> readValues(InputStream inputStream) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(inputStream), false);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(inputStream), true));
    }

    public <T> MappingIterator<T> readValues(Reader reader) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        JsonParser jsonParser = this._considerFilter(this._parserFactory.createParser(reader), true);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        this._initForMultiRead(defaultDeserializationContext, jsonParser);
        jsonParser.nextToken();
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), true);
    }

    public <T> MappingIterator<T> readValues(String string) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string);
        }
        JsonParser jsonParser = this._considerFilter(this._parserFactory.createParser(string), true);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        this._initForMultiRead(defaultDeserializationContext, jsonParser);
        jsonParser.nextToken();
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), true);
    }

    public <T> MappingIterator<T> readValues(byte[] byArray, int n, int n2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(byArray, n, n2), false);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(byArray, n, n2), true));
    }

    public final <T> MappingIterator<T> readValues(byte[] byArray) throws IOException, JsonProcessingException {
        return this.readValues(byArray, 0, byArray.length);
    }

    public <T> MappingIterator<T> readValues(File file) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(file)), false);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(file), true));
    }

    public <T> MappingIterator<T> readValues(URL uRL) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(uRL), true));
    }

    public <T> MappingIterator<T> readValues(DataInput dataInput) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(dataInput), true));
    }

    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) throws JsonProcessingException {
        try {
            return this.readValue(this.treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonProcessingException {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }

    protected Object _bind(JsonParser jsonParser, Object object) throws IOException {
        Object object2;
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        JsonToken jsonToken = this._initForReading(defaultDeserializationContext, jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL) {
            object2 = object == null ? this._findRootDeserializer(defaultDeserializationContext).getNullValue(defaultDeserializationContext) : object;
        } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            object2 = object;
        } else {
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext);
            if (this._unwrapRoot) {
                object2 = this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, this._valueType, jsonDeserializer);
            } else if (object == null) {
                object2 = jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            } else {
                jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext, object);
                object2 = object;
            }
        }
        jsonParser.clearCurrentToken();
        return object2;
    }

    protected JsonParser _considerFilter(JsonParser jsonParser, boolean bl) {
        return this._filter == null || FilteringParserDelegate.class.isInstance(jsonParser) ? jsonParser : new FilteringParserDelegate(jsonParser, this._filter, false, bl);
    }

    protected Object _bindAndClose(JsonParser jsonParser) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            JsonDeserializer<Object> jsonDeserializer;
            Object object;
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser2);
            JsonToken jsonToken = this._initForReading(defaultDeserializationContext, jsonParser2);
            if (jsonToken == JsonToken.VALUE_NULL) {
                object = this._valueToUpdate == null ? this._findRootDeserializer(defaultDeserializationContext).getNullValue(defaultDeserializationContext) : this._valueToUpdate;
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object = this._valueToUpdate;
            } else {
                jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext);
                if (this._unwrapRoot) {
                    object = this._unwrapAndDeserialize(jsonParser2, defaultDeserializationContext, this._valueType, jsonDeserializer);
                } else if (this._valueToUpdate == null) {
                    object = jsonDeserializer.deserialize(jsonParser2, defaultDeserializationContext);
                } else {
                    jsonDeserializer.deserialize(jsonParser2, defaultDeserializationContext, this._valueToUpdate);
                    object = this._valueToUpdate;
                }
            }
            jsonDeserializer = object;
            return jsonDeserializer;
        }
    }

    protected JsonNode _bindAndCloseAsTree(JsonParser jsonParser) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            JsonNode jsonNode = this._bindAsTree(jsonParser2);
            return jsonNode;
        }
    }

    protected JsonNode _bindAsTree(JsonParser jsonParser) throws IOException {
        JsonNode jsonNode;
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        JsonToken jsonToken = this._initForReading(defaultDeserializationContext, jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL || jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            jsonNode = NullNode.instance;
        } else {
            JsonDeserializer<Object> jsonDeserializer = this._findTreeDeserializer(defaultDeserializationContext);
            jsonNode = this._unwrapRoot ? (JsonNode)this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, JSON_NODE_TYPE, jsonDeserializer) : (JsonNode)jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
        }
        jsonParser.clearCurrentToken();
        return jsonNode;
    }

    protected <T> MappingIterator<T> _bindAndReadValues(JsonParser jsonParser) throws IOException {
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        this._initForMultiRead(defaultDeserializationContext, jsonParser);
        jsonParser.nextToken();
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), true);
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) throws IOException {
        Object object;
        String string;
        PropertyName propertyName = this._config.findRootName(javaType);
        String string2 = propertyName.getSimpleName();
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            deserializationContext.reportWrongTokenException(jsonParser, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name '%s'), but %s", string2, jsonParser.getCurrentToken());
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            deserializationContext.reportWrongTokenException(jsonParser, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name '%s'), but %s", string2, jsonParser.getCurrentToken());
        }
        if (!string2.equals(string = jsonParser.getCurrentName())) {
            deserializationContext.reportMappingException("Root name '%s' does not match expected ('%s') for type %s", string, string2, javaType);
        }
        jsonParser.nextToken();
        if (this._valueToUpdate == null) {
            object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        } else {
            jsonDeserializer.deserialize(jsonParser, deserializationContext, this._valueToUpdate);
            object = this._valueToUpdate;
        }
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            deserializationContext.reportWrongTokenException(jsonParser, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name '%s'), but %s", string2, jsonParser.getCurrentToken());
        }
        return object;
    }

    protected Object _detectBindAndClose(byte[] byArray, int n, int n2) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(byArray, n, n2);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        return match.getReader()._bindAndClose(jsonParser);
    }

    protected Object _detectBindAndClose(DataFormatReaders.Match match, boolean bl) throws IOException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        if (bl) {
            jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndClose(jsonParser);
    }

    protected <T> MappingIterator<T> _detectBindAndReadValues(DataFormatReaders.Match match, boolean bl) throws IOException, JsonProcessingException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        if (bl) {
            jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndReadValues(jsonParser);
    }

    protected JsonNode _detectBindAndCloseAsTree(InputStream inputStream) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(inputStream);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return match.getReader()._bindAndCloseAsTree(jsonParser);
    }

    protected void _reportUnkownFormat(DataFormatReaders dataFormatReaders, DataFormatReaders.Match match) throws JsonProcessingException {
        throw new JsonParseException(null, "Can not detect format from input, does not look like any of detectable formats " + dataFormatReaders.toString());
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._parserFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._parserFactory.getFormatName());
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser) {
        return this._context.createInstance(this._config, jsonParser, this._injectableValues);
    }

    protected void _reportUndetectableSource(Object object) throws JsonProcessingException {
        throw new JsonParseException(null, "Can not use source of type " + object.getClass().getName() + " with format auto-detection: must be byte- not char-based");
    }

    protected InputStream _inputStream(URL uRL) throws IOException {
        return uRL.openStream();
    }

    protected InputStream _inputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        JavaType javaType = this._valueType;
        if (javaType == null) {
            deserializationContext.reportMappingException("No value type configured for ObjectReader", new Object[0]);
        }
        if ((jsonDeserializer = this._rootDeserializers.get(javaType)) != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            deserializationContext.reportMappingException("Can not find a deserializer for type %s", javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _findTreeDeserializer(DeserializationContext deserializationContext) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(JSON_NODE_TYPE);
        if (jsonDeserializer == null) {
            jsonDeserializer = deserializationContext.findRootValueDeserializer(JSON_NODE_TYPE);
            if (jsonDeserializer == null) {
                deserializationContext.reportMappingException("Can not find a deserializer for type %s", JSON_NODE_TYPE);
            }
            this._rootDeserializers.put(JSON_NODE_TYPE, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _prefetchRootDeserializer(JavaType javaType) {
        if (javaType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer == null) {
            try {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(null);
                jsonDeserializer = defaultDeserializationContext.findRootValueDeserializer(javaType);
                if (jsonDeserializer != null) {
                    this._rootDeserializers.put(javaType, jsonDeserializer);
                }
                return jsonDeserializer;
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return jsonDeserializer;
    }
}

