/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;

public final class Lister {
    private static final ArchiveStreamFactory factory = new ArchiveStreamFactory();

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Lister.usage();
            return;
        }
        System.out.println("Analysing " + stringArray[0]);
        File file = new File(stringArray[0]);
        if (!file.isFile()) {
            System.err.println(file + " doesn't exist or is a directory");
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
             ArchiveInputStream archiveInputStream = Lister.createArchiveInputStream(stringArray, bufferedInputStream);){
            ArchiveEntry archiveEntry;
            System.out.println("Created " + archiveInputStream.toString());
            while ((archiveEntry = archiveInputStream.getNextEntry()) != null) {
                System.out.println(archiveEntry.getName());
            }
        }
    }

    private static ArchiveInputStream createArchiveInputStream(String[] stringArray, InputStream inputStream) throws ArchiveException {
        if (stringArray.length > 1) {
            return factory.createArchiveInputStream(stringArray[1], inputStream);
        }
        return factory.createArchiveInputStream(inputStream);
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]");
    }
}

