/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.fitting;

import java.io.Serializable;
import org.spaceroots.mantissa.estimation.EstimationException;
import org.spaceroots.mantissa.fitting.AbstractCurveFitter;
import org.spaceroots.mantissa.fitting.F2FP2Iterator;
import org.spaceroots.mantissa.fitting.FFPIterator;
import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.VectorialValuedPair;
import org.spaceroots.mantissa.quadrature.vectorial.EnhancedSimpsonIntegratorSampler;

public class HarmonicCoefficientsGuesser
implements Serializable {
    private AbstractCurveFitter.FitMeasurement[] measurements;
    private double a;
    private double omega;
    private double phi;
    private static final long serialVersionUID = 2400399048702758814L;

    public HarmonicCoefficientsGuesser(AbstractCurveFitter.FitMeasurement[] measurements) {
        this.measurements = (AbstractCurveFitter.FitMeasurement[])measurements.clone();
        this.a = Double.NaN;
        this.omega = Double.NaN;
    }

    public void guess() throws ExhaustedSampleException, FunctionException, EstimationException {
        this.guessAOmega();
        this.guessPhi();
    }

    private void guessAOmega() throws ExhaustedSampleException, FunctionException, EstimationException {
        double sx2 = 0.0;
        double sy2 = 0.0;
        double sxy = 0.0;
        double sxz = 0.0;
        double syz = 0.0;
        F2FP2Iterator iter = new F2FP2Iterator(this.measurements);
        EnhancedSimpsonIntegratorSampler sampler = new EnhancedSimpsonIntegratorSampler(iter);
        VectorialValuedPair p0 = sampler.nextSamplePoint();
        double p0X = p0.x;
        double[] p0Y = p0.y;
        while (sampler.hasNext()) {
            VectorialValuedPair point = sampler.nextSamplePoint();
            double pX = point.x;
            double[] pY = point.y;
            double x = pX - p0X;
            double y = pY[0] - p0Y[0];
            double z = pY[1] - p0Y[1];
            sx2 += x * x;
            sy2 += y * y;
            sxy += x * y;
            sxz += x * z;
            syz += y * z;
        }
        double c1 = sy2 * sxz - sxy * syz;
        double c2 = sxy * sxz - sx2 * syz;
        double c3 = sx2 * sy2 - sxy * sxy;
        if (c1 / c2 < 0.0 || c2 / c3 < 0.0) {
            throw new EstimationException("unable to guess a first estimate");
        }
        this.a = Math.sqrt(c1 / c2);
        this.omega = Math.sqrt(c2 / c3);
    }

    private void guessPhi() throws ExhaustedSampleException, FunctionException {
        FFPIterator iter = new FFPIterator(this.measurements);
        double fcMean = 0.0;
        double fsMean = 0.0;
        while (iter.hasNext()) {
            VectorialValuedPair point = iter.nextSamplePoint();
            double omegaX = this.omega * point.x;
            double cosine = Math.cos(omegaX);
            double sine = Math.sin(omegaX);
            fcMean += this.omega * point.y[0] * cosine - point.y[1] * sine;
            fsMean += this.omega * point.y[0] * sine + point.y[1] * cosine;
        }
        this.phi = Math.atan2(-fsMean, fcMean);
    }

    public double getOmega() {
        return this.omega;
    }

    public double getA() {
        return this.a;
    }

    public double getPhi() {
        return this.phi;
    }
}

