/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.support.math.RunningAverage;
import freenet.support.math.TrivialRunningAverage;
import java.util.ArrayList;
import java.util.Collections;

public final class MedianMeanRunningAverage
implements RunningAverage,
Cloneable {
    private static final long serialVersionUID = 1L;
    final ArrayList<Double> reports;
    final TrivialRunningAverage mean;

    public MedianMeanRunningAverage() {
        this.reports = new ArrayList();
        this.mean = new TrivialRunningAverage();
    }

    public MedianMeanRunningAverage(MedianMeanRunningAverage average) {
        this.mean = new TrivialRunningAverage(average.mean);
        this.reports = new ArrayList();
        this.reports.addAll(average.reports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MedianMeanRunningAverage clone() {
        MedianMeanRunningAverage medianMeanRunningAverage = this;
        synchronized (medianMeanRunningAverage) {
            return new MedianMeanRunningAverage(this);
        }
    }

    @Override
    public synchronized long countReports() {
        return this.reports.size();
    }

    @Override
    public synchronized double currentValue() {
        int size = this.reports.size();
        int middle = size / 2;
        Collections.sort(this.reports);
        return this.reports.get(middle);
    }

    @Override
    public synchronized void report(double d) {
        this.mean.report(d);
        this.reports.add(d);
    }

    @Override
    public void report(long d) {
        this.report((double)d);
    }

    @Override
    public double valueIfReported(double r) {
        throw new UnsupportedOperationException();
    }

    public synchronized String toString() {
        return "Median " + this.currentValue() + " mean " + this.mean.currentValue();
    }

    public synchronized double meanValue() {
        return this.mean.currentValue();
    }
}

