/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.api.Bucket;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ByteArrayRandomAccessBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class ArrayBucket
implements Bucket,
Serializable,
RandomAccessBucket {
    private static final long serialVersionUID = 1L;
    private volatile byte[] data = new byte[0];
    private String name;
    private boolean readOnly;
    private boolean freed;

    public ArrayBucket() {
        this("ArrayBucket");
    }

    public ArrayBucket(byte[] initdata) {
        this("ArrayBucket");
        this.data = initdata;
    }

    public ArrayBucket(String name) {
        this.name = name;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.readOnly) {
            throw new IOException("Read only");
        }
        if (this.freed) {
            throw new IOException("Already freed");
        }
        return new ArrayBucketOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        return new ByteArrayInputStream(this.data);
    }

    public String toString() {
        return new String(this.data);
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public void free() {
        this.freed = true;
        this.data = null;
    }

    public byte[] toByteArray() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        long sz = this.size();
        int size = (int)sz;
        return Arrays.copyOf(this.data, size);
    }

    @Override
    public RandomAccessBucket createShadow() {
        return null;
    }

    @Override
    public void onResume(ClientContext context) {
    }

    @Override
    public void storeTo(DataOutputStream dos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() {
        this.readOnly = true;
        ByteArrayRandomAccessBuffer raf = new ByteArrayRandomAccessBuffer(this.data, 0, this.data.length, true);
        return raf;
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        return this.getInputStream();
    }

    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        return this.getOutputStream();
    }

    static /* synthetic */ byte[] access$002(ArrayBucket x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    private class ArrayBucketOutputStream
    extends ByteArrayOutputStream {
        private boolean hasBeenClosed = false;

        @Override
        public synchronized void close() throws IOException {
            if (this.hasBeenClosed) {
                return;
            }
            ArrayBucket.access$002(ArrayBucket.this, super.toByteArray());
            if (ArrayBucket.this.readOnly) {
                throw new IOException("Read only");
            }
            this.hasBeenClosed = true;
        }
    }
}

