/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.support.ShortBuffer;
import java.util.concurrent.TimeUnit;

public class BulkReceiver {
    static final long TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    final PartiallyReceivedBulk prb;
    final PeerContext peer;
    final long uid;
    private boolean sentCancel;
    final long peerBootID;
    private final ByteCounter ctr;

    public BulkReceiver(PartiallyReceivedBulk prb, PeerContext peer, long uid, ByteCounter ctr) {
        this.prb = prb;
        this.peer = peer;
        this.uid = uid;
        this.peerBootID = peer.getBootID();
        this.ctr = ctr;
        prb.recv = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAborted() {
        BulkReceiver bulkReceiver = this;
        synchronized (bulkReceiver) {
            if (this.sentCancel) {
                return;
            }
            this.sentCancel = true;
        }
        try {
            this.peer.sendAsync(DMT.createFNPBulkReceiveAborted(this.uid), null, this.ctr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    public boolean receive() {
        while (true) {
            Message m;
            MessageFilter mfSendKilled = MessageFilter.create().setSource(this.peer).setType(DMT.FNPBulkSendAborted).setField("uid", this.uid).setTimeout(TIMEOUT);
            MessageFilter mfPacket = MessageFilter.create().setSource(this.peer).setType(DMT.FNPBulkPacketSend).setField("uid", this.uid).setTimeout(TIMEOUT);
            if (this.prb.hasWholeFile()) {
                try {
                    this.peer.sendAsync(DMT.createFNPBulkReceivedAll(this.uid), null, this.ctr);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                return true;
            }
            try {
                m = this.prb.usm.waitFor(mfSendKilled.or(mfPacket), this.ctr);
            }
            catch (DisconnectedException e) {
                this.prb.abort(7, "Sender disconnected");
                return false;
            }
            if (this.peer.getBootID() != this.peerBootID) {
                this.prb.abort(5, "Sender restarted");
                return false;
            }
            if (m == null) {
                this.prb.abort(4, "Sender timeout");
                return false;
            }
            if (m.getSpec() == DMT.FNPBulkSendAborted) {
                this.prb.abort(5, "Sender cancelled send");
                return false;
            }
            if (m.getSpec() != DMT.FNPBulkPacketSend) continue;
            int packetNo = m.getInt("packetNo");
            byte[] data = ((ShortBuffer)m.getObject("data")).getData();
            this.prb.received(packetNo, data, 0, data.length);
        }
    }
}

