/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressIdentifier;
import freenet.io.AddressMatcher;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Inet6AddressMatcher
implements AddressMatcher {
    private static final byte[] FULL_MASK = new byte[16];
    private byte[] address;
    private byte[] netmask;

    public AddressIdentifier.AddressType getAddressType() {
        return AddressIdentifier.AddressType.IPv6;
    }

    public Inet6AddressMatcher(String pattern) {
        if (pattern.indexOf(47) != -1) {
            this.address = this.convertToBytes(pattern.substring(0, pattern.indexOf(47)));
            String netmaskString = pattern.substring(pattern.indexOf(47) + 1).trim();
            if (netmaskString.indexOf(58) != -1) {
                this.netmask = this.convertToBytes(netmaskString);
            } else {
                this.netmask = new byte[16];
                int bits = Integer.parseInt(netmaskString);
                if (bits > 128 || bits < 0) {
                    throw new IllegalArgumentException("Mask bits out of range: " + bits + " (" + netmaskString + ")");
                }
                for (int index = 0; index < 16; ++index) {
                    this.netmask[index] = (byte)(255 << 8 - Math.min(bits, 8));
                    bits = Math.max(bits - 8, 0);
                }
            }
            if (Arrays.equals(this.netmask, FULL_MASK)) {
                this.netmask = FULL_MASK;
            }
        } else {
            this.address = this.convertToBytes(pattern);
            this.netmask = FULL_MASK;
        }
        if (this.address.length != 16) {
            throw new IllegalArgumentException("address is not IPv6");
        }
    }

    private byte[] convertToBytes(String address) {
        StringTokenizer addressTokens = new StringTokenizer(address, ":");
        if (addressTokens.countTokens() != 8) {
            throw new IllegalArgumentException(address + " is not an IPv6 address.");
        }
        byte[] addressBytes = new byte[16];
        int count = 0;
        while (addressTokens.hasMoreTokens()) {
            int addressWord = Integer.parseInt(addressTokens.nextToken(), 16);
            addressBytes[count * 2] = (byte)(addressWord >> 8 & 0xFF);
            addressBytes[count * 2 + 1] = (byte)(addressWord & 0xFF);
            ++count;
        }
        return addressBytes;
    }

    @Override
    public boolean matches(InetAddress address) {
        if (!(address instanceof Inet6Address)) {
            return false;
        }
        byte[] addressBytes = address.getAddress();
        for (int index = 0; index < 16; ++index) {
            if ((addressBytes[index] & this.netmask[index]) == (this.address[index] & this.netmask[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(String pattern, InetAddress address) {
        return new Inet6AddressMatcher(pattern).matches(address);
    }

    @Override
    public String getHumanRepresentation() {
        if (this.netmask == FULL_MASK) {
            return this.convertToString(this.address);
        }
        return this.convertToString(this.address) + '/' + this.convertToString(this.netmask);
    }

    private String convertToString(byte[] addr) {
        StringBuilder sb = new StringBuilder(39);
        for (int i = 0; i < 8; ++i) {
            if (i != 0) {
                sb.append(':');
            }
            int token = ((addr[i * 2] & 0xFF) << 8) + (addr[i * 2 + 1] & 0xFF);
            sb.append(Integer.toHexString(token));
        }
        return sb.toString();
    }

    static {
        Arrays.fill(FULL_MASK, (byte)-1);
    }
}

