/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.KeyType;
import java.io.Serializable;

public enum CryptByteBufferType implements Serializable
{
    RijndaelECB(1, KeyType.Rijndael256),
    RijndaelECB128(2, KeyType.Rijndael256, 128),
    RijndaelPCFB(8, 32, KeyType.Rijndael256),
    AESCTR(16, 16, "AES/CTR/NOPADDING", KeyType.AES256),
    ChaCha128(32, 8, "CHACHA", KeyType.ChaCha128),
    ChaCha256(64, 8, "CHACHA", KeyType.ChaCha256);

    public final int bitmask;
    public final int blockSize;
    public final Integer ivSize;
    public final String algName;
    public final String cipherName;
    public final KeyType keyType;
    public final boolean isStreamCipher;

    private CryptByteBufferType(int bitmask, KeyType keyType) {
        this.bitmask = bitmask;
        this.keyType = keyType;
        this.cipherName = keyType.alg;
        this.blockSize = keyType.keySize;
        this.ivSize = null;
        this.algName = this.name();
        this.isStreamCipher = false;
    }

    private CryptByteBufferType(int bitmask, KeyType keyType, int blockSize) {
        this.bitmask = bitmask;
        this.ivSize = null;
        this.keyType = keyType;
        this.cipherName = keyType.alg;
        this.blockSize = blockSize;
        this.algName = this.name();
        this.isStreamCipher = false;
    }

    private CryptByteBufferType(int bitmask, int ivSize, KeyType keyType) {
        this.bitmask = bitmask;
        this.keyType = keyType;
        this.cipherName = keyType.alg;
        this.blockSize = keyType.keySize;
        this.ivSize = ivSize;
        this.algName = this.name();
        this.isStreamCipher = true;
    }

    private CryptByteBufferType(int bitmask, int ivSize, String algName, KeyType keyType) {
        this.bitmask = bitmask;
        this.ivSize = ivSize;
        this.cipherName = keyType.alg;
        this.blockSize = keyType.keySize;
        this.algName = algName;
        this.keyType = keyType;
        this.isStreamCipher = true;
    }

    public boolean hasIV() {
        return this.ivSize != null;
    }
}

