/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.DirPutFile;
import freenet.clients.fcp.MessageInvalidException;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.NullBucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DirectDirPutFile
extends DirPutFile {
    private final RandomAccessBucket data;
    private final long length;

    public static DirectDirPutFile create(String name, String contentTypeOverride, SimpleFieldSet subset, String identifier, boolean global, BucketFactory bf) throws MessageInvalidException {
        RandomAccessBucket data;
        long length;
        String s = subset.get("DataLength");
        if (s == null) {
            throw new MessageInvalidException(5, "UploadFrom=direct requires a DataLength for " + name, identifier, global);
        }
        try {
            length = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new MessageInvalidException(6, "Could not parse DataLength: " + e.toString(), identifier, global);
        }
        try {
            data = length == 0L ? new NullBucket() : bf.makeBucket(length);
        }
        catch (IOException e) {
            throw new MessageInvalidException(17, "Internal error: could not allocate temp bucket: " + e.toString(), identifier, global);
        }
        String mimeType = contentTypeOverride == null ? DirPutFile.guessMIME(name) : contentTypeOverride;
        return new DirectDirPutFile(name, mimeType, length, data);
    }

    private DirectDirPutFile(String name, String mimeType, long length, RandomAccessBucket data) {
        super(name, mimeType);
        this.length = length;
        this.data = data;
    }

    public long bytesToRead() {
        return this.length;
    }

    public void read(InputStream is) throws IOException {
        BucketTools.copyFrom(this.data, is, this.length);
    }

    public void write(OutputStream os) throws IOException {
        BucketTools.copyTo(this.data, os, this.length);
    }

    @Override
    public RandomAccessBucket getData() {
        return this.data;
    }
}

