/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJobRunner;
import freenet.client.async.SplitFileInserterSegmentStorage;
import freenet.client.async.SplitFileInserterStorage;
import freenet.crypt.ChecksumFailedException;
import freenet.keys.ClientCHK;
import freenet.support.Logger;
import freenet.support.MemoryLimitedChunk;
import freenet.support.MemoryLimitedJob;
import freenet.support.MemoryLimitedJobRunner;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.CountedOutputStream;
import freenet.support.io.NullOutputStream;
import freenet.support.io.StorageFormatException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SplitFileInserterCrossSegmentStorage {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final SplitFileInserterStorage parent;
    final int segNo;
    final int dataBlockCount;
    final int crossCheckBlockCount;
    final int totalBlocks;
    private boolean encoded;
    private boolean encoding;
    private boolean cancelled;
    private final SplitFileInserterSegmentStorage[] segments;
    private final int[] blockNumbers;
    private transient int counter;
    private final int statusLength;
    static final boolean DEBUG_ENCODE = true;

    public SplitFileInserterCrossSegmentStorage(SplitFileInserterStorage parent, int segNo, boolean persistent, int segLen, int crossCheckBlocks) {
        this.parent = parent;
        this.segNo = segNo;
        this.dataBlockCount = segLen;
        this.crossCheckBlockCount = crossCheckBlocks;
        this.totalBlocks = this.dataBlockCount + crossCheckBlocks;
        this.segments = new SplitFileInserterSegmentStorage[this.totalBlocks];
        this.blockNumbers = new int[this.totalBlocks];
        try {
            CountedOutputStream cos = new CountedOutputStream(new NullOutputStream());
            DataOutputStream dos = new DataOutputStream(cos);
            this.innerStoreStatus(dos);
            dos.close();
            this.statusLength = (int)cos.written() + parent.checker.checksumLength();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    void addBlock(SplitFileInserterSegmentStorage seg, int blockNum) {
        this.segments[this.counter] = seg;
        this.blockNumbers[this.counter] = blockNum;
        if (logMINOR) {
            Logger.minor(this, "Allocated cross-segment block " + this.counter + " to block " + blockNum + " on " + seg + " for " + this);
        }
        ++this.counter;
    }

    void addDataBlock(SplitFileInserterSegmentStorage seg, int blockNum) {
        assert (this.counter < this.dataBlockCount);
        assert (blockNum < seg.dataBlockCount);
        this.addBlock(seg, blockNum);
    }

    void addCheckBlock(SplitFileInserterSegmentStorage seg, int blockNum) {
        assert (this.counter >= this.dataBlockCount);
        assert (blockNum >= seg.dataBlockCount && blockNum < seg.dataBlockCount + seg.crossCheckBlockCount);
        this.addBlock(seg, blockNum);
    }

    public void writeFixedSettings(DataOutputStream dos) throws IOException {
        dos.writeInt(this.dataBlockCount);
        dos.writeInt(this.crossCheckBlockCount);
        for (int i = 0; i < this.totalBlocks; ++i) {
            dos.writeInt(this.segments[i].segNo);
            dos.writeInt(this.blockNumbers[i]);
        }
        dos.writeInt(this.statusLength);
    }

    SplitFileInserterCrossSegmentStorage(SplitFileInserterStorage parent, DataInputStream dis, int segNo) throws StorageFormatException, IOException {
        int i;
        this.segNo = segNo;
        this.parent = parent;
        this.dataBlockCount = dis.readInt();
        if (this.dataBlockCount <= 0) {
            throw new StorageFormatException("Negative cross-segment data block count");
        }
        this.crossCheckBlockCount = dis.readInt();
        if (this.crossCheckBlockCount <= 0) {
            throw new StorageFormatException("Negative cross-check block count");
        }
        this.totalBlocks = this.dataBlockCount + this.crossCheckBlockCount;
        if (this.totalBlocks > 256) {
            throw new StorageFormatException("Bogus total block count");
        }
        this.segments = new SplitFileInserterSegmentStorage[this.totalBlocks];
        this.blockNumbers = new int[this.totalBlocks];
        for (i = 0; i < this.totalBlocks; ++i) {
            int readSegmentNumber = dis.readInt();
            if (readSegmentNumber < 0 || readSegmentNumber >= parent.segments.length) {
                throw new StorageFormatException("Bogus segment number " + readSegmentNumber);
            }
            int readBlockNumber = dis.readInt();
            SplitFileInserterSegmentStorage segment = parent.segments[readSegmentNumber];
            if (readBlockNumber < 0 || readBlockNumber >= segment.dataBlockCount + segment.crossCheckBlockCount || i < this.dataBlockCount && readBlockNumber >= segment.dataBlockCount || i >= this.dataBlockCount && readBlockNumber < segment.dataBlockCount) {
                throw new StorageFormatException("Bogus block number " + readBlockNumber + " for slot " + i);
            }
            this.segments[i] = segment;
            this.blockNumbers[i] = readBlockNumber;
        }
        for (i = 0; i < this.crossCheckBlockCount; ++i) {
            this.segments[i + this.dataBlockCount].setCrossCheckBlock(this, this.blockNumbers[i + this.dataBlockCount], i + this.dataBlockCount);
        }
        this.statusLength = dis.readInt();
        if (this.statusLength < 0) {
            throw new StorageFormatException("Bogus status length");
        }
        try {
            CountedOutputStream cos = new CountedOutputStream(new NullOutputStream());
            DataOutputStream dos = new DataOutputStream(cos);
            this.innerStoreStatus(dos);
            dos.close();
            int computedStatusLength = (int)cos.written() + parent.checker.checksumLength();
            if (computedStatusLength > this.statusLength) {
                throw new StorageFormatException("Stored status length smaller than required");
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public synchronized void startEncode(final short prio) {
        if (this.encoded) {
            return;
        }
        if (this.cancelled) {
            return;
        }
        if (this.encoding) {
            return;
        }
        this.encoding = true;
        long limit = (long)(this.totalBlocks * 32768) + Math.max(this.parent.codec.maxMemoryOverheadDecode(this.dataBlockCount, this.crossCheckBlockCount), this.parent.codec.maxMemoryOverheadEncode(this.dataBlockCount, this.crossCheckBlockCount));
        this.parent.memoryLimitedJobRunner.queueJob(new MemoryLimitedJob(limit){

            @Override
            public int getPriority() {
                return prio;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean start(MemoryLimitedChunk chunk) {
                boolean shutdown = false;
                PersistentJobRunner.CheckpointLock lock = null;
                try {
                    lock = SplitFileInserterCrossSegmentStorage.this.parent.jobRunner.lock();
                    SplitFileInserterCrossSegmentStorage.this.innerEncode(chunk);
                }
                catch (PersistenceDisabledException e) {
                    shutdown = true;
                }
                finally {
                    block23: {
                        chunk.release();
                        try {
                            if (shutdown) break block23;
                            SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage = SplitFileInserterCrossSegmentStorage.this;
                            synchronized (splitFileInserterCrossSegmentStorage) {
                                SplitFileInserterCrossSegmentStorage.this.encoding = false;
                            }
                            SplitFileInserterCrossSegmentStorage.this.parent.onFinishedEncoding(SplitFileInserterCrossSegmentStorage.this);
                        }
                        finally {
                            if (lock != null) {
                                lock.unlock(false, MemoryLimitedJobRunner.THREAD_PRIORITY);
                            }
                        }
                    }
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerEncode(MemoryLimitedChunk chunk) {
        try {
            SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage = this;
            synchronized (splitFileInserterCrossSegmentStorage) {
                if (this.cancelled) {
                    return;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Encoding " + this);
            }
            byte[][] dataBlocks = this.readDataBlocks();
            byte[][] checkBlocks = new byte[this.crossCheckBlockCount][];
            for (int i = 0; i < checkBlocks.length; ++i) {
                checkBlocks[i] = new byte[32768];
            }
            if (dataBlocks == null || checkBlocks == null) {
                return;
            }
            this.parent.codec.encode(dataBlocks, checkBlocks, new boolean[checkBlocks.length], 32768);
            this.writeCheckBlocks(checkBlocks);
            SplitFileInserterCrossSegmentStorage splitFileInserterCrossSegmentStorage2 = this;
            synchronized (splitFileInserterCrossSegmentStorage2) {
                this.encoded = true;
            }
            if (logMINOR) {
                Logger.minor(this, "Finished encoding " + this);
            }
            this.storeStatus();
        }
        catch (IOException e) {
            this.parent.failOnDiskError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCheckBlocks(byte[][] checkBlocks) throws IOException {
        LockableRandomAccessBuffer.RAFLock lock = this.parent.lockRAF();
        try {
            for (int i = 0; i < checkBlocks.length; ++i) {
                this.writeCheckBlock(i, checkBlocks[i]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void writeCheckBlock(int checkBlockNo, byte[] buf) throws IOException {
        this.parent.writeCheckBlock(this.segNo, checkBlockNo, buf);
        SplitFileInserterSegmentStorage segment = this.segments[checkBlockNo + this.dataBlockCount];
        ClientCHK key = segment.encodeBlock(buf).getClientKey();
        segment.setKey(this.blockNumbers[checkBlockNo + this.dataBlockCount], key);
    }

    byte[] readCheckBlock(int slotNumberWithinCrossSegment, int segmentNumber, int blockNoWithinSegment) throws IOException {
        assert (this.blockNumbers[slotNumberWithinCrossSegment] == blockNoWithinSegment);
        assert (this.segments[slotNumberWithinCrossSegment].segNo == segmentNumber);
        return this.parent.readCheckBlock(this.segNo, slotNumberWithinCrossSegment - this.dataBlockCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] readDataBlocks() throws IOException {
        LockableRandomAccessBuffer.RAFLock lock = this.parent.lockUnderlying();
        try {
            byte[][] data = new byte[this.dataBlockCount][];
            for (int i = 0; i < this.dataBlockCount; ++i) {
                data[i] = this.segments[i].readDataBlock(this.blockNumbers[i]);
                ClientCHK key = this.segments[i].encodeBlock(data[i]).getClientKey();
                this.segments[i].setKey(this.blockNumbers[i], key);
            }
            byte[][] byArrayArray = data;
            return byArrayArray;
        }
        finally {
            lock.unlock();
        }
    }

    public synchronized boolean isFinishedEncoding() {
        return this.encoded;
    }

    public int getAllocatedCrossCheckBlocks() {
        return this.counter;
    }

    public long storedStatusLength() {
        return this.statusLength;
    }

    public void storeStatus() {
        DataOutputStream dos;
        if (!this.parent.persistent) {
            return;
        }
        try {
            dos = new DataOutputStream(this.parent.writeChecksummedTo(this.parent.crossSegmentStatusOffset(this.segNo), this.statusLength));
            this.innerStoreStatus(dos);
        }
        catch (IOException e) {
            Logger.error(this, "Impossible: " + e, (Throwable)e);
            return;
        }
        try {
            dos.close();
        }
        catch (IOException e) {
            Logger.error(this, "I/O error writing segment status?: " + e, (Throwable)e);
            this.parent.failOnDiskError(e);
        }
    }

    private void innerStoreStatus(DataOutputStream dos) throws IOException {
        dos.writeInt(this.segNo);
        dos.writeBoolean(this.encoded);
    }

    void readStatus() throws IOException, ChecksumFailedException, StorageFormatException {
        byte[] data = new byte[this.statusLength - this.parent.checker.checksumLength()];
        this.parent.preadChecksummed(this.parent.crossSegmentStatusOffset(this.segNo), data, 0, data.length);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        if (dis.readInt() != this.segNo) {
            throw new StorageFormatException("Bad segment number");
        }
        this.encoded = dis.readBoolean();
    }

    int[] getSegmentNumbers() {
        int[] ret = new int[this.totalBlocks];
        for (int i = 0; i < this.totalBlocks; ++i) {
            ret[i] = this.segments[i].segNo;
        }
        return ret;
    }

    int[] getBlockNumbers() {
        return (int[])this.blockNumbers.clone();
    }

    public synchronized boolean cancel() {
        this.cancelled = true;
        return !this.encoding;
    }

    public synchronized boolean hasCompletedOrFailed() {
        if (this.encoding) {
            return false;
        }
        return this.encoded || this.cancelled;
    }

    synchronized boolean isEncoding() {
        return this.encoding;
    }

    synchronized boolean hasEncodedSuccessfully() {
        return this.encoded;
    }

    static {
        Logger.registerClass(SplitFileInserterCrossSegmentStorage.class);
    }
}

