/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import com.onionnetworks.fec.PureCode;
import com.onionnetworks.util.Buffer;
import freenet.client.FECCodec;
import freenet.client.InsertContext;
import freenet.support.LRUMap;
import java.lang.ref.SoftReference;

public class OnionFECCodec
extends FECCodec {
    private static final LRUMap<CodecKey, SoftReference<PureCode>> recentlyUsedCodecs = LRUMap.createSafeMap();

    @Override
    public void decode(byte[][] dataBlocks, byte[][] checkBlocks, boolean[] dataBlocksPresent, boolean[] checkBlocksPresent, int blockLength) {
        int k = dataBlocks.length;
        int n = dataBlocks.length + checkBlocks.length;
        PureCode codec = OnionFECCodec.getCodec(k, n);
        int[] blockNumbers = new int[k];
        Buffer[] buffers = new Buffer[k];
        for (int i = 0; i < dataBlocks.length; ++i) {
            if (dataBlocks[i].length != blockLength) {
                throw new IllegalArgumentException();
            }
            if (!dataBlocksPresent[i]) continue;
            buffers[i] = new Buffer(dataBlocks[i], 0, blockLength);
            blockNumbers[i] = i;
        }
        int target = 0;
        for (int i = 0; i < checkBlocks.length; ++i) {
            if (!checkBlocksPresent[i]) continue;
            if (checkBlocks[i].length != blockLength) {
                throw new IllegalArgumentException();
            }
            while (target < dataBlocks.length && buffers[target] != null) {
                ++target;
            }
            if (target >= dataBlocks.length) continue;
            buffers[target] = new Buffer(dataBlocks[target]);
            blockNumbers[target] = i + dataBlocks.length;
            System.arraycopy(checkBlocks[i], 0, dataBlocks[target], 0, blockLength);
        }
        codec.decode(buffers, blockNumbers);
    }

    private static synchronized PureCode getCodec(int k, int n) {
        PureCode code;
        SoftReference<PureCode> codeRef;
        CodecKey key = new CodecKey(k, n);
        while ((codeRef = recentlyUsedCodecs.peekValue()) != null && codeRef.get() == null) {
            recentlyUsedCodecs.popKey();
        }
        codeRef = recentlyUsedCodecs.get(key);
        if (codeRef != null && (code = codeRef.get()) != null) {
            recentlyUsedCodecs.push(key, codeRef);
            return code;
        }
        code = new PureCode(k, n);
        recentlyUsedCodecs.push(key, new SoftReference<PureCode>(code));
        return code;
    }

    @Override
    public void encode(byte[][] dataBlocks, byte[][] checkBlocks, boolean[] checkBlocksPresent, int blockLength) {
        int k = dataBlocks.length;
        int n = dataBlocks.length + checkBlocks.length;
        PureCode codec = OnionFECCodec.getCodec(k, n);
        Buffer[] data = new Buffer[dataBlocks.length];
        for (int i = 0; i < data.length; ++i) {
            if (dataBlocks[i] == null || dataBlocks[i].length != blockLength) {
                throw new IllegalArgumentException();
            }
            data[i] = new Buffer(dataBlocks[i]);
        }
        int mustEncode = 0;
        for (int i = 0; i < checkBlocks.length; ++i) {
            if (checkBlocks[i] == null || checkBlocks[i].length != blockLength) {
                throw new IllegalArgumentException();
            }
            if (checkBlocksPresent[i]) continue;
            ++mustEncode;
        }
        Buffer[] check = new Buffer[mustEncode];
        if (mustEncode == 0) {
            return;
        }
        int[] toEncode = new int[mustEncode];
        int x = 0;
        for (int i = 0; i < checkBlocks.length; ++i) {
            if (checkBlocksPresent[i]) continue;
            check[x] = new Buffer(checkBlocks[i]);
            toEncode[x++] = i + dataBlocks.length;
        }
        codec.encode(data, check, toEncode);
    }

    @Override
    public long maxMemoryOverheadDecode(int dataBlocks, int checkBlocks) {
        int n = dataBlocks + checkBlocks;
        int k = dataBlocks;
        int matrixSize = n * k * 2;
        return matrixSize * 3;
    }

    @Override
    public long maxMemoryOverheadEncode(int dataBlocks, int checkBlocks) {
        int n = dataBlocks + checkBlocks;
        int k = dataBlocks;
        int matrixSize = n * k * 2;
        return matrixSize * 3;
    }

    @Override
    public int getCheckBlocks(int dataBlocks, InsertContext.CompatibilityMode compatibilityMode) {
        int checkBlocks = dataBlocks * 128 / 128;
        if (dataBlocks >= 128) {
            checkBlocks = 128;
        }
        if (dataBlocks < 256 && dataBlocks + ++checkBlocks > 256) {
            checkBlocks = 256 - dataBlocks;
        }
        if ((compatibilityMode == InsertContext.CompatibilityMode.COMPAT_1250 || compatibilityMode == InsertContext.CompatibilityMode.COMPAT_1250_EXACT) && checkBlocks > dataBlocks) {
            checkBlocks = dataBlocks;
        }
        return checkBlocks;
    }

    private static class CodecKey
    implements Comparable<CodecKey> {
        int k;
        int n;

        public CodecKey(int k, int n) {
            this.n = n;
            this.k = k;
        }

        public boolean equals(Object o) {
            if (o instanceof CodecKey) {
                CodecKey key = (CodecKey)o;
                return key.n == this.n && key.k == this.k;
            }
            return false;
        }

        public int hashCode() {
            return (this.n << 16) + this.k;
        }

        @Override
        public int compareTo(CodecKey o) {
            if (this.n > o.n) {
                return 1;
            }
            if (this.n < o.n) {
                return -1;
            }
            if (this.k > o.k) {
                return 1;
            }
            if (this.k < o.k) {
                return -1;
            }
            return 0;
        }
    }
}

