/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.MetadataParseException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ClientMetadata
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String mimeType;
    private static int VERSION = 1;
    private static int MAGIC = 558112744;

    public ClientMetadata() {
        this.mimeType = null;
    }

    public ClientMetadata(String mime) {
        this.mimeType = mime == null ? null : mime.intern();
    }

    private ClientMetadata(DataInputStream dis) throws MetadataParseException, IOException {
        int magic = dis.readInt();
        if (magic != MAGIC) {
            throw new MetadataParseException("Bad magic value in ClientMetadata");
        }
        short version = dis.readShort();
        if (version != VERSION) {
            throw new MetadataParseException("Unrecognised version " + version + " in ClientMetadata");
        }
        boolean hasMIMEType = dis.readBoolean();
        this.mimeType = hasMIMEType ? dis.readUTF() : null;
    }

    public static ClientMetadata construct(DataInputStream dis) throws MetadataParseException, IOException {
        return new ClientMetadata(dis);
    }

    public String getMIMEType() {
        if (this.mimeType == null || this.mimeType.length() == 0) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    public void mergeNoOverwrite(ClientMetadata clientMetadata) {
        if (this.mimeType == null || this.mimeType.equals("")) {
            this.mimeType = clientMetadata.mimeType;
        }
    }

    public boolean isTrivial() {
        return this.mimeType == null || this.mimeType.equals("");
    }

    public ClientMetadata clone() {
        try {
            return (ClientMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        return this.getMIMEType();
    }

    public void clear() {
        this.mimeType = null;
    }

    public String getMIMETypeNoParams() {
        String s = this.mimeType;
        if (s == null) {
            return null;
        }
        int i = s.indexOf(59);
        if (i > -1) {
            s = s.substring(i);
        }
        return s;
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(MAGIC);
        dos.writeShort(VERSION);
        if (this.mimeType == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.mimeType);
        }
    }
}

