/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CodespaceRange;
import org.apache.fontbox.util.Charsets;

public class CMapParser {
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private final byte[] tokenParserByteBuffer = new byte[512];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMap parse(File file) throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            CMap cMap = this.parse(fileInputStream);
            return cMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMap parsePredefined(String string) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = this.getExternalCMap(string);
            CMap cMap = this.parse(inputStream);
            return cMap;
        }
    }

    public CMap parse(InputStream inputStream) throws IOException {
        Object object;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        CMap cMap = new CMap();
        Object object2 = null;
        while ((object = this.parseNextToken(pushbackInputStream)) != null) {
            if (object instanceof Operator) {
                Operator operator = (Operator)object;
                if (operator.op.equals("usecmap")) {
                    this.parseUsecmap((LiteralName)object2, cMap);
                } else {
                    if (operator.op.equals("endcmap")) break;
                    if (operator.op.equals("begincodespacerange")) {
                        this.parseBegincodespacerange((Number)object2, pushbackInputStream, cMap);
                    } else if (operator.op.equals("beginbfchar")) {
                        this.parseBeginbfchar((Number)object2, pushbackInputStream, cMap);
                    } else if (operator.op.equals("beginbfrange")) {
                        this.parseBeginbfrange((Number)object2, pushbackInputStream, cMap);
                    } else if (operator.op.equals("begincidchar")) {
                        this.parseBegincidchar((Number)object2, pushbackInputStream, cMap);
                    } else if (operator.op.equals("begincidrange")) {
                        this.parseBegincidrange((Integer)object2, pushbackInputStream, cMap);
                    }
                }
            } else if (object instanceof LiteralName) {
                this.parseLiteralName((LiteralName)object, pushbackInputStream, cMap);
            }
            object2 = object;
        }
        return cMap;
    }

    private void parseUsecmap(LiteralName literalName, CMap cMap) throws IOException {
        InputStream inputStream = this.getExternalCMap(literalName.name);
        CMap cMap2 = this.parse(inputStream);
        cMap.useCmap(cMap2);
    }

    private void parseLiteralName(LiteralName literalName, PushbackInputStream pushbackInputStream, CMap cMap) throws IOException {
        Object object;
        if ("WMode".equals(literalName.name)) {
            Object object2 = this.parseNextToken(pushbackInputStream);
            if (object2 instanceof Integer) {
                cMap.setWMode((Integer)object2);
            }
        } else if ("CMapName".equals(literalName.name)) {
            Object object3 = this.parseNextToken(pushbackInputStream);
            if (object3 instanceof LiteralName) {
                cMap.setName(((LiteralName)object3).name);
            }
        } else if ("CMapVersion".equals(literalName.name)) {
            Object object4 = this.parseNextToken(pushbackInputStream);
            if (object4 instanceof Number) {
                cMap.setVersion(object4.toString());
            } else if (object4 instanceof String) {
                cMap.setVersion((String)object4);
            }
        } else if ("CMapType".equals(literalName.name)) {
            Object object5 = this.parseNextToken(pushbackInputStream);
            if (object5 instanceof Integer) {
                cMap.setType((Integer)object5);
            }
        } else if ("Registry".equals(literalName.name)) {
            Object object6 = this.parseNextToken(pushbackInputStream);
            if (object6 instanceof String) {
                cMap.setRegistry((String)object6);
            }
        } else if ("Ordering".equals(literalName.name)) {
            Object object7 = this.parseNextToken(pushbackInputStream);
            if (object7 instanceof String) {
                cMap.setOrdering((String)object7);
            }
        } else if ("Supplement".equals(literalName.name) && (object = this.parseNextToken(pushbackInputStream)) instanceof Integer) {
            cMap.setSupplement((Integer)object);
        }
    }

    private void parseBegincodespacerange(Number number, PushbackInputStream pushbackInputStream, CMap cMap) throws IOException {
        for (int i = 0; i < number.intValue(); ++i) {
            Object object = this.parseNextToken(pushbackInputStream);
            if (object instanceof Operator) {
                if (((Operator)object).op.equals("endcodespacerange")) break;
                throw new IOException("Error : ~codespacerange contains an unexpected operator : " + ((Operator)object).op);
            }
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])this.parseNextToken(pushbackInputStream);
            CodespaceRange codespaceRange = new CodespaceRange();
            codespaceRange.setStart(byArray);
            codespaceRange.setEnd(byArray2);
            cMap.addCodespaceRange(codespaceRange);
        }
    }

    private void parseBeginbfchar(Number number, PushbackInputStream pushbackInputStream, CMap cMap) throws IOException {
        for (int i = 0; i < number.intValue(); ++i) {
            Object object = this.parseNextToken(pushbackInputStream);
            if (object instanceof Operator) {
                if (((Operator)object).op.equals("endbfchar")) break;
                throw new IOException("Error : ~bfchar contains an unexpected operator : " + ((Operator)object).op);
            }
            byte[] byArray = (byte[])object;
            object = this.parseNextToken(pushbackInputStream);
            if (object instanceof byte[]) {
                byte[] byArray2 = (byte[])object;
                String string = this.createStringFromBytes(byArray2);
                cMap.addCharMapping(byArray, string);
                continue;
            }
            if (object instanceof LiteralName) {
                cMap.addCharMapping(byArray, ((LiteralName)object).name);
                continue;
            }
            throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + object);
        }
    }

    private void parseBegincidrange(int n, PushbackInputStream pushbackInputStream, CMap cMap) throws IOException {
        for (int i = 0; i < n; ++i) {
            Object object = this.parseNextToken(pushbackInputStream);
            if (object instanceof Operator) {
                if (((Operator)object).op.equals("endcidrange")) break;
                throw new IOException("Error : ~cidrange contains an unexpected operator : " + ((Operator)object).op);
            }
            byte[] byArray = (byte[])object;
            int n2 = this.createIntFromBytes(byArray);
            byte[] byArray2 = (byte[])this.parseNextToken(pushbackInputStream);
            int n3 = this.createIntFromBytes(byArray2);
            int n4 = (Integer)this.parseNextToken(pushbackInputStream);
            if (byArray.length <= 2 && byArray2.length <= 2) {
                cMap.addCIDRange((char)n2, (char)n3, n4);
                continue;
            }
            int n5 = n4 + n3 - n2;
            while (n4 <= n5) {
                int n6 = this.createIntFromBytes(byArray);
                cMap.addCIDMapping(n4++, n6);
                this.increment(byArray);
            }
        }
    }

    private void parseBegincidchar(Number number, PushbackInputStream pushbackInputStream, CMap cMap) throws IOException {
        for (int i = 0; i < number.intValue(); ++i) {
            Object object = this.parseNextToken(pushbackInputStream);
            if (object instanceof Operator) {
                if (((Operator)object).op.equals("endcidchar")) break;
                throw new IOException("Error : ~cidchar contains an unexpected operator : " + ((Operator)object).op);
            }
            byte[] byArray = (byte[])object;
            int n = (Integer)this.parseNextToken(pushbackInputStream);
            int n2 = this.createIntFromBytes(byArray);
            cMap.addCIDMapping(n, n2);
        }
    }

    private void parseBeginbfrange(Number number, PushbackInputStream pushbackInputStream, CMap cMap) throws IOException {
        for (int i = 0; i < number.intValue(); ++i) {
            byte[] byArray;
            Object object = this.parseNextToken(pushbackInputStream);
            if (object instanceof Operator) {
                if (((Operator)object).op.equals("endbfrange")) break;
                throw new IOException("Error : ~bfrange contains an unexpected operator : " + ((Operator)object).op);
            }
            byte[] byArray2 = (byte[])object;
            byte[] byArray3 = (byte[])this.parseNextToken(pushbackInputStream);
            object = this.parseNextToken(pushbackInputStream);
            List list = null;
            if (object instanceof List) {
                list = (List)object;
                byArray = (byte[])list.get(0);
            } else {
                byArray = (byte[])object;
            }
            if (byArray.length == 0) continue;
            boolean bl = false;
            int n = 0;
            while (!bl) {
                if (this.compare(byArray2, byArray3) >= 0) {
                    bl = true;
                }
                String string = this.createStringFromBytes(byArray);
                cMap.addCharMapping(byArray2, string);
                this.increment(byArray2);
                if (list == null) {
                    this.increment(byArray);
                    continue;
                }
                if (++n >= list.size()) continue;
                byArray = (byte[])list.get(n);
            }
        }
    }

    protected InputStream getExternalCMap(String string) throws IOException {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            throw new IOException("Error: Could not find referenced cmap stream " + string);
        }
        return uRL.openStream();
    }

    private Object parseNextToken(PushbackInputStream pushbackInputStream) throws IOException {
        Object object = null;
        int n = pushbackInputStream.read();
        while (n == 9 || n == 32 || n == 13 || n == 10) {
            n = pushbackInputStream.read();
        }
        switch (n) {
            case 37: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((char)n);
                this.readUntilEndOfLine(pushbackInputStream, stringBuilder);
                object = stringBuilder.toString();
                break;
            }
            case 40: {
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = pushbackInputStream.read();
                while (n2 != -1 && n2 != 41) {
                    stringBuilder.append((char)n2);
                    n2 = pushbackInputStream.read();
                }
                object = stringBuilder.toString();
                break;
            }
            case 62: {
                int n3 = pushbackInputStream.read();
                if (n3 == 62) {
                    object = MARK_END_OF_DICTIONARY;
                    break;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                object = MARK_END_OF_ARRAY;
                break;
            }
            case 91: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Object object2 = this.parseNextToken(pushbackInputStream);
                while (object2 != null && !MARK_END_OF_ARRAY.equals(object2)) {
                    arrayList.add(object2);
                    object2 = this.parseNextToken(pushbackInputStream);
                }
                object = arrayList;
                break;
            }
            case 60: {
                int n4 = pushbackInputStream.read();
                if (n4 == 60) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    Object object3 = this.parseNextToken(pushbackInputStream);
                    while (object3 instanceof LiteralName && !MARK_END_OF_DICTIONARY.equals(object3)) {
                        Object object4 = this.parseNextToken(pushbackInputStream);
                        hashMap.put(((LiteralName)object3).name, object4);
                        object3 = this.parseNextToken(pushbackInputStream);
                    }
                    object = hashMap;
                    break;
                }
                int n5 = 16;
                int n6 = -1;
                while (n4 != -1 && n4 != 62) {
                    int n7 = 0;
                    if (n4 >= 48 && n4 <= 57) {
                        n7 = n4 - 48;
                    } else if (n4 >= 65 && n4 <= 70) {
                        n7 = 10 + n4 - 65;
                    } else if (n4 >= 97 && n4 <= 102) {
                        n7 = 10 + n4 - 97;
                    } else {
                        if (this.isWhitespaceOrEOF(n4)) {
                            n4 = pushbackInputStream.read();
                            continue;
                        }
                        throw new IOException("Error: expected hex character and not " + (char)n4 + ":" + n4);
                    }
                    n7 *= n5;
                    if (n5 == 16) {
                        this.tokenParserByteBuffer[++n6] = 0;
                        n5 = 1;
                    } else {
                        n5 = 16;
                    }
                    int n8 = n6;
                    this.tokenParserByteBuffer[n8] = (byte)(this.tokenParserByteBuffer[n8] + n7);
                    n4 = pushbackInputStream.read();
                }
                byte[] byArray = new byte[n6 + 1];
                System.arraycopy(this.tokenParserByteBuffer, 0, byArray, 0, n6 + 1);
                object = byArray;
                break;
            }
            case 47: {
                StringBuilder stringBuilder = new StringBuilder();
                int n9 = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n9) && !this.isDelimiter(n9)) {
                    stringBuilder.append((char)n9);
                    n9 = pushbackInputStream.read();
                }
                if (this.isDelimiter(n9)) {
                    pushbackInputStream.unread(n9);
                }
                object = new LiteralName(stringBuilder.toString());
                break;
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((char)n);
                n = pushbackInputStream.read();
                while (!this.isWhitespaceOrEOF(n) && (Character.isDigit((char)n) || n == 46)) {
                    stringBuilder.append((char)n);
                    n = pushbackInputStream.read();
                }
                pushbackInputStream.unread(n);
                String string = stringBuilder.toString();
                if (string.indexOf(46) >= 0) {
                    object = Double.valueOf(string);
                    break;
                }
                object = Integer.valueOf(string);
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((char)n);
                n = pushbackInputStream.read();
                while (!(this.isWhitespaceOrEOF(n) || this.isDelimiter(n) || Character.isDigit(n))) {
                    stringBuilder.append((char)n);
                    n = pushbackInputStream.read();
                }
                if (this.isDelimiter(n) || Character.isDigit(n)) {
                    pushbackInputStream.unread(n);
                }
                object = new Operator(stringBuilder.toString());
                break;
            }
        }
        return object;
    }

    private void readUntilEndOfLine(InputStream inputStream, StringBuilder stringBuilder) throws IOException {
        int n = inputStream.read();
        while (n != -1 && n != 13 && n != 10) {
            stringBuilder.append((char)n);
            n = inputStream.read();
        }
    }

    private boolean isWhitespaceOrEOF(int n) {
        return n == -1 || n == 32 || n == 13 || n == 10;
    }

    private boolean isDelimiter(int n) {
        switch (n) {
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private void increment(byte[] byArray) {
        this.increment(byArray, byArray.length - 1);
    }

    private void increment(byte[] byArray, int n) {
        if (n > 0 && (byArray[n] & 0xFF) == 255) {
            byArray[n] = 0;
            this.increment(byArray, n - 1);
        } else {
            byArray[n] = (byte)(byArray[n] + 1);
        }
    }

    private int createIntFromBytes(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        if (byArray.length == 2) {
            n <<= 8;
            n += byArray[1] & 0xFF;
        }
        return n;
    }

    private String createStringFromBytes(byte[] byArray) throws IOException {
        return new String(byArray, byArray.length == 1 ? Charsets.ISO_8859_1 : Charsets.UTF_16BE);
    }

    private int compare(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            if ((byArray[i] & 0xFF) < (byArray2[i] & 0xFF)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private static final class Operator {
        private String op;

        private Operator(String string) {
            this.op = string;
        }
    }

    private static final class LiteralName {
        private String name;

        private LiteralName(String string) {
            this.name = string;
        }
    }
}

