/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.DataInput;

public class Type2CharStringParser {
    private int hstemCount = 0;
    private int vstemCount = 0;
    private List<Object> sequence = null;
    private final String fontName;
    private final String glyphName;

    public Type2CharStringParser(String string, String string2) {
        this.fontName = string;
        this.glyphName = string2;
    }

    public Type2CharStringParser(String string, int n) {
        this.fontName = string;
        this.glyphName = String.format("%04x", n);
    }

    public List<Object> parse(byte[] byArray, byte[][] byArray2, byte[][] byArray3) throws IOException {
        return this.parse(byArray, byArray2, byArray3, true);
    }

    private List<Object> parse(byte[] byArray, byte[][] byArray2, byte[][] byArray3, boolean bl) throws IOException {
        boolean bl2;
        if (bl) {
            this.hstemCount = 0;
            this.vstemCount = 0;
            this.sequence = new ArrayList<Object>();
        }
        DataInput dataInput = new DataInput(byArray);
        boolean bl3 = byArray3 != null && byArray3.length > 0;
        boolean bl4 = bl2 = byArray2 != null && byArray2.length > 0;
        while (dataInput.hasRemaining()) {
            Object object;
            byte[] byArray4;
            int n;
            int n2;
            int n3;
            Integer n4;
            int n5 = dataInput.readUnsignedByte();
            if (n5 == 10 && bl3) {
                n4 = (Integer)this.sequence.remove(this.sequence.size() - 1);
                n3 = 0;
                n2 = byArray3.length;
                n3 = n2 < 1240 ? 107 : (n2 < 33900 ? 1131 : 32768);
                n = n3 + n4;
                if (n >= byArray3.length) continue;
                byArray4 = byArray3[n];
                this.parse(byArray4, byArray2, byArray3, false);
                object = this.sequence.get(this.sequence.size() - 1);
                if (!(object instanceof CharStringCommand) || ((CharStringCommand)object).getKey().getValue()[0] != 11) continue;
                this.sequence.remove(this.sequence.size() - 1);
                continue;
            }
            if (n5 == 29 && bl2) {
                n2 = byArray2.length;
                n3 = n2 < 1240 ? 107 : (n2 < 33900 ? 1131 : 32768);
                n = n3 + (n4 = (Integer)this.sequence.remove(this.sequence.size() - 1));
                if (n >= byArray2.length) continue;
                byArray4 = byArray2[n];
                this.parse(byArray4, byArray2, byArray3, false);
                object = this.sequence.get(this.sequence.size() - 1);
                if (!(object instanceof CharStringCommand) || ((CharStringCommand)object).getKey().getValue()[0] != 11) continue;
                this.sequence.remove(this.sequence.size() - 1);
                continue;
            }
            if (n5 >= 0 && n5 <= 27) {
                this.sequence.add(this.readCommand(n5, dataInput));
                continue;
            }
            if (n5 == 28) {
                this.sequence.add(this.readNumber(n5, dataInput));
                continue;
            }
            if (n5 >= 29 && n5 <= 31) {
                this.sequence.add(this.readCommand(n5, dataInput));
                continue;
            }
            if (n5 >= 32 && n5 <= 255) {
                this.sequence.add(this.readNumber(n5, dataInput));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this.sequence;
    }

    private CharStringCommand readCommand(int n, DataInput dataInput) throws IOException {
        if (n == 1 || n == 18) {
            this.hstemCount += this.peekNumbers().size() / 2;
        } else if (n == 3 || n == 19 || n == 20 || n == 23) {
            this.vstemCount += this.peekNumbers().size() / 2;
        }
        if (n == 12) {
            int n2 = dataInput.readUnsignedByte();
            return new CharStringCommand(n, n2);
        }
        if (n == 19 || n == 20) {
            int[] nArray = new int[1 + this.getMaskLength()];
            nArray[0] = n;
            for (int i = 1; i < nArray.length; ++i) {
                nArray[i] = dataInput.readUnsignedByte();
            }
            return new CharStringCommand(nArray);
        }
        return new CharStringCommand(n);
    }

    private Number readNumber(int n, DataInput dataInput) throws IOException {
        if (n == 28) {
            return (int)dataInput.readShort();
        }
        if (n >= 32 && n <= 246) {
            return n - 139;
        }
        if (n >= 247 && n <= 250) {
            int n2 = dataInput.readUnsignedByte();
            return (n - 247) * 256 + n2 + 108;
        }
        if (n >= 251 && n <= 254) {
            int n3 = dataInput.readUnsignedByte();
            return -(n - 251) * 256 - n3 - 108;
        }
        if (n == 255) {
            short s = dataInput.readShort();
            double d = (double)dataInput.readUnsignedShort() / 65535.0;
            return (double)s + d;
        }
        throw new IllegalArgumentException();
    }

    private int getMaskLength() {
        int n = this.hstemCount + this.vstemCount;
        int n2 = n / 8;
        if (n % 8 > 0) {
            ++n2;
        }
        return n2;
    }

    private List<Number> peekNumbers() {
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (int i = this.sequence.size() - 1; i > -1; --i) {
            Object object = this.sequence.get(i);
            if (!(object instanceof Number)) {
                return arrayList;
            }
            arrayList.add(0, (Number)object);
        }
        return arrayList;
    }
}

