/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class CharStringCommand {
    private Key commandKey = null;
    public static final Map<Key, String> TYPE1_VOCABULARY;
    public static final Map<Key, String> TYPE2_VOCABULARY;

    public CharStringCommand(int n) {
        this.setKey(new Key(n));
    }

    public CharStringCommand(int n, int n2) {
        this.setKey(new Key(n, n2));
    }

    public CharStringCommand(int[] nArray) {
        this.setKey(new Key(nArray));
    }

    public Key getKey() {
        return this.commandKey;
    }

    private void setKey(Key key) {
        this.commandKey = key;
    }

    public String toString() {
        String string = TYPE2_VOCABULARY.get(this.getKey());
        if (string == null) {
            string = TYPE1_VOCABULARY.get(this.getKey());
        }
        if (string == null) {
            return this.getKey().toString() + '|';
        }
        return string + '|';
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CharStringCommand) {
            CharStringCommand charStringCommand = (CharStringCommand)object;
            return this.getKey().equals(charStringCommand.getKey());
        }
        return false;
    }

    static {
        LinkedHashMap<Key, String> linkedHashMap = new LinkedHashMap<Key, String>(26);
        linkedHashMap.put(new Key(1), "hstem");
        linkedHashMap.put(new Key(3), "vstem");
        linkedHashMap.put(new Key(4), "vmoveto");
        linkedHashMap.put(new Key(5), "rlineto");
        linkedHashMap.put(new Key(6), "hlineto");
        linkedHashMap.put(new Key(7), "vlineto");
        linkedHashMap.put(new Key(8), "rrcurveto");
        linkedHashMap.put(new Key(9), "closepath");
        linkedHashMap.put(new Key(10), "callsubr");
        linkedHashMap.put(new Key(11), "return");
        linkedHashMap.put(new Key(12), "escape");
        linkedHashMap.put(new Key(12, 0), "dotsection");
        linkedHashMap.put(new Key(12, 1), "vstem3");
        linkedHashMap.put(new Key(12, 2), "hstem3");
        linkedHashMap.put(new Key(12, 6), "seac");
        linkedHashMap.put(new Key(12, 7), "sbw");
        linkedHashMap.put(new Key(12, 12), "div");
        linkedHashMap.put(new Key(12, 16), "callothersubr");
        linkedHashMap.put(new Key(12, 17), "pop");
        linkedHashMap.put(new Key(12, 33), "setcurrentpoint");
        linkedHashMap.put(new Key(13), "hsbw");
        linkedHashMap.put(new Key(14), "endchar");
        linkedHashMap.put(new Key(21), "rmoveto");
        linkedHashMap.put(new Key(22), "hmoveto");
        linkedHashMap.put(new Key(30), "vhcurveto");
        linkedHashMap.put(new Key(31), "hvcurveto");
        TYPE1_VOCABULARY = Collections.unmodifiableMap(linkedHashMap);
        linkedHashMap = new LinkedHashMap(48);
        linkedHashMap.put(new Key(1), "hstem");
        linkedHashMap.put(new Key(3), "vstem");
        linkedHashMap.put(new Key(4), "vmoveto");
        linkedHashMap.put(new Key(5), "rlineto");
        linkedHashMap.put(new Key(6), "hlineto");
        linkedHashMap.put(new Key(7), "vlineto");
        linkedHashMap.put(new Key(8), "rrcurveto");
        linkedHashMap.put(new Key(10), "callsubr");
        linkedHashMap.put(new Key(11), "return");
        linkedHashMap.put(new Key(12), "escape");
        linkedHashMap.put(new Key(12, 3), "and");
        linkedHashMap.put(new Key(12, 4), "or");
        linkedHashMap.put(new Key(12, 5), "not");
        linkedHashMap.put(new Key(12, 9), "abs");
        linkedHashMap.put(new Key(12, 10), "add");
        linkedHashMap.put(new Key(12, 11), "sub");
        linkedHashMap.put(new Key(12, 12), "div");
        linkedHashMap.put(new Key(12, 14), "neg");
        linkedHashMap.put(new Key(12, 15), "eq");
        linkedHashMap.put(new Key(12, 18), "drop");
        linkedHashMap.put(new Key(12, 20), "put");
        linkedHashMap.put(new Key(12, 21), "get");
        linkedHashMap.put(new Key(12, 22), "ifelse");
        linkedHashMap.put(new Key(12, 23), "random");
        linkedHashMap.put(new Key(12, 24), "mul");
        linkedHashMap.put(new Key(12, 26), "sqrt");
        linkedHashMap.put(new Key(12, 27), "dup");
        linkedHashMap.put(new Key(12, 28), "exch");
        linkedHashMap.put(new Key(12, 29), "index");
        linkedHashMap.put(new Key(12, 30), "roll");
        linkedHashMap.put(new Key(12, 34), "hflex");
        linkedHashMap.put(new Key(12, 35), "flex");
        linkedHashMap.put(new Key(12, 36), "hflex1");
        linkedHashMap.put(new Key(12, 37), "flex1");
        linkedHashMap.put(new Key(14), "endchar");
        linkedHashMap.put(new Key(18), "hstemhm");
        linkedHashMap.put(new Key(19), "hintmask");
        linkedHashMap.put(new Key(20), "cntrmask");
        linkedHashMap.put(new Key(21), "rmoveto");
        linkedHashMap.put(new Key(22), "hmoveto");
        linkedHashMap.put(new Key(23), "vstemhm");
        linkedHashMap.put(new Key(24), "rcurveline");
        linkedHashMap.put(new Key(25), "rlinecurve");
        linkedHashMap.put(new Key(26), "vvcurveto");
        linkedHashMap.put(new Key(27), "hhcurveto");
        linkedHashMap.put(new Key(28), "shortint");
        linkedHashMap.put(new Key(29), "callgsubr");
        linkedHashMap.put(new Key(30), "vhcurveto");
        linkedHashMap.put(new Key(31), "hvcurveto");
        TYPE2_VOCABULARY = Collections.unmodifiableMap(linkedHashMap);
    }

    public static class Key {
        private int[] keyValues = null;

        public Key(int n) {
            this.setValue(new int[]{n});
        }

        public Key(int n, int n2) {
            this.setValue(new int[]{n, n2});
        }

        public Key(int[] nArray) {
            this.setValue(nArray);
        }

        public int[] getValue() {
            return this.keyValues;
        }

        private void setValue(int[] nArray) {
            this.keyValues = nArray;
        }

        public String toString() {
            return Arrays.toString(this.getValue());
        }

        public int hashCode() {
            if (this.keyValues[0] == 12 && this.keyValues.length > 1) {
                return this.keyValues[0] ^ this.keyValues[1];
            }
            return this.keyValues[0];
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                if (this.keyValues[0] == 12 && key.keyValues[0] == 12) {
                    if (this.keyValues.length > 1 && key.keyValues.length > 1) {
                        return this.keyValues[1] == key.keyValues[1];
                    }
                    return this.keyValues.length == key.keyValues.length;
                }
                return this.keyValues[0] == key.keyValues[0];
            }
            return false;
        }
    }
}

