/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IMockBuilder;
import org.easymock.IMocksControl;
import org.easymock.MockType;
import org.easymock.internal.Injector;
import org.easymock.internal.MockBuilder;

public class EasyMockSupport {
    protected final List<IMocksControl> controls = new ArrayList<IMocksControl>(5);

    public <T> T mock(Class<T> clazz) {
        return this.createControl().createMock(clazz);
    }

    public <T> T mock(String string, Class<T> clazz) {
        return this.createControl().createMock(string, clazz);
    }

    public <T> T mock(MockType mockType, Class<T> clazz) {
        return this.createControl(mockType).createMock(clazz);
    }

    public <T> T mock(String string, MockType mockType, Class<T> clazz) {
        return this.createControl(mockType).createMock(string, clazz);
    }

    public <T> T strictMock(Class<T> clazz) {
        return this.createStrictControl().createMock(clazz);
    }

    public <T> T strictMock(String string, Class<T> clazz) {
        return this.createStrictControl().createMock(string, clazz);
    }

    public <T> T niceMock(Class<T> clazz) {
        return this.createNiceControl().createMock(clazz);
    }

    public <T> T niceMock(String string, Class<T> clazz) {
        return this.createNiceControl().createMock(string, clazz);
    }

    public <T> IMockBuilder<T> partialMockBuilder(Class<T> clazz) {
        return new MockBuilder<T>(clazz, this);
    }

    public <T> T createMock(MockType mockType, Class<T> clazz) {
        return this.mock(mockType, clazz);
    }

    public <T> T createMock(String string, MockType mockType, Class<T> clazz) {
        return this.mock(string, mockType, clazz);
    }

    public <T> T createStrictMock(Class<T> clazz) {
        return this.strictMock(clazz);
    }

    public <T> T createStrictMock(String string, Class<T> clazz) {
        return this.strictMock(string, clazz);
    }

    public <T> T createMock(Class<T> clazz) {
        return this.mock(clazz);
    }

    public <T> T createMock(String string, Class<T> clazz) {
        return this.mock(string, clazz);
    }

    public <T> T createNiceMock(Class<T> clazz) {
        return this.niceMock(clazz);
    }

    public <T> T createNiceMock(String string, Class<T> clazz) {
        return this.niceMock(string, clazz);
    }

    public IMocksControl createStrictControl() {
        IMocksControl iMocksControl = EasyMock.createStrictControl();
        this.controls.add(iMocksControl);
        return iMocksControl;
    }

    public <T> IMockBuilder<T> createMockBuilder(Class<T> clazz) {
        return this.partialMockBuilder(clazz);
    }

    public IMocksControl createControl(MockType mockType) {
        IMocksControl iMocksControl = EasyMock.createControl(mockType);
        this.controls.add(iMocksControl);
        return iMocksControl;
    }

    public IMocksControl createControl() {
        return this.createControl(MockType.DEFAULT);
    }

    public IMocksControl createNiceControl() {
        IMocksControl iMocksControl = EasyMock.createNiceControl();
        this.controls.add(iMocksControl);
        return iMocksControl;
    }

    public void replayAll() {
        for (IMocksControl iMocksControl : this.controls) {
            iMocksControl.replay();
        }
    }

    public void resetAll() {
        for (IMocksControl iMocksControl : this.controls) {
            iMocksControl.reset();
        }
    }

    public void verifyAll() {
        for (IMocksControl iMocksControl : this.controls) {
            iMocksControl.verify();
        }
    }

    public void resetAllToNice() {
        for (IMocksControl iMocksControl : this.controls) {
            iMocksControl.resetToNice();
        }
    }

    public void resetAllToDefault() {
        for (IMocksControl iMocksControl : this.controls) {
            iMocksControl.resetToDefault();
        }
    }

    public void resetAllToStrict() {
        for (IMocksControl iMocksControl : this.controls) {
            iMocksControl.resetToStrict();
        }
    }

    public static void injectMocks(Object object) {
        Injector.injectMocks(object);
    }
}

