/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "widget_options.h"

WidgetOptions::WidgetOptions (bool init /* = true */) :
    mOptions (WidgetOptions::OptionNum),
    mNotify (WidgetOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
WidgetOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned int edge;

    // toggle_key
    mOptions[WidgetOptions::ToggleKey].setName ("toggle_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("F9");
    mOptions[WidgetOptions::ToggleKey].value().set (action);
    if (screen) screen->addAction (&mOptions[WidgetOptions::ToggleKey].value ().action ());

    // toggle_button
    mOptions[WidgetOptions::ToggleButton].setName ("toggle_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[WidgetOptions::ToggleButton].value().set (action);
    if (screen) screen->addAction (&mOptions[WidgetOptions::ToggleButton].value ().action ());

    // toggle_edge
    mOptions[WidgetOptions::ToggleEdge].setName ("toggle_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[WidgetOptions::ToggleEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[WidgetOptions::ToggleEdge].value ().action ());

    // match
    mOptions[WidgetOptions::Match].setName ("match", CompOption::TypeMatch);
    mOptions[WidgetOptions::Match].value().set(CompMatch (""));
    mOptions[WidgetOptions::Match].value().match ().update ();

    // end_on_click
    mOptions[WidgetOptions::EndOnClick].setName ("end_on_click", CompOption::TypeBool);
    mOptions[WidgetOptions::EndOnClick].value().set(true);

    // fade_time
    mOptions[WidgetOptions::FadeTime].setName ("fade_time", CompOption::TypeFloat);
    mOptions[WidgetOptions::FadeTime].rest ().set (0, 10, 0.1);
    mOptions[WidgetOptions::FadeTime].value().set((float) 0.5);

    // bg_brightness
    mOptions[WidgetOptions::BgBrightness].setName ("bg_brightness", CompOption::TypeInt);
    mOptions[WidgetOptions::BgBrightness].rest ().set (0, 100);
    mOptions[WidgetOptions::BgBrightness].value().set((int) 50);

    // bg_saturation
    mOptions[WidgetOptions::BgSaturation].setName ("bg_saturation", CompOption::TypeInt);
    mOptions[WidgetOptions::BgSaturation].rest ().set (0, 100);
    mOptions[WidgetOptions::BgSaturation].value().set((int) 100);

}

WidgetOptions::~WidgetOptions ()
{
}


CompOption::Vector &
WidgetOptions::getOptions ()
{
    return mOptions;
}

bool
WidgetOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case WidgetOptions::ToggleKey:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::ToggleKey].empty ())
                    mNotify[WidgetOptions::ToggleKey] (o, WidgetOptions::ToggleKey);
                return true;
            }
            break;
        case WidgetOptions::ToggleButton:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::ToggleButton].empty ())
                    mNotify[WidgetOptions::ToggleButton] (o, WidgetOptions::ToggleButton);
                return true;
            }
            break;
        case WidgetOptions::ToggleEdge:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::ToggleEdge].empty ())
                    mNotify[WidgetOptions::ToggleEdge] (o, WidgetOptions::ToggleEdge);
                return true;
            }
            break;
        case WidgetOptions::Match:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::Match].empty ())
                    mNotify[WidgetOptions::Match] (o, WidgetOptions::Match);
                return true;
            }
            break;
        case WidgetOptions::EndOnClick:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::EndOnClick].empty ())
                    mNotify[WidgetOptions::EndOnClick] (o, WidgetOptions::EndOnClick);
                return true;
            }
            break;
        case WidgetOptions::FadeTime:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::FadeTime].empty ())
                    mNotify[WidgetOptions::FadeTime] (o, WidgetOptions::FadeTime);
                return true;
            }
            break;
        case WidgetOptions::BgBrightness:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::BgBrightness].empty ())
                    mNotify[WidgetOptions::BgBrightness] (o, WidgetOptions::BgBrightness);
                return true;
            }
            break;
        case WidgetOptions::BgSaturation:
            if (o->set (value))
            {
                if (!mNotify[WidgetOptions::BgSaturation].empty ())
                    mNotify[WidgetOptions::BgSaturation] (o, WidgetOptions::BgSaturation);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

