/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "switcher_options.h"

SwitcherOptions::SwitcherOptions (bool init /* = true */) :
    mOptions (SwitcherOptions::OptionNum),
    mNotify (SwitcherOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
SwitcherOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // next_button
    mOptions[SwitcherOptions::NextButton].setName ("next_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::NextButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextButton].value ().action ());

    // next_key
    mOptions[SwitcherOptions::NextKey].setName ("next_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>Tab");
    mOptions[SwitcherOptions::NextKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextKey].value ().action ());

    // prev_button
    mOptions[SwitcherOptions::PrevButton].setName ("prev_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::PrevButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevButton].value ().action ());

    // prev_key
    mOptions[SwitcherOptions::PrevKey].setName ("prev_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Shift><Alt>Tab");
    mOptions[SwitcherOptions::PrevKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevKey].value ().action ());

    // next_all_button
    mOptions[SwitcherOptions::NextAllButton].setName ("next_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::NextAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextAllButton].value ().action ());

    // next_all_key
    mOptions[SwitcherOptions::NextAllKey].setName ("next_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>Tab");
    mOptions[SwitcherOptions::NextAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextAllKey].value ().action ());

    // prev_all_button
    mOptions[SwitcherOptions::PrevAllButton].setName ("prev_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::PrevAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevAllButton].value ().action ());

    // prev_all_key
    mOptions[SwitcherOptions::PrevAllKey].setName ("prev_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Shift><Control><Alt>Tab");
    mOptions[SwitcherOptions::PrevAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevAllKey].value ().action ());

    // next_no_popup_button
    mOptions[SwitcherOptions::NextNoPopupButton].setName ("next_no_popup_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::NextNoPopupButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextNoPopupButton].value ().action ());

    // next_no_popup_key
    mOptions[SwitcherOptions::NextNoPopupKey].setName ("next_no_popup_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[SwitcherOptions::NextNoPopupKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextNoPopupKey].value ().action ());

    // prev_no_popup_button
    mOptions[SwitcherOptions::PrevNoPopupButton].setName ("prev_no_popup_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::PrevNoPopupButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevNoPopupButton].value ().action ());

    // prev_no_popup_key
    mOptions[SwitcherOptions::PrevNoPopupKey].setName ("prev_no_popup_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[SwitcherOptions::PrevNoPopupKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevNoPopupKey].value ().action ());

    // next_panel_button
    mOptions[SwitcherOptions::NextPanelButton].setName ("next_panel_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::NextPanelButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextPanelButton].value ().action ());

    // next_panel_key
    mOptions[SwitcherOptions::NextPanelKey].setName ("next_panel_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[SwitcherOptions::NextPanelKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::NextPanelKey].value ().action ());

    // prev_panel_button
    mOptions[SwitcherOptions::PrevPanelButton].setName ("prev_panel_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[SwitcherOptions::PrevPanelButton].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevPanelButton].value ().action ());

    // prev_panel_key
    mOptions[SwitcherOptions::PrevPanelKey].setName ("prev_panel_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[SwitcherOptions::PrevPanelKey].value().set (action);
    if (screen) screen->addAction (&mOptions[SwitcherOptions::PrevPanelKey].value ().action ());

    // speed
    mOptions[SwitcherOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[SwitcherOptions::Speed].rest ().set (0.1, 50, 0.1);
    mOptions[SwitcherOptions::Speed].value().set((float) 1.5);

    // timestep
    mOptions[SwitcherOptions::Timestep].setName ("timestep", CompOption::TypeFloat);
    mOptions[SwitcherOptions::Timestep].rest ().set (0.1, 50, 0.1);
    mOptions[SwitcherOptions::Timestep].value().set((float) 1.2);

    // size_multiplier
    mOptions[SwitcherOptions::SizeMultiplier].setName ("size_multiplier", CompOption::TypeFloat);
    mOptions[SwitcherOptions::SizeMultiplier].rest ().set (0.1, 10, 0.1);
    mOptions[SwitcherOptions::SizeMultiplier].value().set((float) 1);

    // window_match
    mOptions[SwitcherOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[SwitcherOptions::WindowMatch].value().set(CompMatch ("Toolbar | Utility | Dialog | Normal | Unknown"));
    mOptions[SwitcherOptions::WindowMatch].value().match ().update ();

    // mipmap
    mOptions[SwitcherOptions::Mipmap].setName ("mipmap", CompOption::TypeBool);
    mOptions[SwitcherOptions::Mipmap].value().set(true);

    // saturation
    mOptions[SwitcherOptions::Saturation].setName ("saturation", CompOption::TypeInt);
    mOptions[SwitcherOptions::Saturation].rest ().set (0, 100);
    mOptions[SwitcherOptions::Saturation].value().set((int) 100);

    // brightness
    mOptions[SwitcherOptions::Brightness].setName ("brightness", CompOption::TypeInt);
    mOptions[SwitcherOptions::Brightness].rest ().set (0, 100);
    mOptions[SwitcherOptions::Brightness].value().set((int) 65);

    // opacity
    mOptions[SwitcherOptions::Opacity].setName ("opacity", CompOption::TypeInt);
    mOptions[SwitcherOptions::Opacity].rest ().set (0, 100);
    mOptions[SwitcherOptions::Opacity].value().set((int) 40);

    // focus_on_switch
    mOptions[SwitcherOptions::FocusOnSwitch].setName ("focus_on_switch", CompOption::TypeBool);

    // bring_to_front
    mOptions[SwitcherOptions::BringToFront].setName ("bring_to_front", CompOption::TypeBool);
    mOptions[SwitcherOptions::BringToFront].value().set(true);

    // zoom
    mOptions[SwitcherOptions::Zoom].setName ("zoom", CompOption::TypeFloat);
    mOptions[SwitcherOptions::Zoom].rest ().set (0, 5, 0.1);
    mOptions[SwitcherOptions::Zoom].value().set((float) 1);

    // icon
    mOptions[SwitcherOptions::Icon].setName ("icon", CompOption::TypeBool);
    mOptions[SwitcherOptions::Icon].value().set(true);

    // icon_only
    mOptions[SwitcherOptions::IconOnly].setName ("icon_only", CompOption::TypeBool);
    mOptions[SwitcherOptions::IconOnly].value().set(false);

    // minimized
    mOptions[SwitcherOptions::Minimized].setName ("minimized", CompOption::TypeBool);
    mOptions[SwitcherOptions::Minimized].value().set(true);

    // auto_rotate
    mOptions[SwitcherOptions::AutoRotate].setName ("auto_rotate", CompOption::TypeBool);
    mOptions[SwitcherOptions::AutoRotate].value().set(false);

    // use_background_color
    mOptions[SwitcherOptions::UseBackgroundColor].setName ("use_background_color", CompOption::TypeBool);
    mOptions[SwitcherOptions::UseBackgroundColor].value().set(false);

    // background_color
    mOptions[SwitcherOptions::BackgroundColor].setName ("background_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x3333));
    color[1] = MAX (0, MIN (0xffff, 0x3333));
    color[2] = MAX (0, MIN (0xffff, 0x3333));
    color[3] = MAX (0, MIN (0xffff, 0xd998));
    mOptions[SwitcherOptions::BackgroundColor].value().set(color);

}

SwitcherOptions::~SwitcherOptions ()
{
}


CompOption::Vector &
SwitcherOptions::getOptions ()
{
    return mOptions;
}

bool
SwitcherOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case SwitcherOptions::NextButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextButton].empty ())
                    mNotify[SwitcherOptions::NextButton] (o, SwitcherOptions::NextButton);
                return true;
            }
            break;
        case SwitcherOptions::NextKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextKey].empty ())
                    mNotify[SwitcherOptions::NextKey] (o, SwitcherOptions::NextKey);
                return true;
            }
            break;
        case SwitcherOptions::PrevButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevButton].empty ())
                    mNotify[SwitcherOptions::PrevButton] (o, SwitcherOptions::PrevButton);
                return true;
            }
            break;
        case SwitcherOptions::PrevKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevKey].empty ())
                    mNotify[SwitcherOptions::PrevKey] (o, SwitcherOptions::PrevKey);
                return true;
            }
            break;
        case SwitcherOptions::NextAllButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextAllButton].empty ())
                    mNotify[SwitcherOptions::NextAllButton] (o, SwitcherOptions::NextAllButton);
                return true;
            }
            break;
        case SwitcherOptions::NextAllKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextAllKey].empty ())
                    mNotify[SwitcherOptions::NextAllKey] (o, SwitcherOptions::NextAllKey);
                return true;
            }
            break;
        case SwitcherOptions::PrevAllButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevAllButton].empty ())
                    mNotify[SwitcherOptions::PrevAllButton] (o, SwitcherOptions::PrevAllButton);
                return true;
            }
            break;
        case SwitcherOptions::PrevAllKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevAllKey].empty ())
                    mNotify[SwitcherOptions::PrevAllKey] (o, SwitcherOptions::PrevAllKey);
                return true;
            }
            break;
        case SwitcherOptions::NextNoPopupButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextNoPopupButton].empty ())
                    mNotify[SwitcherOptions::NextNoPopupButton] (o, SwitcherOptions::NextNoPopupButton);
                return true;
            }
            break;
        case SwitcherOptions::NextNoPopupKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextNoPopupKey].empty ())
                    mNotify[SwitcherOptions::NextNoPopupKey] (o, SwitcherOptions::NextNoPopupKey);
                return true;
            }
            break;
        case SwitcherOptions::PrevNoPopupButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevNoPopupButton].empty ())
                    mNotify[SwitcherOptions::PrevNoPopupButton] (o, SwitcherOptions::PrevNoPopupButton);
                return true;
            }
            break;
        case SwitcherOptions::PrevNoPopupKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevNoPopupKey].empty ())
                    mNotify[SwitcherOptions::PrevNoPopupKey] (o, SwitcherOptions::PrevNoPopupKey);
                return true;
            }
            break;
        case SwitcherOptions::NextPanelButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextPanelButton].empty ())
                    mNotify[SwitcherOptions::NextPanelButton] (o, SwitcherOptions::NextPanelButton);
                return true;
            }
            break;
        case SwitcherOptions::NextPanelKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::NextPanelKey].empty ())
                    mNotify[SwitcherOptions::NextPanelKey] (o, SwitcherOptions::NextPanelKey);
                return true;
            }
            break;
        case SwitcherOptions::PrevPanelButton:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevPanelButton].empty ())
                    mNotify[SwitcherOptions::PrevPanelButton] (o, SwitcherOptions::PrevPanelButton);
                return true;
            }
            break;
        case SwitcherOptions::PrevPanelKey:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::PrevPanelKey].empty ())
                    mNotify[SwitcherOptions::PrevPanelKey] (o, SwitcherOptions::PrevPanelKey);
                return true;
            }
            break;
        case SwitcherOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Speed].empty ())
                    mNotify[SwitcherOptions::Speed] (o, SwitcherOptions::Speed);
                return true;
            }
            break;
        case SwitcherOptions::Timestep:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Timestep].empty ())
                    mNotify[SwitcherOptions::Timestep] (o, SwitcherOptions::Timestep);
                return true;
            }
            break;
        case SwitcherOptions::SizeMultiplier:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::SizeMultiplier].empty ())
                    mNotify[SwitcherOptions::SizeMultiplier] (o, SwitcherOptions::SizeMultiplier);
                return true;
            }
            break;
        case SwitcherOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::WindowMatch].empty ())
                    mNotify[SwitcherOptions::WindowMatch] (o, SwitcherOptions::WindowMatch);
                return true;
            }
            break;
        case SwitcherOptions::Mipmap:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Mipmap].empty ())
                    mNotify[SwitcherOptions::Mipmap] (o, SwitcherOptions::Mipmap);
                return true;
            }
            break;
        case SwitcherOptions::Saturation:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Saturation].empty ())
                    mNotify[SwitcherOptions::Saturation] (o, SwitcherOptions::Saturation);
                return true;
            }
            break;
        case SwitcherOptions::Brightness:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Brightness].empty ())
                    mNotify[SwitcherOptions::Brightness] (o, SwitcherOptions::Brightness);
                return true;
            }
            break;
        case SwitcherOptions::Opacity:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Opacity].empty ())
                    mNotify[SwitcherOptions::Opacity] (o, SwitcherOptions::Opacity);
                return true;
            }
            break;
        case SwitcherOptions::FocusOnSwitch:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::FocusOnSwitch].empty ())
                    mNotify[SwitcherOptions::FocusOnSwitch] (o, SwitcherOptions::FocusOnSwitch);
                return true;
            }
            break;
        case SwitcherOptions::BringToFront:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::BringToFront].empty ())
                    mNotify[SwitcherOptions::BringToFront] (o, SwitcherOptions::BringToFront);
                return true;
            }
            break;
        case SwitcherOptions::Zoom:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Zoom].empty ())
                    mNotify[SwitcherOptions::Zoom] (o, SwitcherOptions::Zoom);
                return true;
            }
            break;
        case SwitcherOptions::Icon:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Icon].empty ())
                    mNotify[SwitcherOptions::Icon] (o, SwitcherOptions::Icon);
                return true;
            }
            break;
        case SwitcherOptions::IconOnly:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::IconOnly].empty ())
                    mNotify[SwitcherOptions::IconOnly] (o, SwitcherOptions::IconOnly);
                return true;
            }
            break;
        case SwitcherOptions::Minimized:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::Minimized].empty ())
                    mNotify[SwitcherOptions::Minimized] (o, SwitcherOptions::Minimized);
                return true;
            }
            break;
        case SwitcherOptions::AutoRotate:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::AutoRotate].empty ())
                    mNotify[SwitcherOptions::AutoRotate] (o, SwitcherOptions::AutoRotate);
                return true;
            }
            break;
        case SwitcherOptions::UseBackgroundColor:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::UseBackgroundColor].empty ())
                    mNotify[SwitcherOptions::UseBackgroundColor] (o, SwitcherOptions::UseBackgroundColor);
                return true;
            }
            break;
        case SwitcherOptions::BackgroundColor:
            if (o->set (value))
            {
                if (!mNotify[SwitcherOptions::BackgroundColor].empty ())
                    mNotify[SwitcherOptions::BackgroundColor] (o, SwitcherOptions::BackgroundColor);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

