/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "fade_options.h"

FadeOptions::FadeOptions (bool init /* = true */) :
    mOptions (FadeOptions::OptionNum),
    mNotify (FadeOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
FadeOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // fade_mode
    mOptions[FadeOptions::FadeMode].setName ("fade_mode", CompOption::TypeInt);
    mOptions[FadeOptions::FadeMode].rest ().set (0, 1);
    mOptions[FadeOptions::FadeMode].value().set((int) 0);

    // fade_speed
    mOptions[FadeOptions::FadeSpeed].setName ("fade_speed", CompOption::TypeFloat);
    mOptions[FadeOptions::FadeSpeed].rest ().set (0.1, 25.0, 0.1);
    mOptions[FadeOptions::FadeSpeed].value().set((float) 5.0);

    // fade_time
    mOptions[FadeOptions::FadeTime].setName ("fade_time", CompOption::TypeInt);
    mOptions[FadeOptions::FadeTime].rest ().set (1, 5000);
    mOptions[FadeOptions::FadeTime].value().set((int) 100);

    // window_match
    mOptions[FadeOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[FadeOptions::WindowMatch].value().set(CompMatch ("any"));
    mOptions[FadeOptions::WindowMatch].value().match ().update ();

    // visual_bell
    mOptions[FadeOptions::VisualBell].setName ("visual_bell", CompOption::TypeBell);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitBell);
    mOptions[FadeOptions::VisualBell].value().set (action);
    if (screen) screen->addAction (&mOptions[FadeOptions::VisualBell].value ().action ());

    // fullscreen_visual_bell
    mOptions[FadeOptions::FullscreenVisualBell].setName ("fullscreen_visual_bell", CompOption::TypeBool);
    mOptions[FadeOptions::FullscreenVisualBell].value().set(false);

    // dim_unresponsive
    mOptions[FadeOptions::DimUnresponsive].setName ("dim_unresponsive", CompOption::TypeBool);
    mOptions[FadeOptions::DimUnresponsive].value().set(true);

    // unresponsive_brightness
    mOptions[FadeOptions::UnresponsiveBrightness].setName ("unresponsive_brightness", CompOption::TypeInt);
    mOptions[FadeOptions::UnresponsiveBrightness].rest ().set (0, 100);
    mOptions[FadeOptions::UnresponsiveBrightness].value().set((int) 65);

    // unresponsive_saturation
    mOptions[FadeOptions::UnresponsiveSaturation].setName ("unresponsive_saturation", CompOption::TypeInt);
    mOptions[FadeOptions::UnresponsiveSaturation].rest ().set (0, 100);
    mOptions[FadeOptions::UnresponsiveSaturation].value().set((int) 0);

}

FadeOptions::~FadeOptions ()
{
}


CompOption::Vector &
FadeOptions::getOptions ()
{
    return mOptions;
}

bool
FadeOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case FadeOptions::FadeMode:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::FadeMode].empty ())
                    mNotify[FadeOptions::FadeMode] (o, FadeOptions::FadeMode);
                return true;
            }
            break;
        case FadeOptions::FadeSpeed:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::FadeSpeed].empty ())
                    mNotify[FadeOptions::FadeSpeed] (o, FadeOptions::FadeSpeed);
                return true;
            }
            break;
        case FadeOptions::FadeTime:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::FadeTime].empty ())
                    mNotify[FadeOptions::FadeTime] (o, FadeOptions::FadeTime);
                return true;
            }
            break;
        case FadeOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::WindowMatch].empty ())
                    mNotify[FadeOptions::WindowMatch] (o, FadeOptions::WindowMatch);
                return true;
            }
            break;
        case FadeOptions::VisualBell:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::VisualBell].empty ())
                    mNotify[FadeOptions::VisualBell] (o, FadeOptions::VisualBell);
                return true;
            }
            break;
        case FadeOptions::FullscreenVisualBell:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::FullscreenVisualBell].empty ())
                    mNotify[FadeOptions::FullscreenVisualBell] (o, FadeOptions::FullscreenVisualBell);
                return true;
            }
            break;
        case FadeOptions::DimUnresponsive:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::DimUnresponsive].empty ())
                    mNotify[FadeOptions::DimUnresponsive] (o, FadeOptions::DimUnresponsive);
                return true;
            }
            break;
        case FadeOptions::UnresponsiveBrightness:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::UnresponsiveBrightness].empty ())
                    mNotify[FadeOptions::UnresponsiveBrightness] (o, FadeOptions::UnresponsiveBrightness);
                return true;
            }
            break;
        case FadeOptions::UnresponsiveSaturation:
            if (o->set (value))
            {
                if (!mNotify[FadeOptions::UnresponsiveSaturation].empty ())
                    mNotify[FadeOptions::UnresponsiveSaturation] (o, FadeOptions::UnresponsiveSaturation);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

