/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "core_options.h"

CoreOptions::CoreOptions (bool init /* = true */) :
    mOptions (CoreOptions::OptionNum),
    mNotify (CoreOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
CoreOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned int edge;
    CompOption::Value::Vector list;
    CompOption::Value value;

    // active_plugins
    mOptions[CoreOptions::ActivePlugins].setName ("active_plugins", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("composite"));
    list.push_back (value);
    value.set(CompString ("opengl"));
    list.push_back (value);
    value.set(CompString ("decor"));
    list.push_back (value);
    value.set(CompString ("resize"));
    list.push_back (value);
    value.set(CompString ("place"));
    list.push_back (value);
    value.set(CompString ("move"));
    list.push_back (value);
    value.set(CompString ("compiztoolbox"));
    list.push_back (value);
    value.set(CompString ("staticswitcher"));
    list.push_back (value);
    value.set(CompString ("regex"));
    list.push_back (value);
    value.set(CompString ("animation"));
    list.push_back (value);
    value.set(CompString ("wall"));
    list.push_back (value);
    value.set(CompString ("ccp"));
    list.push_back (value);
    mOptions[CoreOptions::ActivePlugins].value().set (CompOption::TypeString, list);

    // audible_bell
    mOptions[CoreOptions::AudibleBell].setName ("audible_bell", CompOption::TypeBool);
    mOptions[CoreOptions::AudibleBell].value().set(true);

    // ignore_hints_when_maximized
    mOptions[CoreOptions::IgnoreHintsWhenMaximized].setName ("ignore_hints_when_maximized", CompOption::TypeBool);
    mOptions[CoreOptions::IgnoreHintsWhenMaximized].value().set(true);

    // hide_skip_taskbar_windows
    mOptions[CoreOptions::HideSkipTaskbarWindows].setName ("hide_skip_taskbar_windows", CompOption::TypeBool);
    mOptions[CoreOptions::HideSkipTaskbarWindows].value().set(true);

    // edge_delay
    mOptions[CoreOptions::EdgeDelay].setName ("edge_delay", CompOption::TypeInt);
    mOptions[CoreOptions::EdgeDelay].rest ().set (0, 10000);
    mOptions[CoreOptions::EdgeDelay].value().set((int) 0);

    // ping_delay
    mOptions[CoreOptions::PingDelay].setName ("ping_delay", CompOption::TypeInt);
    mOptions[CoreOptions::PingDelay].rest ().set (1000, 30000);
    mOptions[CoreOptions::PingDelay].value().set((int) 5000);

    // default_icon
    mOptions[CoreOptions::DefaultIcon].setName ("default_icon", CompOption::TypeString);
    mOptions[CoreOptions::DefaultIcon].value().set(CompString ("icon"));

    // do_serialize
    mOptions[CoreOptions::DoSerialize].setName ("do_serialize", CompOption::TypeBool);
    mOptions[CoreOptions::DoSerialize].value().set(false);

    // overlapping_outputs
    mOptions[CoreOptions::OverlappingOutputs].setName ("overlapping_outputs", CompOption::TypeInt);
    mOptions[CoreOptions::OverlappingOutputs].rest ().set (0, 2);
    mOptions[CoreOptions::OverlappingOutputs].value().set((int) 0);

    // detect_outputs
    mOptions[CoreOptions::DetectOutputs].setName ("detect_outputs", CompOption::TypeBool);
    mOptions[CoreOptions::DetectOutputs].value().set(true);

    // outputs
    mOptions[CoreOptions::Outputs].setName ("outputs", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("640x480+0+0"));
    list.push_back (value);
    mOptions[CoreOptions::Outputs].value().set (CompOption::TypeString, list);

    // click_to_focus
    mOptions[CoreOptions::ClickToFocus].setName ("click_to_focus", CompOption::TypeBool);
    mOptions[CoreOptions::ClickToFocus].value().set(true);

    // raise_on_click
    mOptions[CoreOptions::RaiseOnClick].setName ("raise_on_click", CompOption::TypeBool);
    mOptions[CoreOptions::RaiseOnClick].value().set(true);

    // autoraise
    mOptions[CoreOptions::Autoraise].setName ("autoraise", CompOption::TypeBool);
    mOptions[CoreOptions::Autoraise].value().set(true);

    // autoraise_delay
    mOptions[CoreOptions::AutoraiseDelay].setName ("autoraise_delay", CompOption::TypeInt);
    mOptions[CoreOptions::AutoraiseDelay].rest ().set (0, 10000);
    mOptions[CoreOptions::AutoraiseDelay].value().set((int) 1000);

    // focus_desktop
    mOptions[CoreOptions::FocusDesktop].setName ("focus_desktop", CompOption::TypeBool);
    mOptions[CoreOptions::FocusDesktop].value().set(true);

    // focus_prevention_level
    mOptions[CoreOptions::FocusPreventionLevel].setName ("focus_prevention_level", CompOption::TypeInt);
    mOptions[CoreOptions::FocusPreventionLevel].rest ().set (0, 4);
    mOptions[CoreOptions::FocusPreventionLevel].value().set((int) 0);

    // focus_prevention_match
    mOptions[CoreOptions::FocusPreventionMatch].setName ("focus_prevention_match", CompOption::TypeMatch);
    mOptions[CoreOptions::FocusPreventionMatch].value().set(CompMatch ("any"));
    mOptions[CoreOptions::FocusPreventionMatch].value().match ().update ();

    // close_window_key
    mOptions[CoreOptions::CloseWindowKey].setName ("close_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F4");
    mOptions[CoreOptions::CloseWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::CloseWindowKey].value ().action ());

    // close_window_button
    mOptions[CoreOptions::CloseWindowButton].setName ("close_window_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[CoreOptions::CloseWindowButton].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::CloseWindowButton].value ().action ());

    // raise_window_key
    mOptions[CoreOptions::RaiseWindowKey].setName ("raise_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::RaiseWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::RaiseWindowKey].value ().action ());

    // raise_window_button
    mOptions[CoreOptions::RaiseWindowButton].setName ("raise_window_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Control>Button6");
    mOptions[CoreOptions::RaiseWindowButton].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::RaiseWindowButton].value ().action ());

    // lower_window_key
    mOptions[CoreOptions::LowerWindowKey].setName ("lower_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::LowerWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::LowerWindowKey].value ().action ());

    // lower_window_button
    mOptions[CoreOptions::LowerWindowButton].setName ("lower_window_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Alt>Button6");
    mOptions[CoreOptions::LowerWindowButton].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::LowerWindowButton].value ().action ());

    // minimize_window_key
    mOptions[CoreOptions::MinimizeWindowKey].setName ("minimize_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F9");
    mOptions[CoreOptions::MinimizeWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::MinimizeWindowKey].value ().action ());

    // minimize_window_button
    mOptions[CoreOptions::MinimizeWindowButton].setName ("minimize_window_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[CoreOptions::MinimizeWindowButton].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::MinimizeWindowButton].value ().action ());

    // maximize_window_key
    mOptions[CoreOptions::MaximizeWindowKey].setName ("maximize_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F10");
    mOptions[CoreOptions::MaximizeWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::MaximizeWindowKey].value ().action ());

    // unmaximize_window_key
    mOptions[CoreOptions::UnmaximizeWindowKey].setName ("unmaximize_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F5");
    mOptions[CoreOptions::UnmaximizeWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::UnmaximizeWindowKey].value ().action ());

    // unmaximize_or_minimize_window_key
    mOptions[CoreOptions::UnmaximizeOrMinimizeWindowKey].setName ("unmaximize_or_minimize_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::UnmaximizeOrMinimizeWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::UnmaximizeOrMinimizeWindowKey].value ().action ());

    // maximize_window_horizontally_key
    mOptions[CoreOptions::MaximizeWindowHorizontallyKey].setName ("maximize_window_horizontally_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::MaximizeWindowHorizontallyKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::MaximizeWindowHorizontallyKey].value ().action ());

    // maximize_window_vertically_key
    mOptions[CoreOptions::MaximizeWindowVerticallyKey].setName ("maximize_window_vertically_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::MaximizeWindowVerticallyKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::MaximizeWindowVerticallyKey].value ().action ());

    // window_menu_key
    mOptions[CoreOptions::WindowMenuKey].setName ("window_menu_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>space");
    mOptions[CoreOptions::WindowMenuKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::WindowMenuKey].value ().action ());

    // window_menu_button
    mOptions[CoreOptions::WindowMenuButton].setName ("window_menu_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Alt>Button3");
    mOptions[CoreOptions::WindowMenuButton].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::WindowMenuButton].value ().action ());

    // show_desktop_key
    mOptions[CoreOptions::ShowDesktopKey].setName ("show_desktop_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>d");
    mOptions[CoreOptions::ShowDesktopKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::ShowDesktopKey].value ().action ());

    // show_desktop_edge
    mOptions[CoreOptions::ShowDesktopEdge].setName ("show_desktop_edge", CompOption::TypeEdge);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitEdge);
    edge = 0;
    action.setEdgeMask (edge);
    mOptions[CoreOptions::ShowDesktopEdge].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::ShowDesktopEdge].value ().action ());

    // toggle_window_maximized_key
    mOptions[CoreOptions::ToggleWindowMaximizedKey].setName ("toggle_window_maximized_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::ToggleWindowMaximizedKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::ToggleWindowMaximizedKey].value ().action ());

    // toggle_window_maximized_button
    mOptions[CoreOptions::ToggleWindowMaximizedButton].setName ("toggle_window_maximized_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[CoreOptions::ToggleWindowMaximizedButton].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::ToggleWindowMaximizedButton].value ().action ());

    // toggle_window_maximized_horizontally_key
    mOptions[CoreOptions::ToggleWindowMaximizedHorizontallyKey].setName ("toggle_window_maximized_horizontally_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::ToggleWindowMaximizedHorizontallyKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::ToggleWindowMaximizedHorizontallyKey].value ().action ());

    // toggle_window_maximized_vertically_key
    mOptions[CoreOptions::ToggleWindowMaximizedVerticallyKey].setName ("toggle_window_maximized_vertically_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CoreOptions::ToggleWindowMaximizedVerticallyKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::ToggleWindowMaximizedVerticallyKey].value ().action ());

    // toggle_window_shaded_key
    mOptions[CoreOptions::ToggleWindowShadedKey].setName ("toggle_window_shaded_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>s");
    mOptions[CoreOptions::ToggleWindowShadedKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CoreOptions::ToggleWindowShadedKey].value ().action ());

    // hsize
    mOptions[CoreOptions::Hsize].setName ("hsize", CompOption::TypeInt);
    mOptions[CoreOptions::Hsize].rest ().set (1, 32);
    mOptions[CoreOptions::Hsize].value().set((int) 4);

    // vsize
    mOptions[CoreOptions::Vsize].setName ("vsize", CompOption::TypeInt);
    mOptions[CoreOptions::Vsize].rest ().set (1, 32);
    mOptions[CoreOptions::Vsize].value().set((int) 1);

}

CoreOptions::~CoreOptions ()
{
}


CompOption::Vector &
CoreOptions::getOptions ()
{
    return mOptions;
}

bool
CoreOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case CoreOptions::ActivePlugins:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ActivePlugins].empty ())
                    mNotify[CoreOptions::ActivePlugins] (o, CoreOptions::ActivePlugins);
                return true;
            }
            break;
        case CoreOptions::AudibleBell:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::AudibleBell].empty ())
                    mNotify[CoreOptions::AudibleBell] (o, CoreOptions::AudibleBell);
                return true;
            }
            break;
        case CoreOptions::IgnoreHintsWhenMaximized:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::IgnoreHintsWhenMaximized].empty ())
                    mNotify[CoreOptions::IgnoreHintsWhenMaximized] (o, CoreOptions::IgnoreHintsWhenMaximized);
                return true;
            }
            break;
        case CoreOptions::HideSkipTaskbarWindows:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::HideSkipTaskbarWindows].empty ())
                    mNotify[CoreOptions::HideSkipTaskbarWindows] (o, CoreOptions::HideSkipTaskbarWindows);
                return true;
            }
            break;
        case CoreOptions::EdgeDelay:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::EdgeDelay].empty ())
                    mNotify[CoreOptions::EdgeDelay] (o, CoreOptions::EdgeDelay);
                return true;
            }
            break;
        case CoreOptions::PingDelay:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::PingDelay].empty ())
                    mNotify[CoreOptions::PingDelay] (o, CoreOptions::PingDelay);
                return true;
            }
            break;
        case CoreOptions::DefaultIcon:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::DefaultIcon].empty ())
                    mNotify[CoreOptions::DefaultIcon] (o, CoreOptions::DefaultIcon);
                return true;
            }
            break;
        case CoreOptions::DoSerialize:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::DoSerialize].empty ())
                    mNotify[CoreOptions::DoSerialize] (o, CoreOptions::DoSerialize);
                return true;
            }
            break;
        case CoreOptions::OverlappingOutputs:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::OverlappingOutputs].empty ())
                    mNotify[CoreOptions::OverlappingOutputs] (o, CoreOptions::OverlappingOutputs);
                return true;
            }
            break;
        case CoreOptions::DetectOutputs:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::DetectOutputs].empty ())
                    mNotify[CoreOptions::DetectOutputs] (o, CoreOptions::DetectOutputs);
                return true;
            }
            break;
        case CoreOptions::Outputs:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::Outputs].empty ())
                    mNotify[CoreOptions::Outputs] (o, CoreOptions::Outputs);
                return true;
            }
            break;
        case CoreOptions::ClickToFocus:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ClickToFocus].empty ())
                    mNotify[CoreOptions::ClickToFocus] (o, CoreOptions::ClickToFocus);
                return true;
            }
            break;
        case CoreOptions::RaiseOnClick:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::RaiseOnClick].empty ())
                    mNotify[CoreOptions::RaiseOnClick] (o, CoreOptions::RaiseOnClick);
                return true;
            }
            break;
        case CoreOptions::Autoraise:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::Autoraise].empty ())
                    mNotify[CoreOptions::Autoraise] (o, CoreOptions::Autoraise);
                return true;
            }
            break;
        case CoreOptions::AutoraiseDelay:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::AutoraiseDelay].empty ())
                    mNotify[CoreOptions::AutoraiseDelay] (o, CoreOptions::AutoraiseDelay);
                return true;
            }
            break;
        case CoreOptions::FocusDesktop:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::FocusDesktop].empty ())
                    mNotify[CoreOptions::FocusDesktop] (o, CoreOptions::FocusDesktop);
                return true;
            }
            break;
        case CoreOptions::FocusPreventionLevel:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::FocusPreventionLevel].empty ())
                    mNotify[CoreOptions::FocusPreventionLevel] (o, CoreOptions::FocusPreventionLevel);
                return true;
            }
            break;
        case CoreOptions::FocusPreventionMatch:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::FocusPreventionMatch].empty ())
                    mNotify[CoreOptions::FocusPreventionMatch] (o, CoreOptions::FocusPreventionMatch);
                return true;
            }
            break;
        case CoreOptions::CloseWindowKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::CloseWindowKey].empty ())
                    mNotify[CoreOptions::CloseWindowKey] (o, CoreOptions::CloseWindowKey);
                return true;
            }
            break;
        case CoreOptions::CloseWindowButton:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::CloseWindowButton].empty ())
                    mNotify[CoreOptions::CloseWindowButton] (o, CoreOptions::CloseWindowButton);
                return true;
            }
            break;
        case CoreOptions::RaiseWindowKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::RaiseWindowKey].empty ())
                    mNotify[CoreOptions::RaiseWindowKey] (o, CoreOptions::RaiseWindowKey);
                return true;
            }
            break;
        case CoreOptions::RaiseWindowButton:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::RaiseWindowButton].empty ())
                    mNotify[CoreOptions::RaiseWindowButton] (o, CoreOptions::RaiseWindowButton);
                return true;
            }
            break;
        case CoreOptions::LowerWindowKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::LowerWindowKey].empty ())
                    mNotify[CoreOptions::LowerWindowKey] (o, CoreOptions::LowerWindowKey);
                return true;
            }
            break;
        case CoreOptions::LowerWindowButton:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::LowerWindowButton].empty ())
                    mNotify[CoreOptions::LowerWindowButton] (o, CoreOptions::LowerWindowButton);
                return true;
            }
            break;
        case CoreOptions::MinimizeWindowKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::MinimizeWindowKey].empty ())
                    mNotify[CoreOptions::MinimizeWindowKey] (o, CoreOptions::MinimizeWindowKey);
                return true;
            }
            break;
        case CoreOptions::MinimizeWindowButton:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::MinimizeWindowButton].empty ())
                    mNotify[CoreOptions::MinimizeWindowButton] (o, CoreOptions::MinimizeWindowButton);
                return true;
            }
            break;
        case CoreOptions::MaximizeWindowKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::MaximizeWindowKey].empty ())
                    mNotify[CoreOptions::MaximizeWindowKey] (o, CoreOptions::MaximizeWindowKey);
                return true;
            }
            break;
        case CoreOptions::UnmaximizeWindowKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::UnmaximizeWindowKey].empty ())
                    mNotify[CoreOptions::UnmaximizeWindowKey] (o, CoreOptions::UnmaximizeWindowKey);
                return true;
            }
            break;
        case CoreOptions::UnmaximizeOrMinimizeWindowKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::UnmaximizeOrMinimizeWindowKey].empty ())
                    mNotify[CoreOptions::UnmaximizeOrMinimizeWindowKey] (o, CoreOptions::UnmaximizeOrMinimizeWindowKey);
                return true;
            }
            break;
        case CoreOptions::MaximizeWindowHorizontallyKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::MaximizeWindowHorizontallyKey].empty ())
                    mNotify[CoreOptions::MaximizeWindowHorizontallyKey] (o, CoreOptions::MaximizeWindowHorizontallyKey);
                return true;
            }
            break;
        case CoreOptions::MaximizeWindowVerticallyKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::MaximizeWindowVerticallyKey].empty ())
                    mNotify[CoreOptions::MaximizeWindowVerticallyKey] (o, CoreOptions::MaximizeWindowVerticallyKey);
                return true;
            }
            break;
        case CoreOptions::WindowMenuKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::WindowMenuKey].empty ())
                    mNotify[CoreOptions::WindowMenuKey] (o, CoreOptions::WindowMenuKey);
                return true;
            }
            break;
        case CoreOptions::WindowMenuButton:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::WindowMenuButton].empty ())
                    mNotify[CoreOptions::WindowMenuButton] (o, CoreOptions::WindowMenuButton);
                return true;
            }
            break;
        case CoreOptions::ShowDesktopKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ShowDesktopKey].empty ())
                    mNotify[CoreOptions::ShowDesktopKey] (o, CoreOptions::ShowDesktopKey);
                return true;
            }
            break;
        case CoreOptions::ShowDesktopEdge:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ShowDesktopEdge].empty ())
                    mNotify[CoreOptions::ShowDesktopEdge] (o, CoreOptions::ShowDesktopEdge);
                return true;
            }
            break;
        case CoreOptions::ToggleWindowMaximizedKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ToggleWindowMaximizedKey].empty ())
                    mNotify[CoreOptions::ToggleWindowMaximizedKey] (o, CoreOptions::ToggleWindowMaximizedKey);
                return true;
            }
            break;
        case CoreOptions::ToggleWindowMaximizedButton:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ToggleWindowMaximizedButton].empty ())
                    mNotify[CoreOptions::ToggleWindowMaximizedButton] (o, CoreOptions::ToggleWindowMaximizedButton);
                return true;
            }
            break;
        case CoreOptions::ToggleWindowMaximizedHorizontallyKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ToggleWindowMaximizedHorizontallyKey].empty ())
                    mNotify[CoreOptions::ToggleWindowMaximizedHorizontallyKey] (o, CoreOptions::ToggleWindowMaximizedHorizontallyKey);
                return true;
            }
            break;
        case CoreOptions::ToggleWindowMaximizedVerticallyKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ToggleWindowMaximizedVerticallyKey].empty ())
                    mNotify[CoreOptions::ToggleWindowMaximizedVerticallyKey] (o, CoreOptions::ToggleWindowMaximizedVerticallyKey);
                return true;
            }
            break;
        case CoreOptions::ToggleWindowShadedKey:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::ToggleWindowShadedKey].empty ())
                    mNotify[CoreOptions::ToggleWindowShadedKey] (o, CoreOptions::ToggleWindowShadedKey);
                return true;
            }
            break;
        case CoreOptions::Hsize:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::Hsize].empty ())
                    mNotify[CoreOptions::Hsize] (o, CoreOptions::Hsize);
                return true;
            }
            break;
        case CoreOptions::Vsize:
            if (o->set (value))
            {
                if (!mNotify[CoreOptions::Vsize].empty ())
                    mNotify[CoreOptions::Vsize] (o, CoreOptions::Vsize);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

