/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.asm.optimizer;

import java.util.HashMap;
import net.sf.cglib.asm.Handle;
import net.sf.cglib.asm.Type;
import net.sf.cglib.asm.optimizer.Constant;

public class ConstantPool
extends HashMap {
    private final Constant key1 = new Constant();
    private final Constant key2 = new Constant();
    private final Constant key3 = new Constant();
    private final Constant key4 = new Constant();
    private final Constant key5 = new Constant();

    public Constant newInteger(int n) {
        this.key1.set(n);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newFloat(float f) {
        this.key1.set(f);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newLong(long l) {
        this.key1.set(l);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newDouble(double d) {
        this.key1.set(d);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newUTF8(String string) {
        this.key1.set('s', string, null, null);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    private Constant newString(String string) {
        this.key2.set('S', string, null, null);
        Constant constant = this.get(this.key2);
        if (constant == null) {
            this.newUTF8(string);
            constant = new Constant(this.key2);
            this.put(constant);
        }
        return constant;
    }

    public Constant newClass(String string) {
        this.key2.set('C', string, null, null);
        Constant constant = this.get(this.key2);
        if (constant == null) {
            this.newUTF8(string);
            constant = new Constant(this.key2);
            this.put(constant);
        }
        return constant;
    }

    public Constant newMethodType(String string) {
        this.key2.set('t', string, null, null);
        Constant constant = this.get(this.key2);
        if (constant == null) {
            this.newUTF8(string);
            constant = new Constant(this.key2);
            this.put(constant);
        }
        return constant;
    }

    public Constant newHandle(int n, String string, String string2, String string3) {
        this.key4.set((char)(103 + n), string, string2, string3);
        Constant constant = this.get(this.key4);
        if (constant == null) {
            if (n <= 4) {
                this.newField(string, string2, string3);
            } else {
                this.newMethod(string, string2, string3, n == 9);
            }
            constant = new Constant(this.key4);
            this.put(constant);
        }
        return constant;
    }

    public Constant newConst(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.newInteger(n);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            return this.newFloat(f);
        }
        if (object instanceof Long) {
            long l = (Long)object;
            return this.newLong(l);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return this.newDouble(d);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            int n = type.getSort();
            if (n == 10) {
                return this.newClass(type.getInternalName());
            }
            if (n == 11) {
                return this.newMethodType(type.getDescriptor());
            }
            return this.newClass(type.getDescriptor());
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return this.newHandle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc());
        }
        throw new IllegalArgumentException("value " + object);
    }

    public Constant newField(String string, String string2, String string3) {
        this.key3.set('G', string, string2, string3);
        Constant constant = this.get(this.key3);
        if (constant == null) {
            this.newClass(string);
            this.newNameType(string2, string3);
            constant = new Constant(this.key3);
            this.put(constant);
        }
        return constant;
    }

    public Constant newMethod(String string, String string2, String string3, boolean bl) {
        this.key3.set(bl ? (char)'N' : 'M', string, string2, string3);
        Constant constant = this.get(this.key3);
        if (constant == null) {
            this.newClass(string);
            this.newNameType(string2, string3);
            constant = new Constant(this.key3);
            this.put(constant);
        }
        return constant;
    }

    public Constant newInvokeDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        this.key5.set(string, string2, handle, objectArray);
        Constant constant = this.get(this.key5);
        if (constant == null) {
            this.newNameType(string, string2);
            this.newHandle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc());
            for (int i = 0; i < objectArray.length; ++i) {
                this.newConst(objectArray[i]);
            }
            constant = new Constant(this.key5);
            this.put(constant);
        }
        return constant;
    }

    public Constant newNameType(String string, String string2) {
        this.key2.set('T', string, string2, null);
        Constant constant = this.get(this.key2);
        if (constant == null) {
            this.newUTF8(string);
            this.newUTF8(string2);
            constant = new Constant(this.key2);
            this.put(constant);
        }
        return constant;
    }

    private Constant get(Constant constant) {
        return (Constant)this.get((Object)constant);
    }

    private void put(Constant constant) {
        this.put(constant, constant);
    }
}

