/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.special.Gamma;

public class TDistributionImpl
extends AbstractContinuousDistribution
implements TDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -5852615386664158222L;
    private double degreesOfFreedom;
    private final double solverAbsoluteAccuracy;

    public TDistributionImpl(double d, double d2) {
        this.setDegreesOfFreedomInternal(d);
        this.solverAbsoluteAccuracy = d2;
    }

    public TDistributionImpl(double d) {
        this(d, 1.0E-9);
    }

    @Override
    @Deprecated
    public void setDegreesOfFreedom(double d) {
        this.setDegreesOfFreedomInternal(d);
    }

    private void setDegreesOfFreedomInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("degrees of freedom must be positive ({0})", d);
        }
        this.degreesOfFreedom = d;
    }

    @Override
    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double density(double d) {
        double d2 = this.degreesOfFreedom;
        double d3 = (d2 + 1.0) / 2.0;
        return Math.exp(Gamma.logGamma(d3) - 0.5 * (Math.log(Math.PI) + Math.log(d2)) - Gamma.logGamma(d2 / 2.0) - d3 * Math.log(1.0 + d * d / d2));
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        double d2;
        if (d == 0.0) {
            d2 = 0.5;
        } else {
            double d3 = Beta.regularizedBeta(this.degreesOfFreedom / (this.degreesOfFreedom + d * d), 0.5 * this.degreesOfFreedom, 0.5);
            d2 = d < 0.0 ? 0.5 * d3 : 1.0 - 0.5 * d3;
        }
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(d);
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return -1.7976931348623157E308;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        return Double.MAX_VALUE;
    }

    @Override
    protected double getInitialDomain(double d) {
        return 0.0;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

