/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.HypergeometricDistribution;
import org.apache.commons.math.distribution.SaddlePointExpansion;
import org.apache.commons.math.util.MathUtils;

public class HypergeometricDistributionImpl
extends AbstractIntegerDistribution
implements HypergeometricDistribution,
Serializable {
    private static final long serialVersionUID = -436928820673516179L;
    private int numberOfSuccesses;
    private int populationSize;
    private int sampleSize;

    public HypergeometricDistributionImpl(int n, int n2, int n3) {
        if (n2 > n) {
            throw MathRuntimeException.createIllegalArgumentException("number of successes ({0}) must be less than or equal to population size ({1})", n2, n);
        }
        if (n3 > n) {
            throw MathRuntimeException.createIllegalArgumentException("sample size ({0}) must be less than or equal to population size ({1})", n3, n);
        }
        this.setPopulationSizeInternal(n);
        this.setSampleSizeInternal(n3);
        this.setNumberOfSuccessesInternal(n2);
    }

    @Override
    public double cumulativeProbability(int n) {
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double d = n < nArray[0] ? 0.0 : (n >= nArray[1] ? 1.0 : this.innerCumulativeProbability(nArray[0], n, 1, this.populationSize, this.numberOfSuccesses, this.sampleSize));
        return d;
    }

    private int[] getDomain(int n, int n2, int n3) {
        return new int[]{this.getLowerDomain(n, n2, n3), this.getUpperDomain(n2, n3)};
    }

    @Override
    protected int getDomainLowerBound(double d) {
        return this.getLowerDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
    }

    @Override
    protected int getDomainUpperBound(double d) {
        return this.getUpperDomain(this.sampleSize, this.numberOfSuccesses);
    }

    private int getLowerDomain(int n, int n2, int n3) {
        return Math.max(0, n2 - (n - n3));
    }

    @Override
    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    @Override
    public int getPopulationSize() {
        return this.populationSize;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int n, int n2) {
        return Math.min(n2, n);
    }

    @Override
    public double probability(int n) {
        double d;
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        if (n < nArray[0] || n > nArray[1]) {
            d = 0.0;
        } else {
            double d2 = (double)this.sampleSize / (double)this.populationSize;
            double d3 = (double)(this.populationSize - this.sampleSize) / (double)this.populationSize;
            double d4 = SaddlePointExpansion.logBinomialProbability(n, this.numberOfSuccesses, d2, d3);
            double d5 = SaddlePointExpansion.logBinomialProbability(this.sampleSize - n, this.populationSize - this.numberOfSuccesses, d2, d3);
            double d6 = SaddlePointExpansion.logBinomialProbability(this.sampleSize, this.populationSize, d2, d3);
            d = Math.exp(d4 + d5 - d6);
        }
        return d;
    }

    private double probability(int n, int n2, int n3, int n4) {
        return Math.exp(MathUtils.binomialCoefficientLog(n2, n4) + MathUtils.binomialCoefficientLog(n - n2, n3 - n4) - MathUtils.binomialCoefficientLog(n, n3));
    }

    @Override
    @Deprecated
    public void setNumberOfSuccesses(int n) {
        this.setNumberOfSuccessesInternal(n);
    }

    private void setNumberOfSuccessesInternal(int n) {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("number of successes must be non-negative ({0})", n);
        }
        this.numberOfSuccesses = n;
    }

    @Override
    @Deprecated
    public void setPopulationSize(int n) {
        this.setPopulationSizeInternal(n);
    }

    private void setPopulationSizeInternal(int n) {
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("population size must be positive ({0})", n);
        }
        this.populationSize = n;
    }

    @Override
    @Deprecated
    public void setSampleSize(int n) {
        this.setSampleSizeInternal(n);
    }

    private void setSampleSizeInternal(int n) {
        if (n < 0) {
            throw MathRuntimeException.createIllegalArgumentException("sample size must be positive ({0})", n);
        }
        this.sampleSize = n;
    }

    public double upperCumulativeProbability(int n) {
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double d = n < nArray[0] ? 1.0 : (n > nArray[1] ? 0.0 : this.innerCumulativeProbability(nArray[1], n, -1, this.populationSize, this.numberOfSuccesses, this.sampleSize));
        return d;
    }

    private double innerCumulativeProbability(int n, int n2, int n3, int n4, int n5, int n6) {
        double d = this.probability(n4, n5, n6, n);
        while (n != n2) {
            d += this.probability(n4, n5, n6, n += n3);
        }
        return d;
    }
}

