/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.special.Gamma;

public class GammaDistributionImpl
extends AbstractContinuousDistribution
implements GammaDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -3239549463135430361L;
    private double alpha;
    private double beta;
    private final double solverAbsoluteAccuracy;

    public GammaDistributionImpl(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public GammaDistributionImpl(double d, double d2, double d3) {
        this.setAlphaInternal(d);
        this.setBetaInternal(d2);
        this.solverAbsoluteAccuracy = d3;
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        double d2 = d <= 0.0 ? 0.0 : Gamma.regularizedGammaP(this.alpha, d / this.beta);
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(d);
    }

    @Override
    @Deprecated
    public void setAlpha(double d) {
        this.setAlphaInternal(d);
    }

    private void setAlphaInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("alpha must be positive ({0})", d);
        }
        this.alpha = d;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    @Deprecated
    public void setBeta(double d) {
        this.setBetaInternal(d);
    }

    private void setBetaInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("beta must be positive ({0})", d);
        }
        this.beta = d;
    }

    @Override
    public double getBeta() {
        return this.beta;
    }

    @Override
    public double density(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return Math.pow(d / this.beta, this.alpha - 1.0) / this.beta * Math.exp(-d / this.beta) / Math.exp(Gamma.logGamma(this.alpha));
    }

    @Override
    @Deprecated
    public double density(Double d) {
        return this.density((double)d);
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return Double.MIN_VALUE;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        double d2 = d < 0.5 ? this.alpha * this.beta : Double.MAX_VALUE;
        return d2;
    }

    @Override
    protected double getInitialDomain(double d) {
        double d2 = d < 0.5 ? this.alpha * this.beta * 0.5 : this.alpha * this.beta;
        return d2;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

