/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MathException
extends Exception {
    private static final long serialVersionUID = -9004610152740737812L;
    private final String pattern;
    private final Object[] arguments;

    public MathException() {
        this.pattern = null;
        this.arguments = new Object[0];
    }

    public MathException(String string, Object ... objectArray) {
        this.pattern = string;
        this.arguments = objectArray == null ? new Object[]{} : (Object[])objectArray.clone();
    }

    public MathException(Throwable throwable) {
        super(throwable);
        this.pattern = this.getMessage();
        this.arguments = new Object[0];
    }

    public MathException(Throwable throwable, String string, Object ... objectArray) {
        super(throwable);
        this.pattern = string;
        this.arguments = objectArray == null ? new Object[]{} : (Object[])objectArray.clone();
    }

    private static String translate(String string, Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.commons.math.MessagesResources", locale);
            if (resourceBundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                return resourceBundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        return this.pattern == null ? "" : new MessageFormat(MathException.translate(this.pattern, locale), locale).format(this.arguments);
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            PrintWriter printWriter = new PrintWriter(printStream, false);
            this.printStackTrace(printWriter);
            printWriter.flush();
        }
    }
}

