/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math;

import org.apache.commons.math.ConvergingAlgorithm;

public abstract class ConvergingAlgorithmImpl
implements ConvergingAlgorithm {
    protected double absoluteAccuracy;
    protected double relativeAccuracy;
    protected int maximalIterationCount;
    protected double defaultAbsoluteAccuracy;
    protected double defaultRelativeAccuracy;
    protected int defaultMaximalIterationCount;
    protected int iterationCount;

    protected ConvergingAlgorithmImpl(int n, double d) {
        this.defaultAbsoluteAccuracy = d;
        this.defaultRelativeAccuracy = 1.0E-14;
        this.absoluteAccuracy = d;
        this.relativeAccuracy = this.defaultRelativeAccuracy;
        this.defaultMaximalIterationCount = n;
        this.maximalIterationCount = n;
        this.iterationCount = 0;
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public void setAbsoluteAccuracy(double d) {
        this.absoluteAccuracy = d;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public void resetAbsoluteAccuracy() {
        this.absoluteAccuracy = this.defaultAbsoluteAccuracy;
    }

    @Override
    public void setMaximalIterationCount(int n) {
        this.maximalIterationCount = n;
    }

    @Override
    public int getMaximalIterationCount() {
        return this.maximalIterationCount;
    }

    @Override
    public void resetMaximalIterationCount() {
        this.maximalIterationCount = this.defaultMaximalIterationCount;
    }

    @Override
    public void setRelativeAccuracy(double d) {
        this.relativeAccuracy = d;
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public void resetRelativeAccuracy() {
        this.relativeAccuracy = this.defaultRelativeAccuracy;
    }
}

