/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.core.Description;
import beast.util.PackageVersion;

@Description(value="BEAUti beastObject dependency class")
public class PackageDependency {
    public final String dependencyName;
    public final PackageVersion atLeast;
    public final PackageVersion atMost;

    public PackageDependency(String string, PackageVersion packageVersion, PackageVersion packageVersion2) {
        if (string.equals("beast2")) {
            string = "BEAST";
        }
        this.dependencyName = string;
        this.atLeast = packageVersion;
        this.atMost = packageVersion2;
    }

    public boolean isMetBy(PackageVersion packageVersion) {
        return !(this.atLeast != null && packageVersion.compareTo(this.atLeast) < 0 || this.atMost != null && packageVersion.compareTo(this.atMost) > 0);
    }

    public String getRangeString() {
        if (this.atLeast != null && this.atMost != null) {
            return "versions " + this.atLeast + " to " + this.atMost;
        }
        if (this.atLeast != null) {
            return "version " + this.atLeast + " or greater";
        }
        return "version " + this.atMost + " or lesser";
    }

    public String toString() {
        return this.dependencyName + " " + this.getRangeString();
    }
}

