/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.app.BEASTVersion2;
import beast.app.beastapp.BeastMain;
import beast.app.util.Arguments;
import beast.app.util.Utils;
import beast.core.BEASTInterface;
import beast.core.Description;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.util.Package;
import beast.util.PackageDependency;
import beast.util.PackageVersion;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Description(value="Manage all BEAUti packages and list their dependencies")
public class AddOnManager {
    public static final BEASTVersion2 beastVersion = new BEASTVersion2();
    public static final String[] IMPLEMENTATION_DIR = new String[]{"beast", "snap"};
    public static final String TO_DELETE_LIST_FILE = "toDeleteList";
    public static final String TO_INSTALL_LIST_FILE = "toInstallList";
    public static final String BEAST_PACKAGE_NAME = "BEAST";
    public static final String PACKAGES_XML = "https://raw.githubusercontent.com/CompEvol/CBAN/master/packages.xml";
    public static final String ARCHIVE_DIR = "archive";
    static boolean useArchive = false;
    public static final String INSTALLED = "installed";
    public static final String NOT_INSTALLED = "not installed";
    public static final String NO_CONNECTION_MESSAGE = "Could not get an internet connection. The BEAST Package Manager needs internet access in order to list available packages and download them for installation. Possibly, some software (like security software, or a firewall) blocks the BEAST Package Manager.  If so, you need to reconfigure such software to allow access.";
    static boolean externalJarsLoaded = false;
    private static List<String> all_classes;
    private static Map<String, String> classToPackageMap;
    private static TreeMap<String, Package> packages;

    public static void useArchive(boolean bl) {
        useArchive = bl;
    }

    public static List<URL> getRepositoryURLs() throws MalformedURLException {
        System.setProperty("jsse.enableSNIExtension", "false");
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(new URL(PACKAGES_XML));
        String string = Utils.getBeautiProperty("packages.url");
        if (string != null) {
            for (String string2 : string.split(",")) {
                arrayList.add(new URL(string2));
            }
        }
        return arrayList;
    }

    public static void saveRepositoryURLs(List<URL> list) {
        if (list.size() < 1) {
            return;
        }
        if (list.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 1; i < list.size(); ++i) {
                if (i > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(list.get(i));
            }
            Utils.saveBeautiProperty("packages.url", stringBuilder.toString());
        } else {
            Utils.saveBeautiProperty("packages.url", null);
        }
    }

    public static void addInstalledPackages(Map<String, Package> map) {
        Object object;
        Serializable serializable;
        for (String object2 : AddOnManager.getBeastDirectories()) {
            serializable = new File(object2 + "/version.xml");
            if (!serializable.exists()) continue;
            try {
                Package package_;
                DocumentBuilderFactory exception = DocumentBuilderFactory.newInstance();
                Document document = exception.newDocumentBuilder().parse((File)serializable);
                document.normalize();
                Element element = document.getDocumentElement();
                String string = element.getAttribute("name");
                String string2 = element.getAttribute("version");
                if (map.containsKey(string)) {
                    package_ = map.get(string);
                } else {
                    package_ = new Package(string);
                    map.put(string, package_);
                }
                if (element.hasAttribute("projectURL")) {
                    package_.setProjectURL(new URL(element.getAttribute("projectURL")));
                }
                PackageVersion packageVersion = new PackageVersion(string2);
                if (element.hasAttribute("projectURL") && (package_.getLatestVersion() == null || packageVersion.compareTo(package_.getLatestVersion()) >= 0)) {
                    package_.setProjectURL(new URL(element.getAttribute("projectURL")));
                }
                TreeSet<PackageDependency> treeSet = new TreeSet<PackageDependency>((packageDependency, packageDependency2) -> packageDependency.dependencyName.compareTo(packageDependency2.dependencyName));
                NodeList nodeList = document.getElementsByTagName("depends");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    String string3 = element2.getAttribute("on");
                    String string4 = element2.getAttribute("atleast");
                    String string5 = element2.getAttribute("atmost");
                    PackageDependency packageDependency3 = new PackageDependency(string3, string4.isEmpty() ? null : new PackageVersion(string4), string5.isEmpty() ? null : new PackageVersion(string5));
                    treeSet.add(packageDependency3);
                }
                package_.setInstalled(packageVersion, treeSet);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                exception.printStackTrace();
            }
        }
        if (map.containsKey(BEAST_PACKAGE_NAME)) {
            object = map.get(BEAST_PACKAGE_NAME);
        } else {
            object = new Package(BEAST_PACKAGE_NAME);
            map.put(BEAST_PACKAGE_NAME, (Package)object);
        }
        if (!((Package)object).isInstalled()) {
            PackageVersion packageVersion = new PackageVersion(beastVersion.getVersion());
            serializable = new TreeSet();
            ((Package)object).setInstalled(packageVersion, (Set<PackageDependency>)((Object)serializable));
        }
    }

    public static void addAvailablePackages(Map<String, Package> map) throws PackageListRetrievalException {
        List<URL> list;
        try {
            list = AddOnManager.getRepositoryURLs();
        }
        catch (MalformedURLException malformedURLException) {
            throw new PackageListRetrievalException("Error parsing one or more repository URLs.", malformedURLException);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Exception exception = null;
        for (URL object : list) {
            try {
                Object exception2 = object.openStream();
                Throwable throwable = null;
                try {
                    DocumentBuilderFactory throwable3 = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = throwable3.newDocumentBuilder();
                    Document document = documentBuilder.parse(new InputSource((InputStream)exception2));
                    Element element = document.getDocumentElement();
                    NodeList nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Package package_;
                        Node node = nodeList.item(i);
                        if (!(node instanceof Element)) continue;
                        Element element2 = (Element)node;
                        String string = element2.getAttribute("name");
                        if (map.containsKey(string)) {
                            package_ = map.get(string);
                        } else {
                            package_ = new Package(string);
                            map.put(string, package_);
                        }
                        package_.setDescription(element2.getAttribute("description"));
                        PackageVersion packageVersion = new PackageVersion(element2.getAttribute("version"));
                        if (element2.hasAttribute("projectURL") && (package_.getLatestVersion() == null || packageVersion.compareTo(package_.getLatestVersion()) >= 0)) {
                            package_.setProjectURL(new URL(element2.getAttribute("projectURL")));
                        }
                        HashSet<PackageDependency> hashSet = new HashSet<PackageDependency>();
                        NodeList nodeList2 = element2.getElementsByTagName("depends");
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Element element3 = (Element)nodeList2.item(j);
                            String string2 = element3.getAttribute("on");
                            String string3 = element3.getAttribute("atleast");
                            String string4 = element3.getAttribute("atmost");
                            PackageDependency packageDependency = new PackageDependency(string2, string3.isEmpty() ? null : new PackageVersion(string3), string4.isEmpty() ? null : new PackageVersion(string4));
                            hashSet.add(packageDependency);
                        }
                        URL j = new URL(element2.getAttribute("url"));
                        package_.addAvailableVersion(packageVersion, j, hashSet);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (exception2 == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)exception2).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    ((InputStream)exception2).close();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception2) {
                if (arrayList.isEmpty()) {
                    exception = exception2;
                }
                arrayList.add(object);
            }
        }
        if (!arrayList.isEmpty()) {
            Object object = "Error reading the following package repository URLs:";
            for (Object exception2 : arrayList) {
                object = (String)object + " " + exception2;
            }
            throw new PackageListRetrievalException((String)object, exception);
        }
    }

    public static void prepareForInstall(Map<Package, PackageVersion> map, boolean bl, String string) throws IOException {
        if (useArchive) {
            return;
        }
        HashMap<Package, PackageVersion> hashMap = new HashMap<Package, PackageVersion>(map);
        for (Map.Entry object : hashMap.entrySet()) {
            Package throwable = (Package)object.getKey();
            PackageVersion packageVersion = (PackageVersion)object.getValue();
            if (!throwable.isInstalled()) continue;
            if (throwable.getInstalledVersion().equals(packageVersion)) {
                map.remove(throwable);
                continue;
            }
            AddOnManager.uninstallPackage(throwable, bl, string);
        }
        if (AddOnManager.getToDeleteListFile().exists()) {
            try {
                Throwable throwable = null;
                try (PrintStream printStream = new PrintStream(AddOnManager.getToInstallListFile());){
                    for (Map.Entry entry : map.entrySet()) {
                        printStream.println(entry.getKey() + ":" + entry.getValue());
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException iOException) {
                AddOnManager.message("Error writing to-install file: " + iOException.getMessage() + " Installation may not resume successfully after restart.");
            }
        }
    }

    public static Map<String, String> installPackages(Map<Package, PackageVersion> map, boolean bl, String string) throws IOException {
        AddOnManager.closeClassLoader();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Package, PackageVersion> entry : map.entrySet()) {
            Package package_ = entry.getKey();
            PackageVersion packageVersion = entry.getValue();
            URL uRL = package_.getVersionURL(packageVersion);
            ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
            String string2 = AddOnManager.getPackageDir(package_, packageVersion, bl, string);
            File file = new File(string2);
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Could not create directory " + string2);
            }
            String string3 = string2 + "/" + package_.getName() + ".zip";
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, 0x1000000L);
            AddOnManager.doUnzip(string3, string2);
            fileOutputStream.close();
            hashMap.put(package_.getName(), string2);
        }
        return hashMap;
    }

    private static String getPackageDir(Package package_, PackageVersion packageVersion, boolean bl, String string) {
        String string2 = (bl ? AddOnManager.getPackageSystemDir() : AddOnManager.getPackageUserDir()) + (useArchive ? "/archive" : "") + "/" + package_.getName() + (useArchive ? "/" + packageVersion.versionString : "");
        if (string != null) {
            string2 = string + (useArchive ? "/archive" : "") + "/" + package_.getName() + (useArchive ? "/" + packageVersion.versionString : "");
        }
        return string2;
    }

    public static List<String> getInstalledDependencyNames(Package package_, Map<String, Package> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Package package_2 : map.values()) {
            if (package_2.equals(package_) || !package_2.isInstalled()) continue;
            for (PackageDependency packageDependency : package_2.getInstalledVersionDependencies()) {
                if (!packageDependency.dependencyName.equals(package_.getName())) continue;
                arrayList.add(package_2.getName());
            }
        }
        return arrayList;
    }

    public static String uninstallPackage(Package package_, boolean bl, String string) throws IOException {
        return AddOnManager.uninstallPackage(package_, null, bl, string);
    }

    public static String uninstallPackage(Package package_, PackageVersion packageVersion, boolean bl, String string) throws IOException {
        File file;
        String string2;
        File file2;
        AddOnManager.closeClassLoader();
        if (packageVersion == null) {
            packageVersion = package_.getInstalledVersion();
        }
        if (!(file2 = new File(string2 = AddOnManager.getPackageDir(package_, packageVersion, bl, string))).exists()) {
            useArchive = !useArchive;
            string2 = AddOnManager.getPackageDir(package_, packageVersion, bl, string);
            file2 = new File(string2);
            useArchive = !useArchive;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        AddOnManager.deleteRecursively(file2, arrayList);
        if (useArchive && (file = file2.getParentFile()).list().length == 0) {
            file.delete();
        }
        if (arrayList.size() > 0) {
            file = AddOnManager.getToDeleteListFile();
            FileWriter fileWriter = new FileWriter(file, true);
            for (File file3 : arrayList) {
                fileWriter.write(file3.getAbsolutePath() + "\n");
            }
            fileWriter.close();
        }
        return string2;
    }

    private static void closeClassLoader() {
        try {
            if (Utils.isWindows()) {
                URLClassLoader uRLClassLoader = (URLClassLoader)AddOnManager.class.getClassLoader();
                uRLClassLoader.close();
            }
        }
        catch (IOException iOException) {
            Log.warning.println("Could not close ClassLoader: " + iOException.getMessage());
        }
    }

    private static void deleteRecursively(File file, List<File> list) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                AddOnManager.deleteRecursively(file2, list);
            }
        }
        if (!file.delete()) {
            list.add(file);
        }
    }

    public static void doUnzip(String string, String string2) throws IOException {
        int n = 2048;
        File file = new File(string);
        File file2 = new File(string2);
        ZipFile zipFile = new ZipFile(file, 1);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            File file3 = new File(file2 + "/" + string3);
            File file4 = file3.getParentFile();
            file4.mkdirs();
            try {
                int n2;
                if (zipEntry.isDirectory()) continue;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byte[] byArray = new byte[n];
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, n);
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        zipFile.close();
    }

    public static String getPackageUserDir() {
        if (System.getProperty("beast.user.package.dir") != null) {
            return System.getProperty("beast.user.package.dir");
        }
        if (Utils.isWindows()) {
            return System.getProperty("user.home") + "\\BEAST\\" + beastVersion.getMajorVersion();
        }
        if (Utils.isMac()) {
            return System.getProperty("user.home") + "/Library/Application Support/BEAST/" + beastVersion.getMajorVersion();
        }
        return System.getProperty("user.home") + "/.beast/" + beastVersion.getMajorVersion();
    }

    public static String getPackageSystemDir() {
        if (System.getProperty("beast.system.package.dir") != null) {
            return System.getProperty("beast.system.package.dir");
        }
        if (Utils.isWindows()) {
            return "\\Program Files\\BEAST\\" + beastVersion.getMajorVersion();
        }
        if (Utils.isMac()) {
            return "/Library/Application Support/BEAST/" + beastVersion.getMajorVersion();
        }
        return "/usr/local/share/beast/" + beastVersion.getMajorVersion();
    }

    public static String getBEASTInstallDir() {
        if (System.getProperty("beast.install.dir") != null) {
            return System.getProperty("beast.install.dir");
        }
        URL uRL = BeastMain.class.getProtectionDomain().getCodeSource().getLocation();
        String string = uRL.getPath();
        File file = new File(string);
        Log.trace.println("BeastMain found in " + file.getPath());
        if (!file.getName().toLowerCase().endsWith(".jar")) {
            return null;
        }
        if (file.getParentFile() != null) {
            return file.getParentFile().getParent();
        }
        return null;
    }

    public static File getToDeleteListFile() {
        return new File(AddOnManager.getPackageUserDir() + "/" + TO_DELETE_LIST_FILE);
    }

    private static void processDeleteList() {
        File file = AddOnManager.getToDeleteListFile();
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while (bufferedReader.ready()) {
                    String string = bufferedReader.readLine();
                    File file2 = new File(string);
                    file2.delete();
                }
                bufferedReader.close();
                file.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static File getToInstallListFile() {
        return new File(AddOnManager.getPackageUserDir() + "/" + TO_INSTALL_LIST_FILE);
    }

    private static void processInstallList(Map<String, Package> map) {
        File file = AddOnManager.getToInstallListFile();
        if (file.exists()) {
            try {
                AddOnManager.addAvailablePackages(map);
            }
            catch (PackageListRetrievalException packageListRetrievalException) {
                AddOnManager.message("Failed to resume package installation due to package list retrieval error: " + packageListRetrievalException.getMessage());
                file.delete();
                return;
            }
            HashMap<Package, PackageVersion> hashMap = new HashMap<Package, PackageVersion>();
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":");
                    Package package_ = map.get(stringArray[0]);
                    PackageVersion packageVersion = new PackageVersion(stringArray[1]);
                    hashMap.put(package_, packageVersion);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                AddOnManager.installPackages(hashMap, false, null);
            }
            catch (IOException iOException) {
                AddOnManager.message("Failed to install packages due to I/O error: " + iOException.getMessage());
            }
            file.delete();
        }
    }

    public static List<String> getBeastDirectories() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (System.getProperty("BEAST_ADDON_PATH") != null) {
            string = System.getProperty("BEAST_ADDON_PATH");
            for (String string2 : string.split(":")) {
                arrayList.add(string2);
            }
        }
        if (System.getenv("BEAST_ADDON_PATH") != null) {
            string = System.getenv("BEAST_ADDON_PATH");
            for (String string2 : string.split(":")) {
                arrayList.add(string2);
            }
        }
        arrayList.add(AddOnManager.getPackageUserDir());
        arrayList.add(AddOnManager.getPackageSystemDir());
        if (AddOnManager.getBEASTInstallDir() != null) {
            arrayList.add(AddOnManager.getBEASTInstallDir());
        }
        string = System.getProperty("java.class.path");
        String[] stringArray = string.split(":");
        for (String string2 : stringArray) {
            String string3;
            String string4;
            String string5;
            if (string2.endsWith(".jar") || !(string5 = string2.replaceAll("\\\\", "/")).contains("/") || arrayList.contains(string4 = (string3 = string5.substring(0, string5.lastIndexOf("/"))).replaceAll("/[^/]*/Contents/Java", "")) || string4.contains("production")) continue;
            arrayList.add(string4);
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string3 : arrayList) {
            File[] fileArray;
            File file = new File(string3);
            if (!file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
            for (File file2 : fileArray) {
                File file3;
                if (!file2.isDirectory() || !(file3 = new File(file2, "version.xml")).exists()) continue;
                arrayList2.add(file2.getAbsolutePath());
            }
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(AddOnManager.getLatestBeastArchiveDirectories(arrayList));
        return arrayList;
    }

    private static List<String> getLatestBeastArchiveDirectories(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = "/";
        String string4 = AddOnManager.getPackageUserDir() + string3 + ARCHIVE_DIR;
        File file = new File(string4);
        if (file.exists()) {
            File file2;
            String string5;
            int n;
            HashSet<String> hashSet = new HashSet<String>();
            for (String string52 : list) {
                File file3 = new File(string52);
                if (!file3.isDirectory()) continue;
                File file4 = new File(file3 + "/version.xml");
                if (file4.exists()) {
                    try {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        Document document = documentBuilderFactory.newDocumentBuilder().parse(file4);
                        Element element = document.getDocumentElement();
                        hashSet.add(element.getAttribute("name"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                hashSet.add(file3.getName());
                String[] stringArray = file3.list();
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    File file5;
                    string5 = stringArray[n];
                    file2 = new File(string5);
                    if (!file2.isDirectory() || !(file5 = new File(file2 + "/version.xml")).exists()) continue;
                    try {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        Document document = documentBuilderFactory.newDocumentBuilder().parse(file5);
                        Element element = document.getDocumentElement();
                        hashSet.add(element.getAttribute("name"));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            block6: for (String string6 : file.list()) {
                File file6 = new File(string4 + string3 + string6);
                if (!file6.isDirectory()) continue;
                String[] stringArray = file6.list();
                Arrays.sort(stringArray, (string, string2) -> {
                    PackageVersion packageVersion = new PackageVersion((String)string);
                    PackageVersion packageVersion2 = new PackageVersion((String)string2);
                    return packageVersion.compareTo(packageVersion2);
                });
                for (n = stringArray.length - 1; n >= 0; --n) {
                    string5 = stringArray[n];
                    file2 = new File(file6.getPath() + string3 + string5);
                    if (!file2.exists() || !new File(file2.getPath() + string3 + "version.xml").exists()) continue;
                    if (hashSet.contains(string6)) continue block6;
                    arrayList.add(file2.getPath());
                    continue block6;
                }
            }
        }
        return arrayList;
    }

    public static void loadExternalJars() throws IOException {
        AddOnManager.processDeleteList();
        AddOnManager.addInstalledPackages(packages);
        AddOnManager.processInstallList(packages);
        AddOnManager.checkInstalledDependencies(packages);
        for (String string : AddOnManager.getBeastDirectories()) {
            AddOnManager.loadPacakge(string);
        }
        externalJarsLoaded = true;
        Alignment.findDataTypes();
    }

    public static void loadExternalJars(String string) throws IOException {
        AddOnManager.processDeleteList();
        AddOnManager.addInstalledPackages(packages);
        AddOnManager.processInstallList(packages);
        if (string != null && string.trim().length() > 0) {
            String[] stringArray;
            String string2 = "";
            for (String string3 : stringArray = string.split(":")) {
                int n = (string3 = string3.trim()).lastIndexOf(" ");
                if (n <= 0) continue;
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1).trim().replaceAll("v", "");
                Package package_ = new Package(string4);
                PackageVersion packageVersion = new PackageVersion(string5);
                useArchive = true;
                String string6 = AddOnManager.getPackageDir(package_, packageVersion, false, System.getProperty("BEAST_ADDON_PATH"));
                if (new File(string6).exists()) {
                    AddOnManager.loadPacakge(string6);
                    continue;
                }
                Package package_2 = packages.get(string4);
                if (package_2 == null || !package_2.isInstalled() || !package_2.getInstalledVersion().equals(packageVersion)) {
                    string2 = string2 + string3 + ", ";
                    continue;
                }
                useArchive = false;
                string6 = AddOnManager.getPackageDir(package_, packageVersion, false, System.getProperty("BEAST_ADDON_PATH"));
                if (new File(string6).exists()) {
                    AddOnManager.loadPacakge(string6);
                    continue;
                }
                string2 = string2 + string3 + ", ";
            }
            if (string2.length() > 1) {
                if ((string2 = string2.substring(0, string2.length() - 2)).contains(",")) {
                    Log.warning("The following packages are required, but not available: " + string2);
                } else {
                    Log.warning("The following package is required, but is not available: " + string2);
                }
                Log.warning("See http://beast2.org/managing-packages/ for details on how to install packages.");
            }
        }
        externalJarsLoaded = true;
        Alignment.findDataTypes();
    }

    private static void loadPacakge(String string) {
        block13: {
            try {
                Object object;
                File file = new File(string + "/version.xml");
                String string2 = null;
                if (file.exists()) {
                    try {
                        object = DocumentBuilderFactory.newInstance();
                        String[] stringArray = ((DocumentBuilderFactory)object).newDocumentBuilder().parse(file);
                        Element element = stringArray.getDocumentElement();
                        string2 = element.getAttribute("name") + " v" + element.getAttribute("version");
                        Log.warning.println("Loading package " + string2);
                        Utils.logToSplashScreen("Loading package " + string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!((File)(object = new File(string + "/lib"))).exists()) {
                    object = new File(string + "\\lib");
                }
                if (!((File)object).exists() || !((File)object).isDirectory()) break block13;
                for (String string3 : ((File)object).list()) {
                    Object object2;
                    if (!string3.endsWith(".jar")) continue;
                    Log.debug.print("Probing: " + string3 + " ");
                    String string4 = null;
                    try {
                        JarEntry jarEntry;
                        object2 = new JarInputStream(new FileInputStream(((File)object).getAbsolutePath() + "/" + string3));
                        while (string4 == null && (jarEntry = ((JarInputStream)object2).getNextJarEntry()) != null) {
                            if (!jarEntry.getName().endsWith(".class")) continue;
                            String string5 = jarEntry.getName().replaceAll("/", "\\.");
                            string5 = string5.substring(0, string5.lastIndexOf(46));
                            try {
                                Class.forName(string5);
                                string4 = string5;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (string4 != null || string2 == null) continue;
                            classToPackageMap.put(string5, string2);
                        }
                        ((ZipInputStream)object2).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    object2 = new File(((File)object).getAbsolutePath() + "/" + string3).toURL();
                    if (string4 == null) {
                        AddOnManager.addURL((URL)object2);
                        continue;
                    }
                    Log.debug.println("Skip loading " + object2 + ": contains class " + string4 + " that is already loaded");
                }
            }
            catch (Exception exception) {
                Log.debug.println("Skipping " + string + "/version.xml (unable to open file");
                Log.warning.println("Skipping " + string + "/version.xml (unable to open file");
            }
        }
    }

    public static void populatePackagesToInstall(Map<String, Package> map, Map<Package, PackageVersion> map2) throws DependencyResolutionException {
        HashMap<Package, PackageVersion> hashMap = new HashMap<Package, PackageVersion>(map2);
        for (Map.Entry entry : hashMap.entrySet()) {
            AddOnManager.populatePackagesToInstall(map, map2, (Package)entry.getKey(), (PackageVersion)entry.getValue());
        }
    }

    private static void populatePackagesToInstall(Map<String, Package> map, Map<Package, PackageVersion> map2, Package package_, PackageVersion packageVersion) throws DependencyResolutionException {
        if (!package_.getAvailableVersions().contains(packageVersion)) {
            throw new IllegalArgumentException("Package version " + packageVersion + " is not available.");
        }
        Set<PackageDependency> set = package_.getDependencies(packageVersion);
        for (PackageDependency packageDependency : set) {
            if (!map.containsKey(packageDependency.dependencyName)) {
                throw new DependencyResolutionException("Package " + package_ + " depends on unknown package " + packageDependency.dependencyName);
            }
            Package package_2 = map.get(packageDependency.dependencyName);
            PackageVersion packageVersion2 = map2.get(package_2);
            if (packageVersion2 == null) {
                if (package_2.isInstalled() && packageDependency.isMetBy(package_2.getInstalledVersion())) {
                    continue;
                }
            } else {
                if (packageDependency.isMetBy(packageVersion2)) continue;
                throw new DependencyResolutionException("Package " + package_ + " depends on a different " + "version of package " + packageDependency.dependencyName + " to that required by another package.");
            }
            boolean bl = false;
            for (PackageVersion packageVersion3 : package_2.getAvailableVersions()) {
                if (!packageDependency.isMetBy(packageVersion3) || package_2.isInstalled() && packageVersion3.compareTo(package_2.getInstalledVersion()) < 0) continue;
                map2.put(package_2, packageVersion3);
                try {
                    AddOnManager.populatePackagesToInstall(map, map2, package_2, packageVersion3);
                    bl = true;
                    break;
                }
                catch (DependencyResolutionException dependencyResolutionException) {
                    map2.remove(package_2);
                }
            }
            if (bl) continue;
            throw new DependencyResolutionException("Package " + package_ + " requires " + packageDependency + ", " + "but no installable version of that package was found.");
        }
    }

    private static void checkInstalledDependencies(Map<String, Package> map) {
        HashMap<PackageDependency, Package> hashMap = new HashMap<PackageDependency, Package>();
        for (Package object : map.values()) {
            if (!object.isInstalled()) continue;
            for (PackageDependency packageDependency : object.getInstalledVersionDependencies()) {
                hashMap.put(packageDependency, object);
            }
        }
        for (PackageDependency packageDependency : hashMap.keySet()) {
            Package package_ = map.get(packageDependency.dependencyName);
            Package package_2 = (Package)hashMap.get(packageDependency);
            if (package_ == null) {
                AddOnManager.warning("Package " + package_2.getName() + " requires another package (" + packageDependency.dependencyName + ") which is not available.\n" + "Either uninstall " + package_2.getName() + " or ask the package maintainer for " + "information about this dependency.");
                continue;
            }
            if (!package_.isInstalled()) {
                AddOnManager.warning("Package " + package_2.getName() + " requires another package (" + packageDependency.dependencyName + ") which is not installed.\n" + "Either uninstall " + package_2.getName() + " or install the " + packageDependency.dependencyName + " package.");
                continue;
            }
            if (packageDependency.isMetBy(package_.getInstalledVersion())) continue;
            AddOnManager.warning("Package " + package_2.getName() + " requires another package " + packageDependency + " but the installed " + packageDependency.dependencyName + " has version " + package_.getInstalledVersion() + ".\n" + "Either uninstall " + package_2.getName() + " or install the correct version of " + packageDependency.dependencyName + ".");
        }
    }

    private static void warning(String string) {
        Log.warning.println(string);
        Log.warning.println("Unexpected behavior may follow!");
        if (!GraphicsEnvironment.isHeadless() && System.getProperty("no.beast.popup") == null) {
            JOptionPane.showMessageDialog(null, string + "\nUnexpected behavior may follow!");
        }
    }

    private static void message(String string) {
        Log.info.println(string);
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(null, string);
        }
    }

    public static void addURL(URL uRL) throws IOException {
        Object object;
        Object object2;
        AddOnManager addOnManager = new AddOnManager();
        URLClassLoader uRLClassLoader = (URLClassLoader)addOnManager.getClass().getClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        for (URL uRL2 : uRLArray) {
            if (!uRL2.toString().toLowerCase().equals(uRL.toString().toLowerCase())) continue;
            Log.debug.println("URL " + uRL + " is already in the CLASSPATH");
            return;
        }
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            object2 = new Class[]{URL.class};
            object = clazz.getDeclaredMethod("addURL", (Class<?>)object2);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke((Object)uRLClassLoader, uRL);
            Log.debug.println("Loaded URL " + uRL);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
        object2 = System.getProperty("java.class.path");
        object = uRL + "";
        object2 = (String)object2 + System.getProperty("path.separator") + ((String)object).substring(5);
        System.setProperty("java.class.path", (String)object2);
        all_classes = null;
    }

    private static void loadAllClasses() {
        if (!externalJarsLoaded) {
            try {
                AddOnManager.loadExternalJars();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        all_classes = new ArrayList<String>();
        String string = System.getProperty("path.separator");
        String string2 = System.getProperty("java.class.path");
        for (String string3 : string2.split(string)) {
            File file = new File(string3);
            if (file.isDirectory()) {
                AddOnManager.addDirContent(file, file.getAbsolutePath().length());
                continue;
            }
            if (string3.endsWith(".jar")) {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(file);
                }
                catch (IOException iOException) {
                    Log.debug.println("WARNING: " + file + " could not be opened!");
                    continue;
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().endsWith(".class")) continue;
                    all_classes.add(jarEntry.getName());
                }
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Log.debug.println("WARNING: " + file + " could not be closed!");
                }
                continue;
            }
            if (string3.endsWith(".class")) {
                all_classes.add(string3);
                continue;
            }
            Log.debug.println("Warning: corrupt classpath entry: " + string3);
        }
        Object object = System.getProperty("file.separator");
        if (((String)object).equals("\\")) {
            object = "\\\\";
        }
        for (int i = 0; i < all_classes.size(); ++i) {
            String string4 = all_classes.get(i);
            string4 = string4.substring(0, string4.length() - 6);
            if ((string4 = string4.replaceAll((String)object, ".")).startsWith(".")) {
                string4 = string4.substring(1);
            }
            all_classes.set(i, string4);
        }
    }

    private static void addDirContent(File file, int n) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                AddOnManager.addDirContent(file2, n);
                continue;
            }
            if (!file2.getName().endsWith(".class")) continue;
            all_classes.add(file2.getAbsolutePath().substring(n));
        }
    }

    public static boolean isSubclass(Class<?> clazz, Class<?> clazz2) {
        boolean bl = false;
        Class<?> clazz3 = clazz2;
        do {
            bl = clazz3.equals(clazz);
            if (clazz3.equals(Object.class)) break;
            if (bl) continue;
            clazz3 = clazz3.getSuperclass();
        } while (!bl);
        return bl;
    }

    public static boolean hasInterface(Class<?> clazz, Class<?> clazz2) {
        boolean bl = false;
        Class<?> clazz3 = clazz2;
        block0: do {
            Class<?>[] classArray = clazz3.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].equals(clazz)) continue;
                bl = true;
                continue block0;
            }
        } while ((bl || (clazz3 = clazz3.getSuperclass()) != null && !clazz3.equals(Object.class)) && !bl);
        return bl;
    }

    public static List<String> find(String string, String[] stringArray) {
        List<String> list = new ArrayList<String>();
        try {
            Class<?> clazz = Class.forName(string);
            list = AddOnManager.find(clazz, stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    public static List<String> find(String string, String string2) {
        List<String> list = new ArrayList<String>();
        try {
            Class<?> clazz = Class.forName(string);
            list = AddOnManager.find(clazz, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    public static List<String> find(Class<?> clazz, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.addAll(AddOnManager.find(clazz, stringArray[i]));
        }
        arrayList.addAll(hashSet);
        Collections.sort(arrayList, (string, string2) -> {
            if (string.equals(BEAST_PACKAGE_NAME)) {
                return -1;
            }
            if (string2.equals(BEAST_PACKAGE_NAME)) {
                return 1;
            }
            return string.compareTo((String)string2);
        });
        return arrayList;
    }

    public static List<String> find(Class<?> clazz, String string3) {
        int n;
        if (all_classes == null) {
            AddOnManager.loadAllClasses();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = all_classes.size() - 1; n >= 0; --n) {
            String string4 = all_classes.get(n);
            if (!(string4 = string4.replaceAll("/", ".")).startsWith(string3)) continue;
            try {
                Class<?> clazz2 = Class.forName(string4);
                if ((Modifier.isAbstract(clazz2.getModifiers()) || !clazz.isInterface() || !AddOnManager.hasInterface(clazz, clazz2)) && (clazz2.isInterface() || !AddOnManager.isSubclass(clazz, clazz2))) continue;
                arrayList.add(string4);
                continue;
            }
            catch (Throwable throwable) {
                Log.debug.println("Checking class: " + string4);
                throwable.printStackTrace();
            }
        }
        Collections.sort(arrayList, (string, string2) -> {
            if (string.equals(BEAST_PACKAGE_NAME)) {
                return -1;
            }
            if (string2.equals(BEAST_PACKAGE_NAME)) {
                return 1;
            }
            return string.compareTo((String)string2);
        });
        for (n = arrayList.size() - 1; n > 0; --n) {
            if (!((String)arrayList.get(n)).equals(arrayList.get(n - 1))) continue;
            arrayList.remove(n);
        }
        return arrayList;
    }

    public static void prettyPrintPackageInfo(PrintStream printStream, Map<String, Package> map) {
        String string = "Name";
        String string2 = "Installed Version";
        String string3 = "Latest Version";
        String string4 = "Dependencies";
        String string5 = "Description";
        int n = string.length();
        int n2 = string2.length();
        int n3 = string3.length();
        int n4 = string4.length();
        ArrayList<Package> arrayList = new ArrayList<Package>();
        for (Package object2 : map.values()) {
            arrayList.add(object2);
            n = Math.max(object2.getName().length(), n);
            n2 = Math.max(object2.isInstalled() ? object2.getInstalledVersion().toString().length() : 2, n2);
            n3 = Math.max(n3, object2.isAvailable() ? object2.getLatestVersion().toString().length() : Math.max(2, n2));
            n4 = Math.max(object2.getDependenciesString().length(), n4);
        }
        String string6 = "%-" + n + "s";
        String string7 = "%-" + n2 + "s";
        String string8 = "%-" + n3 + "s";
        String string9 = "%-" + n4 + "s";
        String string10 = " | ";
        printStream.printf(string6, string);
        printStream.print(string10);
        printStream.printf(string7, string2);
        printStream.print(string10);
        printStream.printf(string8, string3);
        printStream.print(string10);
        printStream.printf(string9, string4);
        printStream.print(string10);
        printStream.printf("%s\n", string5);
        int n5 = n + n2 + n3 + n4 + string5.length() + 12;
        for (int i = 0; i < n5; ++i) {
            printStream.print("-");
        }
        printStream.println();
        for (Package package_ : arrayList) {
            if (!package_.getName().equals(BEAST_PACKAGE_NAME)) continue;
            printStream.printf(string6, package_.getName());
            printStream.print(string10);
            printStream.printf(string7, package_.isInstalled() ? package_.getInstalledVersion() : "NA");
            printStream.print(string10);
            printStream.printf(string8, package_.isAvailable() ? package_.getLatestVersion() : "NA");
            printStream.print(string10);
            printStream.printf(string9, package_.getDependenciesString());
            printStream.print(string10);
            printStream.printf("%s\n", package_.getDescription());
        }
        for (int i = 0; i < n5; ++i) {
            printStream.print("-");
        }
        printStream.println();
        for (Package package_ : arrayList) {
            if (package_.getName().equals(BEAST_PACKAGE_NAME)) continue;
            printStream.printf(string6, package_.getName());
            printStream.print(string10);
            printStream.printf(string7, package_.isInstalled() ? package_.getInstalledVersion() : "NA");
            printStream.print(string10);
            printStream.printf(string8, package_.isAvailable() ? package_.getLatestVersion() : "NA");
            printStream.print(string10);
            printStream.printf(string9, package_.getDependenciesString());
            printStream.print(string10);
            printStream.printf("%s\n", package_.getDescription());
        }
    }

    private static void printUsageAndExit(Arguments arguments) {
        arguments.printUsage("addonmanager", "");
        Log.info.println("\nExamples:");
        Log.info.println("addonmanager -list");
        Log.info.println("addonmanager -add SNAPP");
        Log.info.println("addonmanager -useAppDir -add SNAPP");
        Log.info.println("addonmanager -del SNAPP");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            Iterator<String> iterator;
            Map<String, String> map;
            List<String> list;
            boolean bl;
            Object object;
            Object object2;
            Arguments arguments = new Arguments(new Arguments.Option[]{new Arguments.Option("list", "List available packages"), new Arguments.StringOption("add", "NAME", "Install the <NAME> package"), new Arguments.StringOption("del", "NAME", "Uninstall the <NAME> package"), new Arguments.StringOption("version", "NAME", "Specify package version"), new Arguments.Option("useAppDir", "Use application (system wide) installation directory. Note this requires writing rights to the application directory. If not specified, the user's BEAST directory will be used."), new Arguments.StringOption("dir", "DIR", "Install/uninstall package in directory <DIR>. This overrides the useAppDir option"), new Arguments.Option("help", "Show help")});
            try {
                arguments.parseArguments(stringArray);
            }
            catch (Arguments.ArgumentException argumentException) {
                Log.info.println();
                Log.info.println(argumentException.getMessage());
                Log.info.println();
                AddOnManager.printUsageAndExit(arguments);
            }
            if (stringArray.length == 0 || arguments.hasOption("help")) {
                AddOnManager.printUsageAndExit(arguments);
            }
            boolean bl2 = arguments.hasOption("useAppDir");
            String string = arguments.getStringOption("dir");
            if (string != null) {
                object2 = System.getProperty("BEAST_ADDON_PATH");
                System.setProperty("BEAST_ADDON_PATH", (object2 != null ? (String)object2 + ":" : "") + string);
            }
            object2 = AddOnManager.getRepositoryURLs();
            Log.debug.println("Packages user path : " + AddOnManager.getPackageUserDir());
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (URL)object3.next();
                Log.debug.println("Access URL : " + object);
            }
            Log.debug.print("Getting list of packages ...");
            object3 = new TreeMap(String::compareToIgnoreCase);
            try {
                AddOnManager.addInstalledPackages((Map<String, Package>)object3);
                AddOnManager.addAvailablePackages((Map<String, Package>)object3);
            }
            catch (PackageListRetrievalException packageListRetrievalException) {
                Log.warning.println(packageListRetrievalException.getMessage());
                if (packageListRetrievalException.getCause() instanceof IOException) {
                    Log.warning.println(NO_CONNECTION_MESSAGE);
                }
                return;
            }
            Log.debug.println("Done!\n");
            if (arguments.hasOption("list")) {
                AddOnManager.prettyPrintPackageInfo(Log.info, (Map<String, Package>)object3);
            }
            if (arguments.hasOption("add")) {
                object = arguments.getStringOption("add");
                bl = false;
                for (Package package_ : object3.values()) {
                    if (!package_.packageName.equals(object)) continue;
                    bl = true;
                    if (!package_.isInstalled() || arguments.hasOption("version")) {
                        Log.debug.println("Determine packages to install");
                        list = new HashMap();
                        if (arguments.hasOption("version")) {
                            map = arguments.getStringOption("version");
                            iterator = new PackageVersion((String)((Object)map));
                            list.put(package_, iterator);
                            useArchive = true;
                        } else {
                            list.put(package_, package_.getLatestVersion());
                        }
                        try {
                            AddOnManager.populatePackagesToInstall((Map<String, Package>)object3, list);
                        }
                        catch (DependencyResolutionException dependencyResolutionException) {
                            Log.err("Installation aborted: " + dependencyResolutionException.getMessage());
                        }
                        Log.debug.println("Start installation");
                        AddOnManager.prepareForInstall(list, bl2, string);
                        map = AddOnManager.installPackages(list, bl2, string);
                        for (String string2 : map.keySet()) {
                            Log.info.println("Package " + string2 + " is installed in " + map.get(string2) + ".");
                        }
                        continue;
                    }
                    Log.info.println("Installation aborted: " + (String)object + " is already installed.");
                    System.exit(1);
                }
                if (!bl) {
                    Log.info.println("Could not find package '" + (String)object + "' (typo perhaps?)");
                }
            }
            if (arguments.hasOption("del")) {
                object = arguments.getStringOption("del");
                bl = false;
                for (Package package_ : object3.values()) {
                    if (!package_.packageName.equals(object)) continue;
                    bl = true;
                    if (arguments.hasOption("version")) {
                        useArchive = true;
                        list = arguments.getStringOption("version");
                        map = new PackageVersion((String)((Object)list));
                        iterator = AddOnManager.uninstallPackage(package_, (PackageVersion)((Object)map), bl2, string);
                        Log.info.println("Package " + (String)object + " is uninstalled from " + (String)((Object)iterator) + ".");
                        continue;
                    }
                    if (package_.isInstalled()) {
                        list = AddOnManager.getInstalledDependencyNames(package_, (Map<String, Package>)object3);
                        if (list.isEmpty()) {
                            Log.debug.println("Start un-installation");
                            map = AddOnManager.uninstallPackage(package_, bl2, string);
                            Log.info.println("Package " + (String)object + " is uninstalled from " + map + ".");
                            continue;
                        }
                        Log.info.println("Un-installation aborted: " + (String)object + " is used by these other packages: " + String.join((CharSequence)", ", list) + ".");
                        Log.info.println("Remove these packages first.");
                        System.exit(1);
                        continue;
                    }
                    Log.info.println("Un-installation aborted: " + (String)object + " is not installed yet.");
                    System.exit(1);
                }
                if (!bl) {
                    Log.info.println("Could not find package '" + (String)object + "' (typo perhaps?)");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Set<String> getPackagesAndVersions(BEASTInterface bEASTInterface) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        AddOnManager.getPackagesAndVersions(bEASTInterface, linkedHashSet);
        return linkedHashSet;
    }

    private static void getPackagesAndVersions(BEASTInterface bEASTInterface, Set<String> set) {
        String string = classToPackageMap.get(bEASTInterface.getClass().getName());
        if (string != null) {
            set.add(string);
        }
        for (BEASTInterface bEASTInterface2 : bEASTInterface.listActiveBEASTObjects()) {
            AddOnManager.getPackagesAndVersions(bEASTInterface2, set);
        }
    }

    public static boolean isInstalled(String string, String string2) {
        return packages.containsKey(string);
    }

    static {
        classToPackageMap = new HashMap<String, String>();
        packages = new TreeMap();
    }

    public static class DependencyResolutionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DependencyResolutionException(String string) {
            super(string);
        }
    }

    public static class PackageListRetrievalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PackageListRetrievalException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

