/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.Distribution;
import org.apache.commons.math.distribution.NormalDistributionImpl;

@Description(value="A log-normal distribution with mean and variance parameters.")
public class LogNormalDistributionModel
extends ParametricDistribution {
    public final Input<RealParameter> MParameterInput = new Input("M", "M parameter of lognormal distribution. Equal to the mean of the log-transformed distribution.");
    public final Input<RealParameter> SParameterInput = new Input("S", "S parameter of lognormal distribution. Equal to the standard deviation of the log-transformed distribution.");
    public final Input<Boolean> hasMeanInRealSpaceInput = new Input<Boolean>("meanInRealSpace", "Whether the M parameter is in real space, or in log-transformed space. Default false = log-transformed.", false);
    boolean hasMeanInRealSpace;
    LogNormalImpl dist = new LogNormalImpl(0.0, 1.0);

    @Override
    public void initAndValidate() {
        this.hasMeanInRealSpace = this.hasMeanInRealSpaceInput.get();
        if (this.MParameterInput.get() != null) {
            if (this.MParameterInput.get().getLower() == null) {
                this.MParameterInput.get().setLower(Double.NEGATIVE_INFINITY);
            }
            if (this.MParameterInput.get().getUpper() == null) {
                this.MParameterInput.get().setUpper(Double.POSITIVE_INFINITY);
            }
        }
        if (this.SParameterInput.get() != null) {
            if (this.SParameterInput.get().getLower() == null) {
                this.SParameterInput.get().setLower(0.0);
            }
            if (this.SParameterInput.get().getUpper() == null) {
                this.SParameterInput.get().setUpper(Double.POSITIVE_INFINITY);
            }
        }
        this.refresh();
    }

    void refresh() {
        double d = this.SParameterInput.get() == null ? 1.0 : this.SParameterInput.get().getValue();
        double d2 = this.MParameterInput.get() == null ? 0.0 : this.MParameterInput.get().getValue();
        if (this.hasMeanInRealSpace) {
            d2 = Math.log(d2) - 0.5 * d * d;
        }
        this.dist.setMeanAndStdDev(d2, d);
    }

    @Override
    public Distribution getDistribution() {
        this.refresh();
        return this.dist;
    }

    @Override
    public double getMean() {
        if (this.hasMeanInRealSpace) {
            if (this.MParameterInput.get() != null) {
                return (Double)this.offsetInput.get() + this.MParameterInput.get().getValue();
            }
            return (Double)this.offsetInput.get();
        }
        double d = this.SParameterInput.get().getValue();
        double d2 = this.MParameterInput.get().getValue();
        return Math.exp(d2 + d * d / 2.0);
    }

    public class LogNormalImpl
    implements ContinuousDistribution {
        double m_fMean;
        double m_fStdDev;
        NormalDistributionImpl m_normal = new NormalDistributionImpl(0.0, 1.0);

        public LogNormalImpl(double d, double d2) {
            this.setMeanAndStdDev(d, d2);
        }

        void setMeanAndStdDev(double d, double d2) {
            this.m_fMean = d;
            this.m_fStdDev = d2;
            this.m_normal.setMean(d);
            this.m_normal.setStandardDeviation(d2);
        }

        @Override
        public double cumulativeProbability(double d) throws MathException {
            return this.m_normal.cumulativeProbability(Math.log(d));
        }

        @Override
        public double cumulativeProbability(double d, double d2) throws MathException {
            return this.cumulativeProbability(d2) - this.cumulativeProbability(d);
        }

        @Override
        public double inverseCumulativeProbability(double d) throws MathException {
            return Math.exp(this.m_normal.inverseCumulativeProbability(d));
        }

        @Override
        public double density(double d) {
            if (d <= 0.0) {
                return 0.0;
            }
            return this.m_normal.density(Math.log(d)) / d;
        }

        @Override
        public double logDensity(double d) {
            if (d <= 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return this.m_normal.logDensity(Math.log(d)) - Math.log(d);
        }
    }
}

