/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.Nucleotide;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.Node;
import java.util.Arrays;

@Description(value="Jukes Cantor substitution model: all rates equal and uniformly distributed frequencies")
public class JukesCantor
extends SubstitutionModel.Base {
    double[] frequencies;
    EigenDecomposition eigenDecomposition;

    public JukesCantor() {
        this.frequenciesInput.setRule(Input.Validate.OPTIONAL);
        try {
            this.initAndValidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("initAndValidate() call failed when constructing JukesCantor()");
        }
    }

    @Override
    public void initAndValidate() {
        double[] dArray = new double[]{0.0, -1.3333333333333333, -1.3333333333333333, -1.3333333333333333};
        double[] dArray2 = new double[]{1.0, 2.0, 0.0, 0.5, 1.0, -2.0, 0.5, 0.0, 1.0, 2.0, 0.0, -0.5, 1.0, -2.0, -0.5, 0.0};
        double[] dArray3 = new double[]{0.25, 0.25, 0.25, 0.25, 0.125, -0.125, 0.125, -0.125, 0.0, 1.0, 0.0, -1.0, 1.0, 0.0, -1.0, 0.0};
        this.eigenDecomposition = new EigenDecomposition(dArray2, dArray3, dArray);
        if (this.frequenciesInput.get() != null) {
            throw new RuntimeException("Frequencies must not be specified in Jukes-Cantor model. They are assumed equal.");
        }
        this.frequencies = new double[]{0.25, 0.25, 0.25, 0.25};
    }

    @Override
    public double[] getFrequencies() {
        return this.frequencies;
    }

    @Override
    public void getTransitionProbabilities(Node node, double d, double d2, double d3, double[] dArray) {
        double d4 = 1.3333333333333333 * (d - d2);
        double d5 = (1.0 + 3.0 * Math.exp(-d4 * d3)) / 4.0;
        double d6 = (1.0 - Math.exp(-d4 * d3)) / 4.0;
        Arrays.fill(dArray, d6);
        for (int i = 0; i < 4; ++i) {
            dArray[i * 5] = d5;
        }
    }

    @Override
    public EigenDecomposition getEigenDecomposition(Node node) {
        return this.eigenDecomposition;
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Nucleotide;
    }
}

