/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Citation;
import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.Nucleotide;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.Node;

@Description(value="HKY85 (Hasegawa, Kishino & Yano, 1985) substitution model of nucleotide evolution.")
@Citation(value="Hasegawa M, Kishino H, Yano T (1985) Dating the human-ape splitting by a\n  molecular clock of mitochondrial DNA. Journal of Molecular Evolution\n  22:160-174.", DOI="10.1007/BF02101694", year=1985, firstAuthorSurname="hasegawa")
public class HKY
extends SubstitutionModel.NucleotideBase {
    public final Input<RealParameter> kappaInput = new Input("kappa", "kappa parameter in HKY model", Input.Validate.REQUIRED);
    public static final int STATE_COUNT = 4;
    private EigenDecomposition eigenDecomposition = null;
    private EigenDecomposition storedEigenDecomposition = null;
    private boolean updateEigen = true;
    protected boolean updateMatrix = true;
    protected double beta;
    protected double A_R;
    protected double A_Y;
    protected double tab1A;
    protected double tab2A;
    protected double tab3A;
    protected double tab1C;
    protected double tab2C;
    protected double tab3C;
    protected double tab1G;
    protected double tab2G;
    protected double tab3G;
    protected double tab1T;
    protected double tab2T;
    protected double tab3T;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.kappaInput.get().setBounds(Math.max(0.0, (Double)this.kappaInput.get().getLower()), this.kappaInput.get().getUpper());
        this.nrOfStates = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTransitionProbabilities(Node node, double d, double d2, double d3, double[] dArray) {
        double d4 = (d - d2) * d3;
        HKY hKY = this;
        synchronized (hKY) {
            if (this.updateMatrix) {
                this.setupMatrix();
            }
        }
        double d5 = this.beta * d4;
        double d6 = Math.exp(d5 * this.A_R);
        double d7 = Math.exp(d5 * this.A_Y);
        double d8 = Math.exp(d5);
        double d9 = 1.0 - d8;
        double d10 = this.tab1A * d8;
        dArray[0] = this.freqA + d10 + this.tab2A * d6;
        dArray[1] = this.freqC * d9;
        double d11 = this.tab1G * d8;
        dArray[2] = this.freqG + d11 - this.tab3G * d6;
        dArray[3] = this.freqT * d9;
        dArray[4] = this.freqA * d9;
        double d12 = this.tab1C * d8;
        dArray[5] = this.freqC + d12 + this.tab2C * d7;
        dArray[6] = this.freqG * d9;
        double d13 = this.tab1T * d8;
        dArray[7] = this.freqT + d13 - this.tab3T * d7;
        dArray[8] = this.freqA + d10 - this.tab3A * d6;
        dArray[9] = dArray[1];
        dArray[10] = this.freqG + d11 + this.tab2G * d6;
        dArray[11] = dArray[3];
        dArray[12] = dArray[4];
        dArray[13] = this.freqC + d12 - this.tab3C * d7;
        dArray[14] = dArray[6];
        dArray[15] = this.freqT + d13 + this.tab2T * d7;
    }

    @Override
    public EigenDecomposition getEigenDecomposition(Node node) {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        if (this.eigenDecomposition == null) {
            dArray3 = new double[16];
            dArray2 = new double[16];
            dArray = new double[4];
            this.eigenDecomposition = new EigenDecomposition(dArray3, dArray2, dArray);
            dArray2[9] = 1.0;
            dArray2[11] = -1.0;
            dArray2[12] = 1.0;
            dArray2[14] = -1.0;
            dArray3[0] = 1.0;
            dArray3[4] = 1.0;
            dArray3[8] = 1.0;
            dArray3[12] = 1.0;
            this.updateEigen = true;
        }
        if (this.updateEigen) {
            dArray3 = this.eigenDecomposition.getEigenVectors();
            dArray2 = this.eigenDecomposition.getInverseEigenVectors();
            dArray = this.frequencies.getFreqs();
            double d = dArray[0] + dArray[2];
            double d2 = dArray[1] + dArray[3];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            dArray2[3] = dArray[3];
            dArray2[4] = dArray[0] * d2;
            dArray2[5] = -dArray[1] * d;
            dArray2[6] = dArray[2] * d2;
            dArray2[7] = -dArray[3] * d;
            dArray3[1] = 1.0 / d;
            dArray3[5] = -1.0 / d2;
            dArray3[9] = 1.0 / d;
            dArray3[13] = -1.0 / d2;
            dArray3[6] = dArray[3] / d2;
            dArray3[14] = -dArray[1] / d2;
            dArray3[3] = dArray[2] / d;
            dArray3[11] = -dArray[0] / d;
            double[] dArray4 = this.eigenDecomposition.getEigenValues();
            double d3 = this.kappaInput.get().getValue();
            double d4 = -1.0 / (2.0 * (d * d2 + d3 * (dArray[0] * dArray[2] + dArray[1] * dArray[3])));
            double d5 = 1.0 + d * (d3 - 1.0);
            double d6 = 1.0 + d2 * (d3 - 1.0);
            dArray4[1] = d4;
            dArray4[2] = d4 * d6;
            dArray4[3] = d4 * d5;
            this.updateEigen = false;
        }
        return this.eigenDecomposition;
    }

    protected void setupMatrix() {
        this.calculateFreqRY();
        double d = 1.0 / this.freqR - 1.0;
        this.tab1A = this.freqA * d;
        this.tab3A = this.freqA / this.freqR;
        this.tab2A = 1.0 - this.tab3A;
        double d2 = 1.0 / d;
        this.tab1C = this.freqC * d2;
        this.tab3C = this.freqC / this.freqY;
        this.tab2C = 1.0 - this.tab3C;
        this.tab1G = this.freqG * d;
        this.tab3G = this.tab2A;
        this.tab2G = this.tab3A;
        this.tab1T = this.freqT * d2;
        this.tab3T = this.tab2C;
        this.tab2T = this.tab3C;
        double d3 = this.kappaInput.get().getValue();
        this.beta = -1.0 / (2.0 * (this.freqR * this.freqY + d3 * (this.freqA * this.freqG + this.freqC * this.freqT)));
        this.A_R = 1.0 + this.freqR * (d3 - 1.0);
        this.A_Y = 1.0 + this.freqY * (d3 - 1.0);
        this.updateMatrix = false;
    }

    @Override
    protected boolean requiresRecalculation() {
        this.updateMatrix = true;
        this.updateEigen = true;
        return true;
    }

    @Override
    protected void store() {
        if (this.eigenDecomposition != null) {
            this.storedEigenDecomposition = this.eigenDecomposition.copy();
        }
        super.store();
    }

    @Override
    protected void restore() {
        this.updateMatrix = true;
        this.updateEigen = true;
        if (this.storedEigenDecomposition != null) {
            this.eigenDecomposition = this.storedEigenDecomposition;
        }
        super.restore();
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Nucleotide;
    }
}

