/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.Nucleotide;
import beast.evolution.substitutionmodel.Frequencies;
import beast.evolution.substitutionmodel.GeneralSubstitutionModel;
import java.lang.reflect.InvocationTargetException;

@Description(value="General Time Reversible model of nucleotide evolution. Rates that are not specified are assumed to be 1. ")
public class GTR
extends GeneralSubstitutionModel {
    public final Input<Function> rateACInput = new Input("rateAC", "substitution rate for A to C (default 1)");
    public final Input<Function> rateAGInput = new Input("rateAG", "substitution rate for A to G (default 1)");
    public final Input<Function> rateATInput = new Input("rateAT", "substitution rate for A to T (default 1)");
    public final Input<Function> rateCGInput = new Input("rateCG", "substitution rate for C to G (default 1)");
    public final Input<Function> rateCTInput = new Input("rateCT", "substitution rate for C to T (default 1)");
    public final Input<Function> rateGTInput = new Input("rateGT", "substitution rate for G to T (default 1)");
    Function rateAC;
    Function rateAG;
    Function rateAT;
    Function rateCG;
    Function rateCT;
    Function rateGT;

    public GTR() {
        this.ratesInput.setRule(Input.Validate.OPTIONAL);
        try {
            this.ratesInput.setValue(null, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void initAndValidate() {
        if (this.ratesInput.get() != null) {
            throw new IllegalArgumentException("the rates attribute should not be used. Use the individual rates rateAC, rateCG, etc, instead.");
        }
        this.frequencies = (Frequencies)this.frequenciesInput.get();
        this.updateMatrix = true;
        this.nrOfStates = this.frequencies.getFreqs().length;
        if (this.nrOfStates != 4) {
            throw new IllegalArgumentException("Frequencies has wrong size. Expected 4, but got " + this.nrOfStates);
        }
        try {
            this.eigenSystem = this.createEigenSystem();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.rateMatrix = new double[this.nrOfStates][this.nrOfStates];
        this.relativeRates = new double[this.nrOfStates * (this.nrOfStates - 1)];
        this.storedRelativeRates = new double[this.nrOfStates * (this.nrOfStates - 1)];
        this.rateAC = this.getParameter(this.rateACInput);
        this.rateAG = this.getParameter(this.rateAGInput);
        this.rateAT = this.getParameter(this.rateATInput);
        this.rateCG = this.getParameter(this.rateCGInput);
        this.rateCT = this.getParameter(this.rateCTInput);
        this.rateGT = this.getParameter(this.rateGTInput);
    }

    private Function getParameter(Input<Function> input) {
        if (input.get() != null) {
            return input.get();
        }
        return new RealParameter("1.0");
    }

    @Override
    protected void setupRelativeRates() {
        this.relativeRates[0] = this.rateAC.getArrayValue();
        this.relativeRates[1] = this.rateAG.getArrayValue();
        this.relativeRates[2] = this.rateAT.getArrayValue();
        this.relativeRates[3] = this.rateAC.getArrayValue();
        this.relativeRates[4] = this.rateCG.getArrayValue();
        this.relativeRates[5] = this.rateCT.getArrayValue();
        this.relativeRates[6] = this.rateAG.getArrayValue();
        this.relativeRates[7] = this.rateCG.getArrayValue();
        this.relativeRates[8] = this.rateGT.getArrayValue();
        this.relativeRates[9] = this.rateAT.getArrayValue();
        this.relativeRates[10] = this.rateCT.getArrayValue();
        this.relativeRates[11] = this.rateGT.getArrayValue();
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Nucleotide;
    }
}

