/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

public class EigenDecomposition {
    private final double[] Evec;
    private final double[] Ievc;
    private final double[] Eval;
    private final double[] Evali;

    public EigenDecomposition(double[] dArray, double[] dArray2, double[] dArray3) {
        this.Evec = dArray;
        this.Ievc = dArray2;
        this.Eval = dArray3;
        this.Evali = null;
    }

    public EigenDecomposition(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.Evec = dArray;
        this.Ievc = dArray2;
        this.Eval = dArray3;
        this.Evali = dArray4;
    }

    public EigenDecomposition copy() {
        double[] dArray = (double[])this.Evec.clone();
        double[] dArray2 = (double[])this.Ievc.clone();
        double[] dArray3 = (double[])this.Eval.clone();
        return new EigenDecomposition(dArray, dArray2, dArray3);
    }

    public final double[] getEigenVectors() {
        return this.Evec;
    }

    public final double[] getInverseEigenVectors() {
        return this.Ievc;
    }

    public final double[] getEigenValues() {
        return this.Eval;
    }

    public final double[] getImEigenValues() {
        return this.Evali;
    }

    public boolean canReturnComplexDiagonalization() {
        return false;
    }

    public void normalizeEigenValues(double d) {
        int n = this.Eval.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.Eval[n3] = this.Eval[n3] / d;
        }
    }

    public Boolean hasImagEigenvectors() {
        if (this.Evali == null) {
            return false;
        }
        for (int i = 0; i < this.Evali.length; ++i) {
            if (this.Evali[i] == 0.0) continue;
            return true;
        }
        return false;
    }
}

