/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.sitemodel;

import beast.core.BEASTInterface;
import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Input;
import beast.core.StateNode;
import beast.evolution.alignment.Alignment;
import beast.evolution.datatype.DataType;
import beast.evolution.likelihood.TreeLikelihood;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.Node;
import java.util.ArrayList;
import java.util.List;

public interface SiteModelInterface {
    public void setDataType(DataType var1);

    @Description(value="Base implementation of a site model with substitution model and rate categories.", isInheritable=false)
    public static abstract class Base
    extends CalculationNode
    implements SiteModelInterface {
        public final Input<SubstitutionModel> substModelInput = new Input<Object>("substModel", "substitution model along branches in the beast.tree", null, Input.Validate.REQUIRED);
        DataType m_dataType;
        public boolean hasPropInvariantCategory = true;
        protected List<String> conditions = null;

        public abstract boolean integrateAcrossCategories();

        public abstract int getCategoryCount();

        public abstract int getCategoryOfSite(int var1, Node var2);

        public abstract double getRateForCategory(int var1, Node var2);

        public abstract double[] getCategoryRates(Node var1);

        public abstract double getProportionForCategory(int var1, Node var2);

        public abstract double[] getCategoryProportions(Node var1);

        public boolean canSetSubstModel(Object object) {
            SubstitutionModel substitutionModel = (SubstitutionModel)object;
            if (this.m_dataType == null) {
                for (BEASTInterface bEASTInterface : this.getOutputs()) {
                    if (!(bEASTInterface instanceof TreeLikelihood)) continue;
                    TreeLikelihood treeLikelihood = (TreeLikelihood)bEASTInterface;
                    this.m_dataType = ((Alignment)treeLikelihood.dataInput.get()).getDataType();
                    break;
                }
            }
            return this.m_dataType == null || substitutionModel.canHandleDataType(this.m_dataType);
        }

        public void setPropInvariantIsCategory(boolean bl) {
            this.hasPropInvariantCategory = bl;
            this.refresh();
        }

        protected void refresh() {
        }

        public SubstitutionModel getSubstitutionModel() {
            return this.substModelInput.get();
        }

        public List<String> getConditions() {
            return this.conditions;
        }

        public void addCondition(Input<? extends StateNode> input) {
            if (input.get() == null) {
                return;
            }
            if (this.conditions == null) {
                this.conditions = new ArrayList<String>();
            }
            this.conditions.add(input.get().getID());
        }

        @Override
        public void setDataType(DataType dataType) {
            this.m_dataType = dataType;
        }

        public double getProportionInvariant() {
            return 0.0;
        }
    }
}

