/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.util.Randomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Description(value="A generic operator swapping a one or more pairs in a multi-dimensional parameter")
public class SwapOperator
extends Operator {
    public final Input<RealParameter> parameterInput = new Input("parameter", "a real parameter to swap individual values for");
    public final Input<IntegerParameter> intparameterInput = new Input("intparameter", "an integer parameter to swap individual values for", Input.Validate.XOR, this.parameterInput);
    public final Input<Integer> howManyInput = new Input<Integer>("howMany", "number of items to swap, default 1, must be less than half the dimension of the parameter", 1);
    int howMany;
    Parameter<?> parameter;
    private List<Integer> masterList = null;

    @Override
    public void initAndValidate() {
        this.parameter = this.parameterInput.get() != null ? (Parameter)this.parameterInput.get() : (Parameter)this.intparameterInput.get();
        this.howMany = this.howManyInput.get();
        if (this.howMany * 2 > this.parameter.getDimension()) {
            throw new IllegalArgumentException("howMany it too large: must be less than half the dimension of the parameter");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            arrayList.add(i);
        }
        this.masterList = Collections.unmodifiableList(arrayList);
    }

    @Override
    public double proposal() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.masterList);
        for (int i = 0; i < this.howMany; ++i) {
            int n = (Integer)arrayList.remove(Randomizer.nextInt(arrayList.size()));
            int n2 = (Integer)arrayList.remove(Randomizer.nextInt(arrayList.size()));
            this.parameter.swap(n, n2);
        }
        return 0.0;
    }
}

