/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.operators.CompoundParameterHelper;
import beast.util.Randomizer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Description(value="A generic operator for use with a sum-constrained (possibly weighted) vector parameter.")
public class DeltaExchangeOperator
extends Operator {
    public final Input<List<RealParameter>> parameterInput = new Input("parameter", "if specified, this parameter is operated on", new ArrayList());
    public final Input<List<IntegerParameter>> intparameterInput = new Input("intparameter", "if specified, this parameter is operated on", new ArrayList());
    public final Input<Double> deltaInput = new Input<Double>("delta", "Magnitude of change for two randomly picked values.", 1.0);
    public final Input<Boolean> autoOptimizeiInput = new Input<Boolean>("autoOptimize", "if true, window size will be adjusted during the MCMC run to improve mixing.", true);
    public final Input<Boolean> integerOperatorInput = new Input<Boolean>("integer", "if true, changes are all integers.", false);
    public final Input<IntegerParameter> parameterWeightsInput = new Input("weightvector", "weights on a vector parameter");
    private boolean autoOptimize;
    private double delta;
    private boolean isIntegerOperator;
    private CompoundParameterHelper compoundParameter = null;

    private int[] weights() {
        int[] nArray;
        if (this.compoundParameter == null) {
            nArray = this.parameterInput.get().isEmpty() ? (this.intparameterInput.get().size() > 0 ? new int[this.intparameterInput.get().get(0).getDimension()] : new int[]{}) : new int[this.parameterInput.get().get(0).getDimension()];
        } else {
            if (this.compoundParameter.getDimension() < 1) {
                throw new IllegalArgumentException("Compound parameter is not created properly, dimension = " + this.compoundParameter.getDimension());
            }
            nArray = new int[this.compoundParameter.getDimension()];
        }
        if (this.parameterWeightsInput.get() != null) {
            if (nArray.length != this.parameterWeightsInput.get().getDimension()) {
                throw new IllegalArgumentException("Weights vector should have the same length as parameter dimension");
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)this.parameterWeightsInput.get().getValue(i);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 1;
            }
        }
        return nArray;
    }

    @Override
    public void initAndValidate() {
        int n;
        this.autoOptimize = this.autoOptimizeiInput.get();
        this.delta = this.deltaInput.get();
        this.isIntegerOperator = this.integerOperatorInput.get();
        if (this.parameterInput.get().isEmpty()) {
            if (this.intparameterInput.get().size() > 1) {
                for (n = 0; n < this.intparameterInput.get().size(); ++n) {
                    for (int i = n + 1; i < this.intparameterInput.get().size(); ++i) {
                        if (this.intparameterInput.get().get(n) != this.intparameterInput.get().get(i)) continue;
                        throw new RuntimeException("Duplicate intparameter (" + this.intparameterInput.get().get(i).getID() + ") found in operator " + this.getID());
                    }
                }
                this.compoundParameter = new CompoundParameterHelper(this.intparameterInput.get());
            }
        } else if (this.parameterInput.get().size() > 1) {
            for (n = 0; n < this.parameterInput.get().size(); ++n) {
                for (int i = n + 1; i < this.parameterInput.get().size(); ++i) {
                    if (this.parameterInput.get().get(n) != this.parameterInput.get().get(i)) continue;
                    throw new RuntimeException("Duplicate intparameter (" + this.parameterInput.get().get(i).getID() + ") found in operator " + this.getID());
                }
            }
            this.compoundParameter = new CompoundParameterHelper(this.parameterInput.get());
        }
        if (this.isIntegerOperator && this.delta != (double)Math.round(this.delta)) {
            throw new IllegalArgumentException("Can't be an integer operator if delta is not integer");
        }
        n = -1;
        n = this.compoundParameter == null ? (!this.parameterInput.get().isEmpty() ? this.parameterInput.get().get(0).getDimension() : this.intparameterInput.get().get(0).getDimension()) : this.compoundParameter.getDimension();
        if (n <= 1) {
            Log.warning.println("WARNING: the dimension of the parameter is " + n + " at the start of the run.\n" + "         The operator " + this.getID() + " has no effect (if this does not change).");
        }
    }

    @Override
    public final double proposal() {
        int[] nArray = this.weights();
        int n = nArray.length;
        int n2 = 0;
        for (int n3 : nArray) {
            if (n3 == 0) continue;
            ++n2;
        }
        if (n2 <= 1) {
            return 0.0;
        }
        int n4 = Randomizer.nextInt(n2);
        int n5 = Randomizer.nextInt(n2 - 1);
        if (n5 >= n4) {
            ++n5;
        }
        if (n2 < n) {
            int n3;
            int n6 = n4;
            n3 = n5;
            n4 = 0;
            n5 = 0;
            while (n6 > 0 | nArray[n4] == 0) {
                if (nArray[n4] != 0) {
                    --n6;
                }
                ++n4;
            }
            while (n3 > 0 | nArray[n5] == 0) {
                if (nArray[n5] != 0) {
                    --n3;
                }
                ++n5;
            }
        }
        double d = 0.0;
        if (this.compoundParameter == null) {
            RealParameter realParameter = null;
            IntegerParameter integerParameter = null;
            if (this.parameterInput.get().isEmpty()) {
                integerParameter = this.intparameterInput.get().get(0);
            } else {
                realParameter = this.parameterInput.get().get(0);
            }
            if (integerParameter == null) {
                double d2 = (Double)realParameter.getValue(n4);
                double d3 = (Double)realParameter.getValue(n5);
                if (this.isIntegerOperator) {
                    int n7 = Randomizer.nextInt((int)Math.round(this.delta)) + 1;
                    if (nArray[n4] != nArray[n5]) {
                        throw new RuntimeException();
                    }
                    d2 = Math.round(d2 - (double)n7);
                    d3 = Math.round(d3 + (double)n7);
                } else {
                    double d4 = Randomizer.nextDouble() * this.delta;
                    d2 -= d4;
                    d3 = nArray[n4] != nArray[n5] ? (d3 += d4 * (double)nArray[n4] / (double)nArray[n5]) : (d3 += d4);
                }
                if (d2 < (Double)realParameter.getLower() || d2 > (Double)realParameter.getUpper() || d3 < (Double)realParameter.getLower() || d3 > (Double)realParameter.getUpper()) {
                    d = Double.NEGATIVE_INFINITY;
                } else {
                    realParameter.setValue(n4, d2);
                    realParameter.setValue(n5, d3);
                }
            } else {
                int n8 = (Integer)integerParameter.getValue(n4);
                int n9 = (Integer)integerParameter.getValue(n5);
                int n10 = Randomizer.nextInt((int)Math.round(this.delta)) + 1;
                if (nArray[n4] != nArray[n5]) {
                    throw new RuntimeException();
                }
                n8 = Math.round(n8 - n10);
                n9 = Math.round(n9 + n10);
                if (n8 < (Integer)integerParameter.getLower() || n8 > (Integer)integerParameter.getUpper() || n9 < (Integer)integerParameter.getLower() || n9 > (Integer)integerParameter.getUpper()) {
                    d = Double.NEGATIVE_INFINITY;
                } else {
                    integerParameter.setValue(n4, n8);
                    integerParameter.setValue(n5, n9);
                }
            }
        } else if (this.intparameterInput.get().isEmpty()) {
            double d5 = (Double)this.compoundParameter.getValue(n4);
            double d6 = (Double)this.compoundParameter.getValue(n5);
            if (this.isIntegerOperator) {
                int n11 = Randomizer.nextInt((int)Math.round(this.delta)) + 1;
                if (nArray[n4] != nArray[n5]) {
                    throw new RuntimeException();
                }
                d5 = Math.round(d5 - (double)n11);
                d6 = Math.round(d6 + (double)n11);
            } else {
                double d7 = Randomizer.nextDouble() * this.delta;
                d5 -= d7;
                d6 = nArray[n4] != nArray[n5] ? (d6 += d7 * (double)nArray[n4] / (double)nArray[n5]) : (d6 += d7);
            }
            if (d5 < (Double)this.compoundParameter.getLower(n4) || d5 > (Double)this.compoundParameter.getUpper(n4) || d6 < (Double)this.compoundParameter.getLower(n5) || d6 > (Double)this.compoundParameter.getUpper(n5)) {
                d = Double.NEGATIVE_INFINITY;
            } else {
                this.compoundParameter.setValue(n4, d5);
                this.compoundParameter.setValue(n5, d6);
            }
        } else {
            int n12 = (Integer)this.compoundParameter.getValue(n4);
            int n13 = (Integer)this.compoundParameter.getValue(n5);
            int n14 = Randomizer.nextInt((int)Math.round(this.delta)) + 1;
            if (nArray[n4] != nArray[n5]) {
                throw new RuntimeException();
            }
            n12 = Math.round(n12 - n14);
            n13 = Math.round(n13 + n14);
            if (n12 < (Integer)this.compoundParameter.getLower(n4) || n12 > (Integer)this.compoundParameter.getUpper(n4) || n13 < (Integer)this.compoundParameter.getLower(n5) || n13 > (Integer)this.compoundParameter.getUpper(n5)) {
                d = Double.NEGATIVE_INFINITY;
            } else {
                this.compoundParameter.setValue(n4, n12);
                this.compoundParameter.setValue(n5, n13);
            }
        }
        return d;
    }

    @Override
    public double getCoercableParameterValue() {
        return this.delta;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.delta = d;
    }

    @Override
    public void optimize(double d) {
        if (this.autoOptimize) {
            double d2 = this.calcDelta(d);
            this.delta = Math.exp(d2 += Math.log(this.delta));
            if (this.isIntegerOperator) {
                this.delta = Math.max(0.5000000001, this.delta);
            }
        }
    }

    @Override
    public final String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = this.delta * d3;
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try setting delta to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try setting delta to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

