/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.likelihood;

import beast.evolution.likelihood.LikelihoodCore;

public class BeerLikelihoodCore
extends LikelihoodCore {
    protected int nrOfStates;
    protected int nrOfNodes;
    protected int nrOfPatterns;
    protected int partialsSize;
    protected int matrixSize;
    protected int nrOfMatrices;
    protected boolean integrateCategories;
    protected double[][][] partials;
    protected int[][] states;
    protected double[][][] matrices;
    protected int[] currentMatrixIndex;
    protected int[] storedMatrixIndex;
    protected int[] currentPartialsIndex;
    protected int[] storedPartialsIndex;
    protected boolean useScaling = false;
    protected double[][][] scalingFactors;
    private double scalingThreshold = 1.0E-100;
    double SCALE = 2.0;

    public BeerLikelihoodCore(int n) {
        this.nrOfStates = n;
    }

    protected void calculateStatesStatesPruning(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2, double[] dArray3) {
        int n = 0;
        for (int i = 0; i < this.nrOfMatrices; ++i) {
            for (int j = 0; j < this.nrOfPatterns; ++j) {
                int n2;
                int n3 = nArray[j];
                int n4 = nArray2[j];
                int n5 = i * this.matrixSize;
                if (n3 < this.nrOfStates && n4 < this.nrOfStates) {
                    for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                        dArray3[n] = dArray[n5 + n3] * dArray2[n5 + n4];
                        ++n;
                        n5 += this.nrOfStates;
                    }
                    continue;
                }
                if (n3 < this.nrOfStates) {
                    for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                        dArray3[n] = dArray[n5 + n3];
                        ++n;
                        n5 += this.nrOfStates;
                    }
                    continue;
                }
                if (n4 < this.nrOfStates) {
                    for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                        dArray3[n] = dArray2[n5 + n4];
                        ++n;
                        n5 += this.nrOfStates;
                    }
                    continue;
                }
                for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                    dArray3[n] = 1.0;
                    ++n;
                }
            }
        }
    }

    protected void calculateStatesPartialsPruning(int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrOfMatrices; ++i) {
            for (int j = 0; j < this.nrOfPatterns; ++j) {
                int n3;
                double d;
                int n4;
                int n5 = nArray[j];
                int n6 = i * this.matrixSize;
                if (n5 < this.nrOfStates) {
                    for (n4 = 0; n4 < this.nrOfStates; ++n4) {
                        double d2 = dArray[n6 + n5];
                        d = 0.0;
                        for (n3 = 0; n3 < this.nrOfStates; ++n3) {
                            d += dArray3[n6] * dArray2[n2 + n3];
                            ++n6;
                        }
                        dArray4[n] = d2 * d;
                        ++n;
                    }
                    n2 += this.nrOfStates;
                    continue;
                }
                for (n4 = 0; n4 < this.nrOfStates; ++n4) {
                    d = 0.0;
                    for (n3 = 0; n3 < this.nrOfStates; ++n3) {
                        d += dArray3[n6] * dArray2[n2 + n3];
                        ++n6;
                    }
                    dArray4[n] = d;
                    ++n;
                }
                n2 += this.nrOfStates;
            }
        }
    }

    protected void calculatePartialsPartialsPruning(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrOfMatrices; ++i) {
            for (int j = 0; j < this.nrOfPatterns; ++j) {
                int n3 = i * this.matrixSize;
                for (int k = 0; k < this.nrOfStates; ++k) {
                    double d = 0.0;
                    double d2 = 0.0;
                    for (int i2 = 0; i2 < this.nrOfStates; ++i2) {
                        d2 += dArray2[n3] * dArray[n2 + i2];
                        d += dArray4[n3] * dArray3[n2 + i2];
                        ++n3;
                    }
                    dArray5[n] = d2 * d;
                    ++n;
                }
                n2 += this.nrOfStates;
            }
        }
    }

    protected void calculateStatesStatesPruning(int[] nArray, double[] dArray, int[] nArray2, double[] dArray2, double[] dArray3, int[] nArray3) {
        int n = 0;
        for (int i = 0; i < this.nrOfPatterns; ++i) {
            int n2;
            int n3 = nArray[i];
            int n4 = nArray2[i];
            int n5 = nArray3[i] * this.matrixSize;
            if (n3 < this.nrOfStates && n4 < this.nrOfStates) {
                for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                    dArray3[n] = dArray[n5 + n3] * dArray2[n5 + n4];
                    ++n;
                    n5 += this.nrOfStates;
                }
                continue;
            }
            if (n3 < this.nrOfStates) {
                for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                    dArray3[n] = dArray[n5 + n3];
                    ++n;
                    n5 += this.nrOfStates;
                }
                continue;
            }
            if (n4 < this.nrOfStates) {
                for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                    dArray3[n] = dArray2[n5 + n4];
                    ++n;
                    n5 += this.nrOfStates;
                }
                continue;
            }
            for (n2 = 0; n2 < this.nrOfStates; ++n2) {
                dArray3[n] = 1.0;
                ++n;
            }
        }
    }

    protected void calculateStatesPartialsPruning(int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrOfPatterns; ++i) {
            int n3;
            double d;
            int n4;
            int n5 = nArray[i];
            int n6 = nArray2[i] * this.matrixSize;
            if (n5 < this.nrOfStates) {
                for (n4 = 0; n4 < this.nrOfStates; ++n4) {
                    double d2 = dArray[n6 + n5];
                    d = 0.0;
                    for (n3 = 0; n3 < this.nrOfStates; ++n3) {
                        d += dArray3[n6] * dArray2[n2 + n3];
                        ++n6;
                    }
                    dArray4[n] = d2 * d;
                    ++n;
                }
                n2 += this.nrOfStates;
                continue;
            }
            for (n4 = 0; n4 < this.nrOfStates; ++n4) {
                d = 0.0;
                for (n3 = 0; n3 < this.nrOfStates; ++n3) {
                    d += dArray3[n6] * dArray2[n2 + n3];
                    ++n6;
                }
                dArray4[n] = d;
                ++n;
            }
            n2 += this.nrOfStates;
        }
    }

    protected void calculatePartialsPartialsPruning(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrOfPatterns; ++i) {
            int n3 = nArray[i] * this.matrixSize;
            for (int j = 0; j < this.nrOfStates; ++j) {
                double d = 0.0;
                double d2 = 0.0;
                for (int k = 0; k < this.nrOfStates; ++k) {
                    d2 += dArray2[n3] * dArray[n2 + k];
                    d += dArray4[n3] * dArray3[n2 + k];
                    ++n3;
                }
                dArray5[n] = d2 * d;
                ++n;
            }
            n2 += this.nrOfStates;
        }
    }

    @Override
    protected void calculateIntegratePartials(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.nrOfPatterns; ++n2) {
            for (n = 0; n < this.nrOfStates; ++n) {
                dArray3[n3] = dArray[n4] * dArray2[0];
                ++n3;
                ++n4;
            }
        }
        for (n2 = 1; n2 < this.nrOfMatrices; ++n2) {
            n3 = 0;
            for (n = 0; n < this.nrOfPatterns; ++n) {
                for (int i = 0; i < this.nrOfStates; ++i) {
                    int n5 = n3++;
                    dArray3[n5] = dArray3[n5] + dArray[n4] * dArray2[n2];
                    ++n4;
                }
            }
        }
    }

    @Override
    public void calculateLogLikelihoods(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = 0;
        for (int i = 0; i < this.nrOfPatterns; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.nrOfStates; ++j) {
                d += dArray2[j] * dArray[n];
                ++n;
            }
            dArray3[i] = Math.log(d) + this.getLogScalingFactor(i);
        }
    }

    @Override
    public void initialize(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.nrOfNodes = n;
        this.nrOfPatterns = n2;
        this.nrOfMatrices = n3;
        this.integrateCategories = bl;
        this.partialsSize = bl ? n2 * this.nrOfStates * n3 : n2 * this.nrOfStates;
        this.partials = new double[2][n][];
        this.currentMatrixIndex = new int[n];
        this.storedMatrixIndex = new int[n];
        this.currentPartialsIndex = new int[n];
        this.storedPartialsIndex = new int[n];
        this.states = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.partials[0][i] = null;
            this.partials[1][i] = null;
            this.states[i] = null;
        }
        this.matrixSize = this.nrOfStates * this.nrOfStates;
        this.matrices = new double[2][n][n3 * this.matrixSize];
    }

    @Override
    public void finalize() throws Throwable {
        this.nrOfNodes = 0;
        this.nrOfPatterns = 0;
        this.nrOfMatrices = 0;
        this.partials = null;
        this.currentPartialsIndex = null;
        this.storedPartialsIndex = null;
        this.states = null;
        this.matrices = null;
        this.currentMatrixIndex = null;
        this.storedMatrixIndex = null;
        this.scalingFactors = null;
    }

    @Override
    public void setUseScaling(double d) {
        boolean bl = this.useScaling = d != 1.0;
        if (this.useScaling) {
            this.scalingFactors = new double[2][this.nrOfNodes][this.nrOfPatterns];
        }
    }

    @Override
    public void createNodePartials(int n) {
        this.partials[0][n] = new double[this.partialsSize];
        this.partials[1][n] = new double[this.partialsSize];
    }

    @Override
    public void setNodePartials(int n, double[] dArray) {
        if (this.partials[0][n] == null) {
            this.createNodePartials(n);
        }
        if (dArray.length < this.partialsSize) {
            int n2 = 0;
            for (int i = 0; i < this.nrOfMatrices; ++i) {
                System.arraycopy(dArray, 0, this.partials[0][n], n2, dArray.length);
                n2 += dArray.length;
            }
        } else {
            System.arraycopy(dArray, 0, this.partials[0][n], 0, dArray.length);
        }
    }

    @Override
    public void getNodePartials(int n, double[] dArray) {
        System.arraycopy(this.partials[this.currentPartialsIndex[n]][n], 0, dArray, 0, dArray.length);
    }

    public void createNodeStates(int n) {
        this.states[n] = new int[this.nrOfPatterns];
    }

    @Override
    public void setNodeStates(int n, int[] nArray) {
        if (this.states[n] == null) {
            this.createNodeStates(n);
        }
        System.arraycopy(nArray, 0, this.states[n], 0, this.nrOfPatterns);
    }

    @Override
    public void getNodeStates(int n, int[] nArray) {
        System.arraycopy(this.states[n], 0, nArray, 0, this.nrOfPatterns);
    }

    @Override
    public void setNodeMatrixForUpdate(int n) {
        this.currentMatrixIndex[n] = 1 - this.currentMatrixIndex[n];
    }

    @Override
    public void setNodeMatrix(int n, int n2, double[] dArray) {
        System.arraycopy(dArray, 0, this.matrices[this.currentMatrixIndex[n]][n], n2 * this.matrixSize, this.matrixSize);
    }

    public void setPaddedNodeMatrices(int n, double[] dArray) {
        System.arraycopy(dArray, 0, this.matrices[this.currentMatrixIndex[n]][n], 0, this.nrOfMatrices * this.matrixSize);
    }

    @Override
    public void getNodeMatrix(int n, int n2, double[] dArray) {
        System.arraycopy(this.matrices[this.currentMatrixIndex[n]][n], n2 * this.matrixSize, dArray, 0, this.matrixSize);
    }

    @Override
    public void setNodePartialsForUpdate(int n) {
        this.currentPartialsIndex[n] = 1 - this.currentPartialsIndex[n];
    }

    public void setCurrentNodePartials(int n, double[] dArray) {
        if (dArray.length < this.partialsSize) {
            int n2 = 0;
            for (int i = 0; i < this.nrOfMatrices; ++i) {
                System.arraycopy(dArray, 0, this.partials[this.currentPartialsIndex[n]][n], n2, dArray.length);
                n2 += dArray.length;
            }
        } else {
            System.arraycopy(dArray, 0, this.partials[this.currentPartialsIndex[n]][n], 0, dArray.length);
        }
    }

    @Override
    public void calculatePartials(int n, int n2, int n3) {
        if (this.states[n] != null) {
            if (this.states[n2] != null) {
                this.calculateStatesStatesPruning(this.states[n], this.matrices[this.currentMatrixIndex[n]][n], this.states[n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n3]][n3]);
            } else {
                this.calculateStatesPartialsPruning(this.states[n], this.matrices[this.currentMatrixIndex[n]][n], this.partials[this.currentPartialsIndex[n2]][n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n3]][n3]);
            }
        } else if (this.states[n2] != null) {
            this.calculateStatesPartialsPruning(this.states[n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n]][n], this.matrices[this.currentMatrixIndex[n]][n], this.partials[this.currentPartialsIndex[n3]][n3]);
        } else {
            this.calculatePartialsPartialsPruning(this.partials[this.currentPartialsIndex[n]][n], this.matrices[this.currentMatrixIndex[n]][n], this.partials[this.currentPartialsIndex[n2]][n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n3]][n3]);
        }
        if (this.useScaling) {
            this.scalePartials(n3);
        }
    }

    public void calculatePartials(int n, int n2, int n3, int[] nArray) {
        if (this.states[n] != null) {
            if (this.states[n2] != null) {
                this.calculateStatesStatesPruning(this.states[n], this.matrices[this.currentMatrixIndex[n]][n], this.states[n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n3]][n3], nArray);
            } else {
                this.calculateStatesPartialsPruning(this.states[n], this.matrices[this.currentMatrixIndex[n]][n], this.partials[this.currentPartialsIndex[n2]][n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n3]][n3], nArray);
            }
        } else if (this.states[n2] != null) {
            this.calculateStatesPartialsPruning(this.states[n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n]][n], this.matrices[this.currentMatrixIndex[n]][n], this.partials[this.currentPartialsIndex[n3]][n3], nArray);
        } else {
            this.calculatePartialsPartialsPruning(this.partials[this.currentPartialsIndex[n]][n], this.matrices[this.currentMatrixIndex[n]][n], this.partials[this.currentPartialsIndex[n2]][n2], this.matrices[this.currentMatrixIndex[n2]][n2], this.partials[this.currentPartialsIndex[n3]][n3], nArray);
        }
        if (this.useScaling) {
            this.scalePartials(n3);
        }
    }

    @Override
    public void integratePartials(int n, double[] dArray, double[] dArray2) {
        this.calculateIntegratePartials(this.partials[this.currentPartialsIndex[n]][n], dArray, dArray2);
    }

    protected void scalePartials(int n) {
        int n2 = 0;
        for (int i = 0; i < this.nrOfPatterns; ++i) {
            int n3;
            int n4;
            double d = 0.0;
            int n5 = n2;
            for (n4 = 0; n4 < this.nrOfMatrices; ++n4) {
                for (n3 = 0; n3 < this.nrOfStates; ++n3) {
                    if (this.partials[this.currentPartialsIndex[n]][n][n5] > d) {
                        d = this.partials[this.currentPartialsIndex[n]][n][n5];
                    }
                    ++n5;
                }
                n5 += (this.nrOfPatterns - 1) * this.nrOfStates;
            }
            if (d < this.scalingThreshold) {
                n5 = n2;
                for (n4 = 0; n4 < this.nrOfMatrices; ++n4) {
                    for (n3 = 0; n3 < this.nrOfStates; ++n3) {
                        double[] dArray = this.partials[this.currentPartialsIndex[n]][n];
                        int n6 = n5++;
                        dArray[n6] = dArray[n6] / d;
                    }
                    n5 += (this.nrOfPatterns - 1) * this.nrOfStates;
                }
                this.scalingFactors[this.currentPartialsIndex[n]][n][i] = Math.log(d);
            } else {
                this.scalingFactors[this.currentPartialsIndex[n]][n][i] = 0.0;
            }
            n2 += this.nrOfStates;
        }
    }

    @Override
    public double getLogScalingFactor(int n) {
        double d = 0.0;
        if (this.useScaling) {
            for (int i = 0; i < this.nrOfNodes; ++i) {
                d += this.scalingFactors[this.currentPartialsIndex[i]][i][n];
            }
        }
        return d;
    }

    public void getPartials(int n, double[] dArray) {
        double[] dArray2 = this.partials[this.currentPartialsIndex[n]][n];
        System.arraycopy(dArray2, 0, dArray, 0, this.partialsSize);
    }

    @Override
    public void restore() {
        int[] nArray = this.currentMatrixIndex;
        this.currentMatrixIndex = this.storedMatrixIndex;
        this.storedMatrixIndex = nArray;
        int[] nArray2 = this.currentPartialsIndex;
        this.currentPartialsIndex = this.storedPartialsIndex;
        this.storedPartialsIndex = nArray2;
    }

    @Override
    public void unstore() {
        System.arraycopy(this.storedMatrixIndex, 0, this.currentMatrixIndex, 0, this.nrOfNodes);
        System.arraycopy(this.storedPartialsIndex, 0, this.currentPartialsIndex, 0, this.nrOfNodes);
    }

    @Override
    public void store() {
        System.arraycopy(this.currentMatrixIndex, 0, this.storedMatrixIndex, 0, this.nrOfNodes);
        System.arraycopy(this.currentPartialsIndex, 0, this.storedPartialsIndex, 0, this.nrOfNodes);
    }
}

