/*
 * Decompiled with CFR 0.152.
 */
package beast.core.util;

import beast.core.BEASTObject;
import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.parameter.BooleanParameter;
import beast.core.parameter.IntegerParameter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Description(value="calculates sum of a valuable")
public class Sum
extends CalculationNode
implements Function,
Loggable {
    public final Input<List<Function>> functionInput = new Input("arg", "argument to be summed", new ArrayList(), Input.Validate.REQUIRED);
    Mode mode;
    boolean needsRecompute = true;
    double sum = 0.0;
    double storedSum = 0.0;

    @Override
    public void initAndValidate() {
        List<Function> list = this.functionInput.get();
        this.mode = Mode.integer_mode;
        for (Function function : list) {
            if (function instanceof IntegerParameter || function instanceof BooleanParameter) continue;
            this.mode = Mode.double_mode;
        }
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getArrayValue() {
        if (this.needsRecompute) {
            this.compute();
        }
        return this.sum;
    }

    void compute() {
        this.sum = 0.0;
        for (Function function : this.functionInput.get()) {
            for (int i = 0; i < function.getDimension(); ++i) {
                this.sum += function.getArrayValue(i);
            }
        }
        this.needsRecompute = false;
    }

    @Override
    public double getArrayValue(int n) {
        if (n == 0) {
            return this.getArrayValue();
        }
        return Double.NaN;
    }

    @Override
    public void store() {
        this.storedSum = this.sum;
        super.store();
    }

    @Override
    public void restore() {
        this.sum = this.storedSum;
        super.restore();
    }

    @Override
    public boolean requiresRecalculation() {
        this.needsRecompute = true;
        return true;
    }

    @Override
    public void init(PrintStream printStream) {
        printStream.print("sum(" + ((BEASTObject)((Object)this.functionInput.get().get(0))).getID() + ")\t");
    }

    @Override
    public void log(int n, PrintStream printStream) {
        double d = 0.0;
        for (Function function : this.functionInput.get()) {
            for (int i = 0; i < function.getDimension(); ++i) {
                d += function.getArrayValue(i);
            }
        }
        if (this.mode == Mode.integer_mode) {
            printStream.print((int)d + "\t");
        } else {
            printStream.print(d + "\t");
        }
    }

    @Override
    public void close(PrintStream printStream) {
    }

    static enum Mode {
        integer_mode,
        double_mode;

    }
}

